/*
 * Copyright 1996 by E. Toernig (froese@gmx.de)
 */
#ifndef EMIT_H
#define EMIT_H

#include <unistd.h>
#include <sys/stat.h>

#define MAGIC_1		0xe8
#define MAGIC_2		0x81

#define T_RESET		0xf1
#define T_COMMENT	0xf2
#define T_NAME		0xf3
#define T_PUBLIC	0xf4
#define T_ENTER_DIR	0xf5
#define T_LEAVE_DIR	0xf6

struct entry
{
    struct entry *next;
    dev_t dev;
    umode_t mode;
    u32 inode;
    u32 size;
    u32 date;
    uid_t uid;
    gid_t gid;
    char name[1];
};

void emit_open(char *name, int security);
void emit_close();
void emit_reset(int days, int flags, char *info);
void emit_comment(char *str);
int emit_name(char *str);
void emit_enter_dir(struct entry *dir, char *path);
void emit_leave_dir(struct entry *dir, char *path);
void emit_file(struct entry *file, char *path);
struct entry *alloc_entry(struct entry *next, char *name, struct stat *st);

#endif /* EMIT_H */
