/***********************************************************/
/* File:  getInk.c                                         */
/*                                                         */
/* Function: GUI for showing remainnin ink quantity        */
/*                                                         */
/* Author:   Jean-Jacques Sarton jj.sarton@t-online.de     */
/*                                                         */
/* Licence:  This is free software according ro GPL        */
/*           the binary rwLib.o is not free. Reverse       */
/*           engrineering is not allowed, however you may  */
/*           use it in own applications.                   */        
/*                                                         */
/* Changes:   DEC-11.99  removed asking status of LP (this */
/*            may cause problems                           */
/*            open, read and write calls are all timed out */
/*            this will avoid locking                      */
/*                                                         */
/* Version: V1.1                                           */
/***********************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>

#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>

#include <X11/Xaw/Form.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/List.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Text.h>

#include <signal.h>
#include <fcntl.h>
#include <linux/lp.h>
#include <sys/time.h>
#include "rwLib.h"

#define OPEN_WRITE_TIMEOUT 100

#define RESET_TIMER(ti,oti) { memset((void*)&ti,0,sizeof(ti)); \
                              memset((void*)&oti,0,sizeof(oti)); \
                              setitimer( ITIMER_REAL ,&ti, &oti); \
                            }

#define SET_TIMER(ti,oti,val) { signal(SIGALRM, sigAlarm); \
                                memset((void*)&ti,0,sizeof(ti)); \
                                memset((void*)&oti,0,sizeof(oti)); \
                                ti.it_value.tv_sec  = val/1000; \
                                ti.it_value.tv_usec = (val%1000)*1000; \
                                setitimer( ITIMER_REAL ,&ti, &oti); \
                              }

int debug  = 0;
char port[100];
unsigned char ibuf[8092];

static void receive(int);

typedef struct {
    char        *display;
    char        *dev;
    char        *timeout;
    char        *title;
    char        *debug;
} xwAppResourceRec;
xwAppResourceRec	app_resource_rec, appParams;


static XrmOptionDescRec optionDescList[] = {
    {"-display", "display", XrmoptionSepArg, (XPointer)NULL},
    {"-dev",     "dev",     XrmoptionResArg, (XPointer)NULL},
    {"-timeout", "timeout", XrmoptionResArg, (XPointer)NULL},
    {"-debug",   "debug",   XrmoptionResArg, (XPointer)NULL},
};

static XtResource resources[] = {
    {"display", "*display", XtRString, sizeof(String),
        XtOffsetOf(xwAppResourceRec, display), XtRImmediate,
                                    (XtPointer)NULL},
    {"dev", "*dev", XtRString, sizeof(String),
        XtOffsetOf(xwAppResourceRec, dev), XtRImmediate,
                                     NULL},
    {"timeout", "*timeout", XtRString, sizeof(String),
        XtOffsetOf(xwAppResourceRec, timeout), XtRImmediate,
                                      (XtPointer)NULL},                               
    {"debug",   "*debug",   XtRString, sizeof(String),
        XtOffsetOf(xwAppResourceRec, debug), XtRImmediate,
                                      (XtPointer)NULL},                               
};

char  *language;

Widget toplevel;

XtAppContext appContext;

Widget inkFRM;
Widget inkLBT;
Widget BlackW;
Widget BlackT;
Widget CyanW;
Widget CyanT;
Widget MagentaW;
Widget MagentaT;
Widget YellowW;
Widget YellowT;
Widget sep;
Widget cyanW;
Widget cyanT;
Widget magentaW;
Widget magentaT;
Widget inkOk;
Widget noInk;

int colors[6];

void inkOkCB(Widget widget, XtPointer clientData, XtPointer callData)
{
   //XtDestroyWidget(inkFRM);
   exit(0);
}
      Widget colorWid(Widget parent, Widget attach, char *name, int value)
{
   Arg    args[20];
   int    n;
   char   buf[100];
   char   nam[100];
   Widget wid;
   int    w;
   n = 0;
   XtSetArg(args[n], XtNwidth,       value ? (value*2):1);      n++;
   XtSetArg(args[n], XtNfromVert,    attach);       n++;
   XtSetArg(args[n], XtNborderWidth, 0);            n++;
   XtSetArg(args[n], XtNlabel,       "");           n++;
   XtSetArg(args[n], XtNfromHoriz,   NULL);         n++;
   XtSetArg(args[n], XtNhorizDistance,4);           n++;
   XtSetArg(args[n], XtNleft,         XtChainLeft); n++;
   XtSetArg(args[n], XtNinternalWidth, 0);           n++;
   strcpy(nam,name);
   strcat(nam,"Ink");
   wid = XtCreateManagedWidget(nam,
                               labelWidgetClass,
                               parent,args,n);
   n = 0;
   sprintf(buf, "%2d %%", value);
   XtSetArg(args[n], XtNfromVert,      attach); n++;
   XtSetArg(args[n], XtNhorizDistance, 4);      n++;
   XtSetArg(args[n], XtNlabel,         buf);    n++;
   XtSetArg(args[n], XtNjustify,       XtJustifyLeft); n++;
   XtSetArg(args[n], XtNborderWidth,   0);      n++;
   XtSetArg(args[n], XtNfromHoriz,     wid);    n++;
   XtSetArg(args[n], XtNx,             4);      n++;
   strcpy(nam,name);
   strcat(nam,"Txt");
   XtCreateManagedWidget(nam,
                         labelWidgetClass,
                         parent,args,n);
   
   return wid;
}

void buildWindow(Widget parent,
                 int    Black,
                 int    Cyan,
                 int    Magenta,
                 int    Yellow,
                 int    cyan,
                 int    magenta)
{
   /* color not present are set to -1 */
   Arg          args[20];
   int          n;
   int          i;
   Widget       attach;
   char         buf[100];
   
   /* main form */
   n = 0;
   sprintf(buf,"Ink_%s",language);

   inkFRM = XtCreateManagedWidget(buf,
                                  formWidgetClass,
                                  parent,args,n);
   
   n = 0;
   XtSetArg(args[n], XtNborderWidth,  0);      n++;
   XtSetArg(args[n], XtNwidth,        250);    n++;
   XtSetArg(args[n], XtNfromHoriz,    NULL);   n++;
   XtSetArg(args[n], XtNhorizDistance,4);      n++;
   
   inkLBT = XtCreateManagedWidget("inkLBT",
                                  labelWidgetClass,
                                  inkFRM,args,n);
   attach = inkLBT;

   if ( Black > -1 || Cyan > -1 || Magenta > -1 || Yellow > -1 )
   {
      if ( Black > -1 )
      {
         BlackW = colorWid(inkFRM, attach, "Black", Black);
         attach = BlackW;
      }
 
      if ( Cyan > -1 )
      {
         CyanW = colorWid(inkFRM, attach, "Cyan", Cyan);
         attach = CyanW;
      }

      if ( Magenta > -1 )
      {
         MagentaW =    colorWid(inkFRM, attach, "Magenta", Magenta);
         attach = MagentaW;
      }

      if ( Yellow > -1 )
      {
         YellowW = colorWid(inkFRM, attach, "Yellow", Yellow);
         attach = YellowW;
      }

      if ( cyan > -1 )
      {
         cyanW = colorWid(inkFRM, attach, "cyan", cyan);
         attach = cyanW;
      }

      if ( magenta > -1 )
      {
         magentaW =    colorWid(inkFRM, attach, "magenta", magenta);
        attach = magentaW;
      }

      /* make separator */
 
      n = 0;
      XtSetArg(args[n], XtNfromVert,       attach);      n++;
      XtSetArg(args[n], XtNvertDistance,   7);           n++;
      XtSetArg(args[n], XtNheight,         2);           n++;
      XtSetArg(args[n], XtNinternalHeight, 0);           n++;
      XtSetArg(args[n], XtNborderWidth,    0);           n++;
      XtSetArg(args[n], XtNlabel,          "");          n++;
      XtSetArg(args[n], XtNwidth,          201);         n++;
      XtSetArg(args[n], XtNfromHoriz,      NULL);        n++;
      XtSetArg(args[n], XtNhorizDistance,  4);           n++;
      XtSetArg(args[n], XtNleft,           XtChainLeft); n++;
      sep = XtCreateManagedWidget("separator",
                                  labelWidgetClass,
                                  inkFRM,args,n);

      for ( i = 0; i < 11; i++ )
      {
         n = 0;
         XtSetArg(args[n], XtNfromVert,       attach);      n++;
         XtSetArg(args[n], XtNvertDistance,   3);           n++;
         XtSetArg(args[n], XtNheight,         4);           n++;
         XtSetArg(args[n], XtNinternalHeight, 0);           n++;
         XtSetArg(args[n], XtNinternalWidth,  0);           n++;
         XtSetArg(args[n], XtNborderWidth,    0);           n++;
         XtSetArg(args[n], XtNlabel,          "");          n++;
         XtSetArg(args[n], XtNwidth,          1);           n++;
         XtSetArg(args[n], XtNfromHoriz,      NULL);        n++;
         XtSetArg(args[n], XtNhorizDistance,  4+i*20);      n++;
         XtSetArg(args[n], XtNleft,           XtChainLeft); n++;
 
         XtCreateManagedWidget("separator",
                                     labelWidgetClass,
                                     inkFRM,args,n);
      }
   }
   else /* no ink quantity */
   {
      n = 0;
      XtSetArg(args[n], XtNfromVert,    attach);       n++;
      XtSetArg(args[n], XtNborderWidth, 0);            n++;
      XtSetArg(args[n], XtNfromHoriz,   NULL);         n++;
      XtSetArg(args[n], XtNhorizDistance,4);           n++;
      XtSetArg(args[n], XtNleft,         XtChainLeft); n++;
      XtSetArg(args[n], XtNinternalWidth, 0);          n++;
 
      noInk = XtCreateManagedWidget("noInk",
                                     labelWidgetClass,
                                     inkFRM,args,n);
      sep = noInk;
   
   }
 
   /* make OK button */
 
   n = 0;
   XtSetArg(args[n], XtNfromVert,       sep);         n++;
   XtSetArg(args[n], XtNvertDistance,   8);           n++;
   XtSetArg(args[n], XtNx,              4);           n++;
   XtSetArg(args[n], XtNfromHoriz,      NULL);        n++;
   XtSetArg(args[n], XtNhorizDistance,  4);           n++;
   XtSetArg(args[n], XtNleft,           XtChainLeft); n++;
   XtSetArg(args[n], XtNwidth,          250);         n++;
   inkOk = XtCreateManagedWidget("inkOkBTN",
                                 commandWidgetClass,
                                 inkFRM,args,n);
   XtAddCallback( inkOk, XtNcallback, inkOkCB, inkFRM);
 
   XtRealizeWidget(parent);
   XtUnrealizeWidget(parent);
   XFlush(XtDisplay(parent));
   XSync(XtDisplay(parent), False);
   XFlush(XtDisplay(parent));


   /* get witdh and height from display, calculate position */
   {
      int tb,tw;
      Dimension    wMax,w, hMax,h, bwMax;
      char geoBuf[100];
 
      n = 0;
      XtSetArg(args[n],   XtNheight, &h); n++;
      XtSetArg(args[n],   XtNwidth,  &w); n++;
      XtGetValues(parent, args, n);

      tb = DisplayHeight(XtDisplay(parent),0);
      tw = DisplayWidth(XtDisplay(parent),0);
 
      sprintf(geoBuf,"+%d+%d", (tw-w)/2,(tb-h)/2);
      n=0;
      XtSetArg(args[n], XtNgeometry,  geoBuf); n++;
      XtSetArg(args[n], XtNminHeight, h);n++;
      XtSetArg(args[n], XtNmaxHeight, h);n++;
      XtSetArg(args[n], XtNminWidth,  w);n++;
      XtSetArg(args[n], XtNmaxWidth,  w);n++;
   }
   XtSetValues(parent,args,n);
   XtRealizeWidget(parent);

}

void parseArgs(int ac, char **av,
               XrmOptionDescRec optionDescList[], int optN,
               XtResource resources[], int resN)
{
   int i, j, k;
   char **s;
   for ( i = 0; i < ac; i++ )
   {
      for (j = 0; j < optN; j++ )
      {
         if ( strcmp(optionDescList[j].option, av[i]) == 0 )
         {
            for (k = 0; k < resN; k++ )
            {
               if ( strcmp(optionDescList[j].specifier,
                           resources[k].resource_name) == 0 )
               {
                  s = (char**)((char*)&appParams + resources[k].resource_offset);
                  *s =  av[i+1];
                  break;
               }
            }
            break;
         }
         else if ( strcmp(av[i],"-debug") == 0 )
         {
            debug = 1;
         }
      }
   }
}              

void main(int argc, char *argv[])
{
   char    *args[5];
   int      count;
   
   args[0] = *argv;
   args[3] = NULL;
   args[4] = NULL;
   count   = 1;

   parseArgs(argc, argv, optionDescList, XtNumber(optionDescList),
             resources, XtNumber(resources) );

   language = getenv("LANG");
   if ( language == NULL )
   {
      language = getenv("LC_ALL");
      if ( language == NULL )
      {
         language = getenv("LC_MESSAGES");
         if ( language == NULL )
         {
            language = "en";
            if ( debug )
            {
               fprintf(stderr,"set Language to default en\n");
            }
         }
         else if ( debug )
         {
            fprintf(stderr,"get Language from LC_MESSAGES=%s\n",language);
         }
      }
      else if ( debug )
      {
         fprintf(stderr,"get Language from LC_ALL=%s\n",language);
      }
   }
   else if ( debug )
   {
      fprintf(stderr,"get Language from LANG=%s\n",language);
   }
   
   if ( strlen(language) > 2 )
      language[2] = '\0';
   else if ( strlen(language) < 2 )
   {
      language = "en";
      if ( debug )
      {
         fprintf(stderr,"Set language to en\n");
      }
   }

   if ( debug )
   {
      fprintf(stderr,"language=%s\n",language);
   }

   toplevel = XtAppInitialize(&appContext, "GetInk",
                              optionDescList, XtNumber(optionDescList),
                              &argc, argv,
                              NULL,
                              NULL, 0
                            );

   if ( toplevel )
   {
      XtGetApplicationResources(toplevel, (XtPointer)&app_resource_rec,
        resources, XtNumber(resources),
        NULL, 0);
   }

   if ( toplevel )
   {
      int   Argc;
      char *Argv[] = {
        "p", "lp0",
        "s", "InkQuantity",
        "d", "500",
        "r",
      };

      if ( appParams.debug )
      {
         debug = 1;
      }
      else if ( app_resource_rec.debug )
      {
         debug = 1;
      }

      if ( appParams.dev )
      {
         Argv[1] = appParams.dev;
      }
      else if ( app_resource_rec.dev )
      {
         Argv[1] = app_resource_rec.dev;
      }
      if ( appParams.timeout )
      {
         Argv[5] = appParams.timeout;
      }
      else if ( app_resource_rec.timeout )
      {
         Argv[5] = app_resource_rec.timeout;
      }
      
      Argc = sizeof(Argv) / sizeof(*Argv);
      memset(colors, -1, sizeof(colors));
      rw(Argc, Argv);
      buildWindow(toplevel,
                  colors[0], colors[1],
                  colors[2], colors[3],
                  colors[4], colors[5]
                 );

      XtAppMainLoop(appContext);
   }
   else
   {
      fprintf(stderr,"cant create toplevel\n");
      exit(1);
   }
   exit(0);
}


/*********************************************************************/
/* Function:   sigAlarm                                              */
/*                                                                   */
/*             time alarm handler                                    */
/*                                                                   */
/* arguments:                                                        */
/*                                                                   */
/*                                                                   */
/* return:    none                                                   */
/*                                                                   */
/*********************************************************************/

void sigAlarm(int code)
{
}

/*********************************************************************/
/* Function:   receive                                               */
/*                                                                   */
/*              read from the port and print results to stdout       */
/*                                                                   */
/* arguments: int hd  handle to the opened port                      */
/*                                                                   */
/*                                                                   */
/* return:    none                                                   */
/*                                                                   */
/*********************************************************************/

void receive(int hd)
{
   char hexV[10];
   char *s;
   memset(ibuf,0,sizeof(ibuf));
   memset(hexV,0,sizeof(hexV));
   s = ibuf;
   if(read(hd, ibuf, sizeof(ibuf))>0)
   {
      if ( debug )
      {
         printf("============= received =============\n");
         printf("%s",ibuf);
         printf("\n====================================\n");
      }  
      while (*s )
      {  
         if ( strncmp(s, "IQ:", 3) == 0 )
         {
            s+=3;
            memset(colors, -1, sizeof(colors));
            hexV[0]= s[0];
            hexV[1]= s[1];
            hexV[2]= 0;
            sscanf(hexV, "%x",&colors[0]);
            s +=2;
            
            hexV[0]= s[0];
            hexV[1]= s[1];
            hexV[2]= 0;
            sscanf(hexV, "%x",&colors[1]);
            s +=2;

            hexV[0]= s[0];
            hexV[1]= s[1];
            hexV[2]= 0;
            sscanf(hexV, "%x",&colors[2]);
            s +=2;

            if ( s[0] != ';' )
            {
               hexV[0]= s[0];
               hexV[1]= s[1];
               hexV[2]= 0;
               sscanf(hexV, "%x",&colors[3]);
               s +=2;
 
               if ( s[0] != ';' )
               {
                  hexV[0]= s[0];
                  hexV[1]= s[1];
                  hexV[2]= 0;
                  sscanf(hexV, "%x",&colors[4]);
                  s +=2;

                  if ( s[0] != ';' )
                  {
                     hexV[0]= s[0];
                     hexV[1]= s[1];
                     hexV[2]= 0;
                     sscanf(hexV, "%x",&colors[5]);
                  }
               }
            }
            else
            {
               hexV[3]= hexV[2];
               hexV[2]= hexV[1];
               hexV[1]= hexV[0];
               hexV[0]= -1;
            }
            return;
         }
         else
         {
            s++;
         }
      }   

      memset(ibuf,0,sizeof(ibuf));
      s = ibuf;
   }
   else if ( debug )
   {
      fprintf(stderr,"nothing read from port\n");
   }
   //printf("\n");
}
    
/*********************************************************************/
/* Function:   main                                                  */
/*                                                                   */
/*             read and write to the device passed by the arg p      */
/*                                                                   */
/* arguments:                                                        */
/*                                                                   */
/* return:    0 if OK 1 on error                                     */
/*                                                                   */
/*********************************************************************/

int rw(int argc,char **argv)
{
   int   io  = 0;
   int   len = 0;
   int   i;
   int   ret = 0;
   struct  itimerval ti, oti;
   int   delay;

   *port = 0;
      
   /* main loop for processing the arguments */
   while (argc)
   {
      if (strcmp("p",argv[0]) == 0 )
      {
         argc--;
         argv++;
         
         /* dont allow consecutive handling of ports */
         if ( io )
         {
            close(io);
            if ( debug )
            {
               fprintf(stderr,"port declared twice\n");
            }
            return(1);
         }
         
         /* set path of device */
         sprintf(port,"/dev/%s",argv[0]);
   
         if ( debug )
         {
             fprintf(stderr,"try to open %s\n",port);
         }
         /* set wait time and call timer */
         SET_TIMER(ti,oti,OPEN_WRITE_TIMEOUT);         
         io = open(port,O_RDWR);
         if ( io <= 0 )
         {
            if ( debug )
            {
               fprintf(stderr,"cant open %s\n",port);
            }
            return(1);
         }
         RESET_TIMER(ti,oti);
      
         if ( debug )
         {
             fprintf(stderr,"opened %s, got handle %d\n",port,io);
         }
      }
      else if (strcmp("s",argv[0]) == 0  )
      {
         /* send arg to the device */
         if ( io == 0 )
         {
            if ( debug )
            {
               fprintf(stderr,"port not given\n");
            }
            exit(1);
         }
         argc--;
         argv++;

         if ( debug )
         {
            fprintf(stderr,"send command %s\n",argv[0]);
         }

         SET_TIMER(ti,oti,OPEN_WRITE_TIMEOUT);         

         if ( SendCmd(io,argv[0], write) > 0 )
         {
            RESET_TIMER(ti,oti);
         }
         else if ( debug )
         {
             fprintf(stderr,"cant write to %s\n",port);
         }
      }
      else if ( strcmp("d",argv[0]) == 0 )
      {
         /* wait for the given time by polling stderr*/

         argc--;
         argv++;
     
         delay = atoi(argv[0]);
         fflush(stdout);
         if ( debug )
         {
            fprintf(stderr,"wait %d ms before reading\n",delay);
         }
         SET_TIMER(ti,oti,delay);         
         pause();
      }
      else if (strcmp("r",argv[0]) == 0  )
      {
         /* read from port */  
         if ( io == 0 )
         {
            if ( debug )
            {
               fprintf(stderr,"port not given\n");
            }
            exit(1);
         }
         if ( debug )
         {
             fprintf(stderr,"try to read, timeout = %4d ms\n",OPEN_WRITE_TIMEOUT );
         }
         SET_TIMER(ti,oti,OPEN_WRITE_TIMEOUT);         
         receive(io);
         RESET_TIMER(ti,oti);

      }
      argc--;
      argv++;
   }

   if ( io )
      close(io);
   return(0);
}

/********************************************************************/
/*                                                                  */
/* Copyright (C) JJ Sarton 11999 All Rights Reserved  Confidential  */
/*                                                                  */
/********************************************************************/
