#!/bin/sh
####################################################################
##
## Copyright (C) JJ Sarton 1999 All Rights Reserved Confidential
##
####################################################################

####################################################################
##
## MODULE:    epsCmd.sh
##
## FUNCTION:  main script for the epson utilities TTY version
##
##
##
## CREATED:   14.JUL.99 Jean-Jacques Sarton 
##                      jj.sarton@t-online.de
##
## CHANGES:   12.DEC.99 provided possibility to get debug output
##                      from epsCmd
##
## VERSION:   1.02
##
####################################################################

case x$1 in
   x-d*|xd*) Debug=-debug ;;
   *)        Debug= ;;
esac

# Eps Utils for tty

# The utility epsCmd accept the following parameters:
# -dev lp?
# -cmd GetId | InkQuantity | CleanHead | PrintPattern
# -timeout ###### wait time in ms
# defaults are -dev lp0 -cmd GetId -timeout 500

port=lp0
timeout=500

while :
do
   echo
   echo 'enter choice'
   echo '=============================='
   echo 'get printer type             1'
   echo 'get ink quantity             2'
   echo 'clean head                   3'
   echo 'print nozzle check pattern   4'
   echo 'quit                         0'
   read answer rest
   case $answer in
   0) exit 0;;
   1) epsCmd -cmd GetId        -dev $port -timeout 250 $Debug;;
   2) epsCmd -cmd InkQuantity  -dev $port -timeout 250 $Debug;;
   3) epsCmd -cmd CleanHead    -dev $port -timeout 250 $Debug;;
   4) epsCmd -cmd PrintPattern -dev $port -timeout 250 $Debug;;
   esac
done
