// -*- C++ -*-

//
//  Xformat frontend to fdformat, mke2fs and mformat
//
//  Copyright (C) 1996 Christoph Neerfeld
//  email:  Christoph.Neerfeld@mail.bonn.netsurf.de
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//


extern "C" {
#include <forms.h>
#include "xdisk.h"
#include <stdlib.h>
#include <unistd.h>
#include <signal.h>
#include <sys/time.h>
#include <sys/wait.h>
#include <fcntl.h>
}

#include "config.h"

#include <iostream.h>
#include <fstream.h>
#include <String.h>


FD_fr1 *fr1;
FD_fr2 *fr2;
FD_fr3 *fr3;
FD_fr4 *fr4;

String command1, command2;

short format_run;

void f_dummy (FL_OBJECT *ob, long user_data)
{
}

void f_help (FL_OBJECT *ob, long user_data)
{
  fl_show_form(fr2->fr2, FL_PLACE_MOUSE, FL_FULLBORDER, "Xformat Help");
}

void f_format (FL_OBJECT *ob, long user_data)
{
  fl_set_object_label(fr3->drive_t, fl_get_choice_text(fr1->dev_ch));
  String fs_type = fl_get_choice_text(fr1->fs_ch);
  String dev = fl_get_choice_text(fr1->dev_ch);
  String dev_fn = "/dev/" + dev;

  if( access( (const char *) dev_fn, W_OK) )
    {
      fl_show_alert("No write permission !",
		    "The device you want to use does not exist",
		    "or you don't have write permission for it.", 0);
      return;
    }
  int mounts;
  char c;
  String temp = "";
  mounts = open("/proc/mounts", O_RDONLY);
  if(!mounts)
    {
      cerr << "Sorry, unable to read /proc/mounts !" << endl;
      fl_finish(); 
      exit(1); 
    }
  while (read(mounts, &c, 1))
    {
      if( c != '\n') { temp += c; continue; }
      if( temp.contains(dev_fn))
        {
	  fl_show_alert("Already mounted !",
			(const char *) ("The device " + dev_fn +" is currently mounted."),
			"Please unmount it first.", 0);
	  return;
        }
      temp = "";
    }
  close(mounts);
  if( fs_type == "" )
    {
      fl_show_alert("No mke2fs and mformat",
		    "Didn't you read the warnings while running configure ?",
		    "This program is useless without mke2fs and mformat.", 0);      
      return;
    }
  command1 = "";
  command2 = "";
  if( fs_type == "ext2" )
    {
      command2 = (String) MKE2FS + " /dev/" + dev;
    }
  else
    {
      if( dev == "fd0" )
	command2 = (String) MFORMAT + " a:";
      else
	command2 = (String) MFORMAT + " b:";
    }
  if(fl_get_button(fr1->level_but))
     {
       String dev_name = ("/dev/" + dev + fl_get_choice_text(fr1->size_ch));
       if( access( (const char *) dev_name , W_OK) )
	 {
	   fl_show_alert("No write permission !",
			  (const char *) ((String) ("The device " + dev_name + " does not exist")),
			 "or you don't have write permission for it.", 0);
	   return;
	 }
       command1 = (String) FDFORMAT + " /dev/" + dev + \
	 fl_get_choice_text(fr1->size_ch);
     }
  fl_set_object_label(fr3->command_t, (const char *) (command1 + "\n" + command2));
  fl_show_form(fr3->fr3, FL_PLACE_MOUSE, FL_FULLBORDER, "Xformat");
}

FILE *exec_command(String command, pid_t &pid)
{
  String prog, value;
  FILE *file = NULL;
  int mypipe[2];
  prog = command.before(" ");
  value = command.after(" ");
  if (pipe(mypipe))
    {
      cerr << "Sorry, unable to create pipe. Fatal error." << endl;
      fl_finish();
      exit(1);
    }
  pid = vfork();
  if( pid == (pid_t) 0)
    {                    // this is the child
      dup2(mypipe[1], STDOUT_FILENO);
      dup2(mypipe[1], STDERR_FILENO);
      close(mypipe[1]);
      close(mypipe[0]);
      execl((const char *) prog, (const char *) prog, (const char *) value, NULL);
      cout << "mke2fs:" << endl;
      cout << "Total" << endl;
      cout << "i" <<  endl;
      _exit(1);
    }
  else if ( pid < (pid_t) 0)
    {                                    // fork failed
      cerr << "Sorry, unable to fork. Fatal error." << endl;
      fl_finish();
      exit(1);
    }
  close(mypipe[1]);
  fcntl(mypipe[0], F_SETFD, FD_CLOEXEC);
  file = fdopen(mypipe[0], "r");
  return file;
}

void f_cancel_fr3 (FL_OBJECT *ob, long user_data)
{
  fl_hide_form(fr3->fr3);
}

void f_ok_fr3 (FL_OBJECT *ob, long user_data)
{
  pid_t pid;
  short error = 0;
  FILE *file;
  unsigned char c;
  String temp;
  fl_hide_form(fr3->fr3);
  if ( command1 != "" )
    {
      fl_set_object_label(fr4->error_t, "");
      fl_deactivate_form(fr1->fr1);
      fl_set_slider_value(fr4->format_sl, 0);
      fl_set_slider_value(fr4->verify_sl, 0);
      fl_show_form(fr4->fr4, FL_PLACE_MOUSE, FL_TRANSIENT, "Xformat");
      file = exec_command(command1, pid);
      if( file == NULL )
	{
	  cerr << "Unable to execute command: " << command1 << endl;
	  fl_finish();
	  exit(1);
	}
      setvbuf(file, NULL, _IONBF, 0);
      double value;
      FL_OBJECT *slider;
      format_run = 1;
      while( c = fgetc(file))
	{
	  if ( c >= 128) break;
	  if ( c != '\n' )
	    temp += c;
	  else
	    {
	      if(temp.contains("Total"))
		{
		  fl_set_object_label(fr4->format_t, (const char *) temp);
		  fl_set_slider_bounds(fr4->format_sl, 0, 79);
		  fl_set_slider_bounds(fr4->verify_sl, 0, 79);
		  slider = fr4->format_sl;
		  temp = "";
		  for( int i = 0; i < 15; i++)
		    fgetc(file);
		  while( c = fgetc(file))
		    {
		      if( c >= 128) break;
		      fl_check_forms();
		      if( format_run == 0)
			{
			  kill(pid, SIGTERM);
			  waitpid(pid, (int *) NULL, 0);
			  fclose(file);			
			  error = 1;
			  break;
			}  
		      if( c == 'i' || c == 'r' )
			{
			  fl_set_object_label(fr4->error_t, \
					      "Error occurred while trying to format disk !!");
			  error = 1;
			  break;
			}
		      if( c == 'd' )
			{
			  while ( fgetc(file) != 0x0a );
			  for( int i = 0; i < 14; i++)
			    fgetc(file);
			  temp = "";
			  c = fgetc(file);
			  slider = fr4->verify_sl;
			}
		      if( c != 0x08 )
			temp += c;
		      if( temp.length() == 3)
			{
			  value = strtod( (const char *) temp, NULL);
			  fl_set_slider_value(slider, value);
			  fl_redraw_object(slider);
			  temp = "";
			}
		    }
		  if(error) break;
		}
	      temp = "";
	    }
	}
      waitpid(pid, (int *) NULL, 0);
      fclose(file);
    }
  if(error)
    {
      fl_activate_form(fr1->fr1);
      return;
    }
  file = exec_command(command2, pid);
  if( file == NULL )
    {
      cerr << "Unable to execute command: " << command2 << endl;
      fl_finish();
      exit(1);
    }
  temp = "";
  while( c = fgetc(file))
    {
      if ( c >= 128) break;
      if ( c != '\n' )
	temp += c;
      else
	{
	  if( temp.contains("mke2fs:") || temp.contains("mformat:") )
	    {
	      error = 1;
	      break;
	    }
	  temp = "";
	}
    }
  waitpid(pid, (int *) NULL, 0);
  fclose(file);
  if(error)
    {
      fl_show_alert("ERROR", "Error occured while trying to create filesystem.", "", 0);
      if ( command1 != "" )
	fl_hide_form(fr4->fr4);
    }
  else
    {
      fl_show_message("", "Format successful.", "");
      if ( command1 != "" )
	fl_hide_form(fr4->fr4);
    }
  fl_activate_form(fr1->fr1);
}

void f_ok_fr2 (FL_OBJECT *ob, long user_data)
{
  fl_hide_form(fr2->fr2);
}

void f_cancel_fr4 (FL_OBJECT *ob, long user_data)
{
  format_run = 0;
  fl_hide_form(fr4->fr4);
}

void f_device (FL_OBJECT *ob, long user_data)
{
  if( fl_get_choice(ob) == 2)
    {
      fl_set_choice(fr1->type_ch, fd1);
      f_type(fr1->type_ch, 0);
    }
  else
    {
      fl_set_choice(fr1->type_ch, fd0);
      f_type(fr1->type_ch, 0);
    }
}

void f_type (FL_OBJECT *ob, long user_data)
{
  fl_clear_choice(fr1->size_ch);
  int i = 0;
  if( fl_get_choice(fr1->type_ch) == 2)
    {
      while ( five[i] != "*" )
	{
	  fl_addto_choice(fr1->size_ch, (const char*) five[i]);
	  i++;
	}
      fl_set_choice_text(fr1->size_ch, (const char *) default_five);  
    }
  else
    {
      while ( three[i] != "*" )
	{
	  fl_addto_choice(fr1->size_ch, (const char*) three[i]);
	  i++;
	}
      fl_set_choice_text(fr1->size_ch, (const char *) default_three);  
    }
}

void f_quit (FL_OBJECT *ob, long user_data)
{
  fl_finish();
  exit(0);
}

void f_version (FL_OBJECT *ob, long user_data)
{
  fl_show_message("This is Xformat Version 1.0.1 by Christoph Neerfeld",\
		  "This program is copyrighted, but you may distribute it",\
		  "under the terms of the GNU General Public Licence.");
}

main (int argc, char **argv)
{
  String progname, temp;
  format_run = 9;

  fl_initialize(&argc, argv, "Xformat", 0, 0);
  fr1 = create_form_fr1();

  fl_addto_choice(fr1->dev_ch, (const char*) "fd0");
  fl_addto_choice(fr1->dev_ch, (const char*) "fd1");

  if( (String) MKE2FS != "" )
    fl_addto_choice(fr1->fs_ch, (const char*) "ext2");
  if( (String) MFORMAT != "" )
    fl_addto_choice(fr1->fs_ch, (const char*) "MSDOS");

  fl_addto_choice(fr1->type_ch, (const char*) "3.5");
  fl_addto_choice(fr1->type_ch, (const char*) "5.25");

  int i = 0;
  while ( three[i] != "*" )
    {
      fl_addto_choice(fr1->size_ch, (const char*) three[i]);
      i++;
    }
  String default_size = "";
  FILE *file;
  unsigned char c;
  file = popen( "floppycontrol -T /dev/fd0 2> /dev/null" , "r");
  if( file != NULL)
    {
      while( c = fgetc(file))
	{
	  if ( c >= 128) break;
	  if ( c != '\n' )
	    default_size += c;
	}
      pclose(file);
    }
  if( default_size != "" )
    {
      if( default_size[0] < 91 ) // 3.5''
	{ fd0 = 1; default_three = default_size; }
      else
	{ fd0 = 2; default_five = default_size; }
    }
  fl_set_choice_text(fr1->size_ch, (const char *) default_three);
  fl_set_choice(fr1->type_ch, fd0);
  f_type(fr1->type_ch, 0);
  default_size = "";
  file = popen( "floppycontrol -T /dev/fd1 2> /dev/null" , "r");
  if( file != NULL)
    {
      while( c = fgetc(file))
	{
	  if ( c >= 128) break;
	  if ( c != '\n' )
	    default_size += c;
	}
      pclose(file);
    }
  if( default_size != "" )
    {
      if( default_size[0] > 91 ) // 5.25''
	{ fd1 = 2; default_five = default_size; }
      else
	{ fd1 = 1; default_three = default_size; }
    }

  fl_show_form(fr1->fr1, FL_PLACE_MOUSE, FL_FULLBORDER, "Xformat");

  fr2 = create_form_fr2();
  fl_set_browser_fontsize(fr2->help_br, 12);
  //  fl_load_browser(fr2->help_br, "./help.txt");
  for(int j = 0; j < 30; j++)
    {
      fl_add_browser_line(fr2->help_br, help_text[j]);
    }

  fr3 = create_form_fr3();
  fr4 = create_form_fr4();
  fl_deactivate_object(fr4->format_sl);
  fl_deactivate_object(fr4->verify_sl);
  fl_set_slider_value(fr4->format_sl, 0);
  fl_set_slider_value(fr4->verify_sl, 0);

  fl_set_object_bw(fr1->gr_all, -3);

  fl_set_goodies_font(FL_BOLD_STYLE, 12);

  if( (String) FDFORMAT == "" )
    fl_deactivate_object(fr1->level_but);

  fl_do_forms();
}  

