// -*- C++ -*-

//  This file is part of 
//  Xformat frontend to fdformat, mke2fs and mformat
//
//  Copyright (C) 1996 Christoph Neerfeld
//  email:  Christoph.Neerfeld@mail.bonn.netsurf.de
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#define MFORMAT "/usr/bin/mformat"
#define FDFORMAT "/usr/bin/fdformat"
#define MKE2FS "/sbin/mke2fs"

#include <String.h>

short fd0 = 1;      // fd0 is 3.5''
short fd1 = 2;      // fd1 is 5.25''

// 1 means the drive is 3.5''
// 2 means the drive is 5.25''
// so if you have for example two 3.5'' drives you write
// short fd0 = 1;
// short fd1 = 1;

// if you want different default formats, change the values of the next two variables

String default_three = "H1440";        // 3.5''
String default_five = "h1200";         // 5.25''

// -------------

// If you want further disk sizes, uncomment the proper lines.
// It is a good idea to only include those formats that are supported by your drive.
// You may even remove those "D360" lines if you like.
// (never change the last entry).

String three[] = {
  "D360",
  "D720",
//  "D800",
//  "D1040",
//  "D1120",
  "H360",
  "H720",
//  "H820",
//  "H830",
  "H1440",
//  "H1600",
//  "H1680",
//  "H1722",
//  "H1743",
//  "H1760",
//  "H1840",
//  "H1920",
//  "E2880",
//  "CompaQ",
//  "E3200",
//  "E3520",
//  "E3840",
  "*"
};

String five[] = {
  "d360",
  "h360",
//  "h410",
//  "h420",
  "h720",
//  "h880",
  "h1200",
//  "h1440",
//  "h1476",
//  "h1494",
//  "h1600",
  "*"
};

//-----------------------------------------------------------------------
// you shouldn't have to change anything below this line
//-----------------------------------------------------------------------

const char help_text[][62] = {
  " ",
  "@b@cXformat Version 1.0 by Christoph Neerfeld",
  " ",
  "@bDevice:",
  "fd0: is normaly your first disk drive",
  "fd1: is your second disk drive",
  " ",
  "@bFS_Type:",
  "Filesystem type: one of ext2 or MSDOS",
  " ",
  "@bFormat:",
  "Executes the format command.",
  " ",
  "@bLow level:",
  "If you wish to low level format your disk before creating",
  "the filesystem, you have to select this button.",
  " ",
  "@bType:",
  "The type of your disk drive. (3.5'' or 5.25'')",
  " ",
  "@bSize:",
  "The size of the disk. D and d stand for double density disks,",
  "H and h for high density disks.",
  " ",
  " ",
  "@b@cWarning",
  " ",
  "If you use formats with more tracks than supported",
  "by  your  drive,  you may  damage  it  mechanically.",
  "(for further details read the manual entry for fd(4).)"
};
