# Module: MkCopy.tcl
# 4.3.96 T.Niederreiter
# 4.4.97 tn - rewrite for 0.96
# 
# External called functions:
# - MkDataCopy { w }: creates the copy-data-CD-menu 
# - MkAudioCopy { w }: creates the copy-audio-CD-menu 
#

# Creates the Copy-CD-Menu

proc MkDataCopy { w } {
global sidebar

	log $w "entering Copy Data-CD"

	copydatasidebar

	# display Info as default
	MkDataSub 1 $w $sidebar.all
}


# Creates the Copy-CD-Menu (Audio)

proc MkAudioCopy { w } {
global sidebar

	log $w "entering Copy Audio-CD"

	copyaudiosidebar

	# display Info as default
	MkAudioSub 1 $w $sidebar.all
}


# button-handler - called when a sidebar button is pressed

proc MkDataSub { id w but } {

	catch { destroy $w.all }
	frame $w.all
	pack $w.all -expand 1 -fill both
	set m $w.all

        deactivebutton $but.b1
        deactivebutton $but.b2
        deactivebutton $but.b3
        deactivebutton $but.b4
        deactivebutton $but.b5
        deactivebutton $but.b6
        deactivebutton $but.b8

	if { $id == 1 } {
		activebutton $but.b1
		MkDataInfo $m
	}
	if { $id == 2 } {
		activebutton $but.b2
		readimagedialog $m
	}
	if { $id == 3 } {
		activebutton $but.b3
		verifyimagedialog $m
	}
	if { $id == 4 } {
		activebutton $but.b4
		writeimagedialog $m
	}
	if { $id == 5 } {
		activebutton $but.b5
		verify2imagedialog $m
	}
	if { $id == 8 } {
		activebutton $but.b8
		delaudiodialog $m data
	}
	if { $id == 6 } {
		activebutton $but.b6
		quickcopydialog $m
	}
}


# button-handler - called when a sidebar button is pressed

proc MkAudioSub { id w but } {

	catch { destroy $w.all }
	frame $w.all
	pack $w.all -expand 1 -fill both
	set m $w.all

        deactivebutton $but.b1
        deactivebutton $but.b2
        deactivebutton $but.b3
        deactivebutton $but.b4
        deactivebutton $but.b5
        deactivebutton $but.b6
        deactivebutton $but.b7

	if { $id == 1 } {
		activebutton $but.b1
		MkAudioInfo $m
	}
	if { $id == 2 } {
		activebutton $but.b2
		readaudiodialog $m
	}
	if { $id == 3 } {
		activebutton $but.b3
		verifydatatrackdialog $m
	}
	if { $id == 4 } {
		activebutton $but.b4
		playaudiodialog $m
	}
	if { $id == 5 } {
		activebutton $but.b5
		delaudiodialog $m audio
	}
	if { $id == 6 } {
		activebutton $but.b6
		writeaudiodialog $m
	}
	if { $id == 7 } {
		activebutton $but.b7
		verify2datadialog $m
	}
}


# update sidebar

proc copydatasidebar { } {
global sidebar
global statusbar
global maincanv
global XCDR_DEST_WRITER_DEV XCDR_AUDIO_SOURCE_CDROM XCDR_DATA_SOURCE_CDROM

	set w $sidebar.all
	catch { destroy $w }
	frame $w
	pack $w -expand 1 -fill both

	button $w.b1 -text "CD/Image-Info" -command "MkDataSub 1 $maincanv $w"
	button $w.b2 -text "Read Image" -command "MkDataSub 2 $maincanv $w"
	button $w.b3 -text "Verify Image" -command "MkDataSub 3 $maincanv $w"
	button $w.b4 -text "Write Image" -command "MkDataSub 4 $maincanv $w"
	button $w.b5 -text "Verify burned Img." -command "MkDataSub 5 $maincanv $w"
	button $w.b8 -text "Delete Images" -command "MkDataSub 8 $maincanv $w"
	button $w.b6 -text "Quick CD-Copy" -command "MkDataSub 6 $maincanv $w"
	button $w.b7 -text "Back to Main" -command "datacopy:cancel_cmd"

	tixForm $w.b1 -top %10 -left %10 -right %90
	tixForm $w.b2 -top %20 -left %10 -right %90
	tixForm $w.b3 -top %30 -left %10 -right %90
	tixForm $w.b4 -top %40 -left %10 -right %90
	tixForm $w.b5 -top %50 -left %10 -right %90
	tixForm $w.b8 -top %60 -left %10 -right %90
	tixForm $w.b6 -top %75 -left %10 -right %90
	tixForm $w.b7 -top %90 -left %10 -right %90

	tixBalloon $w.bal1 -state status -statusbar $statusbar -initwait 0
	$w.bal1 bind $w.b1 -msg "Display Information about current contents of CD and Image-Partition"
	tixBalloon $w.bal2 -state status -statusbar $statusbar -initwait 0
	$w.bal2 bind $w.b2 -msg "Read an Image from CD and save on Image-Partition"
	tixBalloon $w.bal3 -state status -statusbar $statusbar -initwait 0
	$w.bal3 bind $w.b3 -msg "Verify the Image with the CD"
	tixBalloon $w.bal4 -state status -statusbar $statusbar -initwait 0
	$w.bal4 bind $w.b4 -msg "Write the Image to a CD-Recordable"
	tixBalloon $w.bal5 -state status -statusbar $statusbar -initwait 0
	$w.bal5 bind $w.b5 -msg "Verify the just burned CD with the Image"
	tixBalloon $w.bal8 -state status -statusbar $statusbar -initwait 0
	$w.bal8 bind $w.b8 -msg "Delete Image-Files or Audio-Tracks"
	tixBalloon $w.bal6 -state status -statusbar $statusbar -initwait 0
	$w.bal6 bind $w.b6 -msg "Copy a CD without storing the Image on disk"
	tixBalloon $w.bal7 -state status -statusbar $statusbar -initwait 0
	$w.bal7 bind $w.b7 -msg "Go back to the main menu"


	# disable buttons that need a CD-ROM
	if { $XCDR_DATA_SOURCE_CDROM == "" } {
		$w.b2 config -state disabled
		$w.b3 config -state disabled
		$w.b5 config -state disabled
		$w.b6 config -state disabled
	}

	# disable buttons that need a Writer-Device
	if { $XCDR_DEST_WRITER_DEV == "" } {
		$w.b4 config -state disabled
		$w.b6 config -state disabled
	}
}


# update sidebar

proc copyaudiosidebar { } {
global sidebar
global statusbar
global maincanv
global XCDR_DEST_WRITER_DEV XCDR_AUDIO_SOURCE_CDROM XCDR_DATA_SOURCE_CDROM

	set w $sidebar.all
	catch { destroy $w }
	frame $w
	pack $w -expand 1 -fill both

	button $w.b1 -text "CD/Image-Info" -command "MkAudioSub 1 $maincanv $w"
	button $w.b2 -text "Read Tracks" -command "MkAudioSub 2 $maincanv $w"
	button $w.b3 -text "Verify Data-Track" -command "MkAudioSub 3 $maincanv $w"
	button $w.b4 -text "Play Audio-Track" -command "MkAudioSub 4 $maincanv $w"
	button $w.b5 -text "Delete Tracks" -command "MkAudioSub 5 $maincanv $w"
	button $w.b6 -text "Write Tracks" -command "MkAudioSub 6 $maincanv $w"
	button $w.b7 -text "Vfy brnd Data-Trk" -command "MkAudioSub 7 $maincanv $w"
	button $w.b8 -text "Back to Main" -command "datacopy:cancel_cmd"

	tixForm $w.b1 -top %10 -left %10 -right %90
	tixForm $w.b2 -top %20 -left %10 -right %90
	tixForm $w.b3 -top %30 -left %10 -right %90
	tixForm $w.b4 -top %40 -left %10 -right %90
	tixForm $w.b5 -top %50 -left %10 -right %90
	tixForm $w.b6 -top %60 -left %10 -right %90
	tixForm $w.b7 -top %70 -left %10 -right %90
	tixForm $w.b8 -top %85 -left %10 -right %90

	tixBalloon $w.bal1 -state status -statusbar $statusbar -initwait 0
	$w.bal1 bind $w.b1 -msg "Display Information about current contents of CD and Image-Partition"
	tixBalloon $w.bal2 -state status -statusbar $statusbar -initwait 0
	$w.bal2 bind $w.b2 -msg "Read Tracks from a CD and save on Image-Partition"
	tixBalloon $w.bal3 -state status -statusbar $statusbar -initwait 0
	$w.bal3 bind $w.b3 -msg "Verify Data-Tracks on Image-Partition"
	tixBalloon $w.bal4 -state status -statusbar $statusbar -initwait 0
	$w.bal4 bind $w.b4 -msg "Playback Audio-Tracks saved on the Image-Partition"
	tixBalloon $w.bal5 -state status -statusbar $statusbar -initwait 0
	$w.bal5 bind $w.b5 -msg "Delete old Tracks from the Image-Partition"
	tixBalloon $w.bal6 -state status -statusbar $statusbar -initwait 0
	$w.bal6 bind $w.b6 -msg "Write your Track-Collection to a CD-Recordable"
	tixBalloon $w.bal7 -state status -statusbar $statusbar -initwait 0
	$w.bal7 bind $w.b7 -msg "Verify the Data-Track of just burned CD"
	tixBalloon $w.bal8 -state status -statusbar $statusbar -initwait 0
	$w.bal8 bind $w.b8 -msg "Go back to the main menu"


	# disable buttons that need a CD-ROM
	if { $XCDR_AUDIO_SOURCE_CDROM == "" } {
		$w.b2 config -state disabled
		$w.b3 config -state disabled
		$w.b7 config -state disabled
	}

	# disable buttons that need a Writer-Device
	if { $XCDR_DEST_WRITER_DEV == "" } {
		$w.b6 config -state disabled
	}
}


# display CD and image info

proc MkDataInfo { w } {
global XCDR_DATA_SOURCE_CDROM	
global XCDR_DEST_WRITER_DEV
global XCDR_DEST_WRITER_SPEED
global XCDR_DEFAULT_PART
global XCDR_IMAGE_PART
global XCDR_IMAGE_MNTPNT
global XCDR_IMAGE_PART2
global XCDR_IMAGE_MNTPNT2
global XCDR_IMAGE_FIXED
global TMP_XCDR_DEFAULT_PART

	# Draw header-bar
	label $w.l -text "COPY DATA-CD" -relief sunken -borderwidth 2 -anchor c
	pack $w.l -fill x -expand 1 -ipady 10 -pady 5

	# Create Devices-Setup
	tixLabelFrame $w.devs -label Devices-Setup 
	set w1 [$w.devs subwidget frame]
	pack $w.devs -expand 1 -fill x

	frame $w1.1
	tixLabelWidget $w1.1.readl -label "Data-Read-Device : " \
		-options {label.width 25 label.anchor e}
	message $w1.1.readt -anchor w -width 300 -relief groove
	$w1.1.readt configure -text $XCDR_DATA_SOURCE_CDROM
	label $w1.1.spd -text "Speed: --"

	tixForm $w1.1.readl -left %0
	tixForm $w1.1.readt -left %32 -right %80
	tixForm $w1.1.spd -left %82

	frame $w1.2
	tixLabelWidget $w1.2.imgl -label "Image-Device : " \
		-options {label.width 25 label.anchor e}
	message $w1.2.imgt -anchor w -width 300 -relief groove  
	$w1.2.imgt configure -text "\n\n" 

	set tmpval $TMP_XCDR_DEFAULT_PART
	unset TMP_XCDR_DEFAULT_PART

	# prepare the quick-image-select menu
	tixOptionMenu $w1.2.select -variable TMP_XCDR_DEFAULT_PART \
		-options { label.width 0 menubutton.width 12 } \
		-command "quickselimage $w1 $w"

	if { $XCDR_IMAGE_PART != "" && $XCDR_IMAGE_MNTPNT != "" } {
		$w1.2.select add command "Partition 1"
	}
	if { $XCDR_IMAGE_PART2 != "" && $XCDR_IMAGE_MNTPNT2 != "" } {
		$w1.2.select add command "Partition 2"
	}
	if { $XCDR_IMAGE_FIXED != "" } {
		$w1.2.select add command "Image-Path"
	}

	if { $XCDR_DEFAULT_PART == "1" } {
		catch { $w1.2.select configure -value "Partition 1" }
	}	
	if { $XCDR_DEFAULT_PART == "2" } {
		catch { $w1.2.select configure -value "Partition 2" }
	}	
	if { $XCDR_DEFAULT_PART == "3" } {
		catch { $w1.2.select configure -value "Image-Path" }
	}	
	if { $tmpval != "" } {
		catch { $w1.2.select configure -value $tmpval }
	}

	tixForm $w1.2.imgl -left %0
	tixForm $w1.2.imgt -left %32 -right %80
	tixForm $w1.2.select -left %82 -right %99

	frame $w1.3
	tixLabelWidget $w1.3.writel -label "Write-Device : " \
		-options {label.width 25 label.anchor e}
	message $w1.3.writet -anchor w -width 300 -relief groove
	$w1.3.writet configure -text $XCDR_DEST_WRITER_DEV
	label $w1.3.spd -text "Speed: $XCDR_DEST_WRITER_SPEED x"

	tixForm $w1.3.writel -left %0
	tixForm $w1.3.writet -left %32 -right %80
	tixForm $w1.3.spd -left %82
	
	pack $w1.1 $w1.2 $w1.3 -side top -expand 1 -fill x

	#-------------------------------------------------

	# Tile the window, create a left and a right frame
	frame $w.m
	frame $w.m.l
	frame $w.m.r
	pack $w.m.l $w.m.r -side left -pady 10 -padx 10
	pack $w.m

	# Create the Information-Windows
	tixLabelFrame $w.m.l.cdinfo -label CD-Information 
	set w2 [$w.m.l.cdinfo subwidget frame]
	pack $w.m.l.cdinfo -expand 1 -fill both
	tixScrolledListBox $w2.b -scrollbar auto -options {
		listbox.font 8x13 
		listbox.width 30 
		listbox.height 12 
	} -command "cdinfoclick $w2.b data"

	# Set scrollbar-width
	$w2.b.vsb configure -width 10
	$w2.b.hsb configure -width 10
	pack $w2.b -expand 1 -fill both

	tixLabelFrame $w.m.r.imginfo -label Image-Information 
	set w3 [$w.m.r.imginfo subwidget frame]
	pack $w.m.r.imginfo -expand 1 -fill both
	tixScrolledListBox $w3.b -scrollbar auto -options {
		listbox.font 8x13 
		listbox.width 30 
		listbox.height 12 
	} -command "imageinfoclick $w3.b"
		
	# Set scrollbar-width
	$w3.b.vsb configure -width 10
	$w3.b.hsb configure -width 10
	pack $w3.b -expand 1 -fill both

	button $w.rescan -text "Update Information-Windows" \
		-command "copy:rescan_cmd $w $w2.b $w3.b data"

	button $w.eject -text "Eject CD" \
		-command "ejectcd [convCD2block data]"

	pack $w.rescan $w.eject -pady 5 -padx 70 -side right -fill x

	updatelistboxes $w2.b $w3.b $w data

}


# called when a user double-clicks on the image-info-window

proc cdinfoclick { wid mode } {

	set sel [$wid.listbox curselection]
	if { $sel == "" } {
		# nothing selected?
		return
	}

	set val [$wid.listbox get $sel]

	if { [string first "01: Data" $val] == -1 } {
		# we can only handle Data-Tracks on pos 01
		return
	}

	# So..at this point we know that the user want to view
	# the data-track of the CD in the drive...
	set drive [convCD2block $mode]

        if {[checkifiso $drive] == 0 } {
                set NONISO 1
        } else {
                set NONISO 0
        }

	set w .cdreview

	# create new window
        set oldf [createsubwindow $w .root 2 ""]

        tixLabelFrame $w.l -label "Contents of Data-Track:"
        set w1 [$w.l subwidget frame]
        pack $w.l -expand 1 -fill both

        tixScrolledListBox $w1.b -scrollbar auto -options {
                listbox.width 45
                listbox.height 12
        }

        pack $w1.b -expand 1 -fill both

        frame $w.16
        tixLabelWidget $w.16.imglabel -label "Image-ISO9660-Label : " \
                -options { label.width 22 label.anchor e }
        message $w.16.imglabelval -width 250 -relief sunken -borderwidth 1 \
                -text ""
        pack $w.16 -fill x -expand 1 -padx 10 -pady 5 
        tixForm $w.16.imglabel -left %0
        tixForm $w.16.imglabelval -left %50 -right %98

        frame $w.17
        tixLabelWidget $w.17.imglabel -label "Image-Size : " \
                -options { label.width 22 label.anchor e }
        message $w.17.imglabelval -width 250 -relief sunken -borderwidth 1 \
                -text ""
        pack $w.17 -fill x -expand 1 -padx 10 -pady 5 
        tixForm $w.17.imglabel -left %0
        tixForm $w.17.imglabelval -left %50 -right %98

        button $w.cancel -text "Done" \
                -command "destroysubwindow $w .root {$oldf} 2"
        pack $w.cancel -pady 5 -side left -expand 1

        if { $NONISO == 0 } {
                # only ISO-filesystems can be shown
                set out [getimagecontents $drive]
        } else {
                set out -2
        }

        # no such directory?
        if { $out == -1 } {
                $w1.b subwidget listbox insert 0 \
                        "" "" "" "" "" "" "                                 Invalid Image!"

                tkwait window $w
                return
        }

        # NON-ISO
        if { $out == -2 } {
                $w1.b subwidget listbox insert 0 \
                        "" "" "" "" "" "" "                                 NON-ISO9660 Image!"

                tkwait window $w
                return
        }

        foreach i $out {
                $w1.b subwidget listbox insert end $i
        }

	set size [getisosize $drive]
        set size [expr $size/1024/1024]
        $w.17.imglabelval config -text "$size MB"

        set label [getisolabel $drive]
        $w.16.imglabelval config -text "$label"

        
        tkwait window $w
}


# called when a user double-clicks on the image-info-window

proc imageinfoclick { w } {
global IMAGE_PART
global IMAGE_MNTPNT
global TMP_DESTNAME
global TMP_DEST
global audiotrackinfo

	# check if we are working on partition or file
	# I hope this primitive check works
	if { $IMAGE_PART == "" } {
		set TMP_DEST "file"
	} elseif { [isiso $IMAGE_PART] } {
		set TMP_DEST "part"
	} else {
		set TMP_DEST "file"
	}

	set sel [$w.listbox curselection]
	if { $sel == "" } {
		# nothing selected?
		return
	}

	set val [$w.listbox get $sel]

	set filename ""
	set type ""

	if { [string first ".raw" $val] != -1 } {
		set idx1 [expr [string first " " $val] + 1]
		set idx2 [expr [string last "(" $val] - 2 ]
		set filename [string range $val $idx1 $idx2]
		set type "image"
	}
	if { [string first ".cdr" $val] != -1 } {
		set idx1 [expr [string first " " $val] + 1]
		set idx2 [expr [string last "(" $val] - 2 ]
		set filename [string range $val $idx1 $idx2]
		set type "audio"
	}
	if { [string first ".wav" $val] != -1 } {
		set idx1 [expr [string first " " $val] + 1]
		set idx2 [expr [string last "(" $val] - 2 ]
		set filename [string range $val $idx1 $idx2]
		set type "audio"
	}
	if { [string first ".au" $val] != -1 } {
		set idx1 [expr [string first " " $val] + 1]
		set idx2 [expr [string last "(" $val] - 2 ]
		set filename [string range $val $idx1 $idx2]
		set type "audio"
	}
	if { [string first ": Data" $val] != -1 } {
		set type "image"
		set filename "partition"
	}

	# have we clicked on a filename?
	if { $filename == "" } {
		return
	}

	set TMP_DESTNAME [string trim $filename]
	if { $type == "image" } {
		masterreviewimage .masterreview .root
	} else {
		# create filename of info-file for audio
		set basename [string range $filename 0 [expr [string last . $filename]-1]]
		set i_name "$IMAGE_MNTPNT/$basename.inf"

		set audiotrackinfo [loadfile2list $i_name]

		showtrackinfo_doit .audioinfo .root
	}
}


# show audio information

proc MkAudioInfo { w } {
global XCDR_AUDIO_SOURCE_CDROM	
global XCDR_AUDIOREAD_SPEED
global XCDR_DEST_WRITER_DEV
global XCDR_DEST_WRITER_SPEED
global XCDR_DEFAULT_PART
global XCDR_IMAGE_PART
global XCDR_IMAGE_MNTPNT
global XCDR_IMAGE_PART2
global XCDR_IMAGE_MNTPNT2
global XCDR_IMAGE_FIXED
global TMP_XCDR_DEFAULT_PART

	# Draw header-bar
	label $w.l -text "COPY AUDIO-CD" -relief sunken -borderwidth 2 -anchor c
	pack $w.l -fill x -expand 1 -ipady 10 -pady 5

	# Create Devices-Setup
	tixLabelFrame $w.devs -label Devices-Setup 
	set w1 [$w.devs subwidget frame]
	pack $w.devs -expand 1 -fill x

	frame $w1.1
	tixLabelWidget $w1.1.readl -label "Audio-Read-Device : " \
		-options {label.width 25 label.anchor e}
	message $w1.1.readt -anchor w -width 300 -relief groove
	$w1.1.readt configure -text $XCDR_AUDIO_SOURCE_CDROM
	if { $XCDR_AUDIOREAD_SPEED == -1 } {
		label $w1.1.spd -text "Speed: Default"
	} else {
		label $w1.1.spd -text "Speed: $XCDR_AUDIOREAD_SPEED x"
	}
	tixForm $w1.1.readl -left %0
	tixForm $w1.1.readt -left %32 -right %80
	tixForm $w1.1.spd -left %82

	frame $w1.2
	tixLabelWidget $w1.2.imgl -label "Image-Device : " \
		-options {label.width 25 label.anchor e}
	message $w1.2.imgt -anchor w -width 300 -relief groove  
	$w1.2.imgt configure -text "\n\n" 

	set tmpval $TMP_XCDR_DEFAULT_PART
	unset TMP_XCDR_DEFAULT_PART

	# prepare the quick-image-select menu
	tixOptionMenu $w1.2.select -variable TMP_XCDR_DEFAULT_PART \
		-options { label.width 0 menubutton.width 12 } \
		-command "quickselimage $w1 $w"

	if { $XCDR_IMAGE_PART != "" && $XCDR_IMAGE_MNTPNT != "" } {
		$w1.2.select add command "Partition 1"
	}
	if { $XCDR_IMAGE_PART2 != "" && $XCDR_IMAGE_MNTPNT2 != "" } {
		$w1.2.select add command "Partition 2"
	}
	if { $XCDR_IMAGE_FIXED != "" } {
		$w1.2.select add command "Image-Path"
	}

	if { $XCDR_DEFAULT_PART == "1" } {
		catch { $w1.2.select configure -value "Partition 1" }
	}	
	if { $XCDR_DEFAULT_PART == "2" } {
		catch { $w1.2.select configure -value "Partition 2" }
	}	
	if { $XCDR_DEFAULT_PART == "3" } {
		catch { $w1.2.select configure -value "Image-Path" }
	}	
	if { $tmpval != "" } {
		catch { $w1.2.select configure -value $tmpval }
	}

	tixForm $w1.2.imgl -left %0
	tixForm $w1.2.imgt -left %32 -right %80
	tixForm $w1.2.select -left %82 -right %99

	frame $w1.3
	tixLabelWidget $w1.3.writel -label "Write-Device : " \
		-options {label.width 25 label.anchor e}
	message $w1.3.writet -anchor w -width 300 -relief groove
	$w1.3.writet configure -text $XCDR_DEST_WRITER_DEV
	label $w1.3.spd -text "Speed: $XCDR_DEST_WRITER_SPEED x"

	tixForm $w1.3.writel -left %0
	tixForm $w1.3.writet -left %32 -right %80
	tixForm $w1.3.spd -left %82
	
	pack $w1.1 $w1.2 $w1.3 -side top -expand 1 -fill x

	#-------------------------------------------------

	# Tile the window, create a left and a right frame
	frame $w.m
	frame $w.m.l
	frame $w.m.r
	pack $w.m.l $w.m.r -side left -pady 10 -padx 10
	pack $w.m

	# Create the Information-Windows
	tixLabelFrame $w.m.l.cdinfo -label CD-Information 
	set w2 [$w.m.l.cdinfo subwidget frame]
	pack $w.m.l.cdinfo -expand 1 -fill both
	tixScrolledListBox $w2.b -scrollbar auto -options {
		listbox.font 8x13 
		listbox.width 30 
		listbox.height 12 
	} -command "cdinfoclick $w2.b audio"

	# Set scrollbar-width
	$w2.b.vsb configure -width 10
	$w2.b.hsb configure -width 10
	pack $w2.b -expand 1 -fill both

	tixLabelFrame $w.m.r.imginfo -label Image-Information 
	set w3 [$w.m.r.imginfo subwidget frame]
	pack $w.m.r.imginfo -expand 1 -fill both
	tixScrolledListBox $w3.b -scrollbar auto -options {
		listbox.font 8x13 
		listbox.width 30 
		listbox.height 12 
	} -command "imageinfoclick $w3.b"

	# Set scrollbar-width
	$w3.b.vsb configure -width 10
	$w3.b.hsb configure -width 10
	pack $w3.b -expand 1 -fill both

	button $w.rescan -text "Update Information-Windows" \
		-command "copy:rescan_cmd $w $w2.b $w3.b audio"

	button $w.eject -text "Eject CD" \
		-command "ejectcd [convCD2block audio]"

	pack $w.rescan $w.eject -pady 5 -padx 70 -side right -fill x

	updatelistboxes $w2.b $w3.b $w audio 

}


# called when the quick-image-selector is modified 
# updates the image-partition display

proc quickselimage { w1 w newval } {
global XCDR_IMAGE_PART
global XCDR_IMAGE_MNTPNT
global XCDR_IMAGE_PART2
global XCDR_IMAGE_MNTPNT2
global XCDR_IMAGE_FIXED
global IMAGE_PART
global IMAGE_MNTPNT
global IMAGE_LABEL

	set IMAGE_LABEL $newval

	if { $newval == "Partition 1" } {
		set IMAGE_PART $XCDR_IMAGE_PART
		set IMAGE_MNTPNT $XCDR_IMAGE_MNTPNT
	}
	if { $newval == "Partition 2" } {
		set IMAGE_PART $XCDR_IMAGE_PART2
		set IMAGE_MNTPNT $XCDR_IMAGE_MNTPNT2
	}
	if { $newval == "Image-Path" } {
		set IMAGE_PART ""
		set IMAGE_MNTPNT $XCDR_IMAGE_FIXED
	}

	redraw_imagebox $w1.2.imgt

	# force an update of information-windows
	catch { $w.rescan invoke }
}


# fill a message widget w with the actual image-status

proc redraw_imagebox { w } {
global IMAGE_PART
global IMAGE_MNTPNT

	if { $IMAGE_PART != "" } {
		global TMP_IMAGE_PART
		set TMP_IMAGE_PART $w
		updateselimagetextbox IMAGE_PART
		# get the text from the messagebox and append the mountpoint
		set tmptxt [$w cget -text]
 		append tmptxt "\nMountpoint: $IMAGE_MNTPNT"
		$w configure -text $tmptxt 
	} else {
		$w configure \
		   -text "Save Image-Data in Directory:\n$IMAGE_MNTPNT\n" 
	}
}


# returns to the main-menu

proc datacopy:cancel_cmd { } {

	mainsidebar
}


# called by the "update-button" in the cd/image-info-screen

proc copy:rescan_cmd { w w1 w2 mode } {

	updatelistboxes $w1 $w2 $w $mode
}


# Update the information-listboxes
# w1 is the name of the cd-infobox, w2 the name of the image-infobox

proc updatelistboxes { w1 w2 w mode } {

	# Delete old contents of boxes
	$w1 subwidget listbox delete 0 end
	$w2 subwidget listbox delete 0 end
	
	updatecdinfobox $w1 $w $mode
	updateimginfobox $w2 $w
}


# Creates the entries in the cd-infobox

proc updatecdinfobox { w1 w mode } {

	if { [docheckcd $mode] } {
		# CD in drive
		set cdtoclist [getcdinfo [convCD2block $mode]]

		set type [lindex $cdtoclist 0]
		set label [lindex $cdtoclist 1]
		set nrtracks [lindex $cdtoclist 3]

		$w1 subwidget listbox insert 0 \
			"Type: $type" "Label: $label" "Tracks:"
	
		for { set i 1 } { $i <= $nrtracks } { incr i } {
			set trktype [lindex $cdtoclist [expr 5*$i+2]]
			set trksize [lindex $cdtoclist [expr 5*$i+3]]

			if { [string length $i] == 1 } {
				set newnr "0$i"
			} else {
				set newnr $i
			}
			if { $trktype == "Data" } {
				$w1 subwidget listbox insert end \
					"$newnr: $trktype  ($trksize MB)"
			} else {
				$w1 subwidget listbox insert end \
					"$newnr: $trktype ($trksize)"
			}
		}
	} else {
		# CD not in drive
		$w1 subwidget listbox insert 0 \
			"" "" "" "" "" "" "         No CD in drive!"  
	}
}


# Creates the entries in the image-infobox

proc updateimginfobox { w2 w } {
global IMAGE_PART
global IMAGE_MNTPNT


	# Update mount-table
	# (perhaps the user unmounted or mounted directories manually)
	updatemountinfo

	if { $IMAGE_PART != "" } {
		set imgstatus [CheckImagePartition $w]
		set fixedpath 0
	} else {
		# fixed-path
		set imgstatus 2
		set fixedpath 1
	}

	switch $imgstatus {
		0 {
			# Unknown Partition, not mounted
			$w2 subwidget listbox insert 0 \
			"Type: Unknown" "Label: N/A" "Tracks:"
		}

		1 {
			# ISO9660-Image on Partition, not mounted
			set label [getisolabel $IMAGE_PART]
			set size [getisosize $IMAGE_PART]
			set size [expr $size/1024/1024]

			$w2 subwidget listbox insert 0 \
			"Type: ISO9660-Data" "Label: $label" "Tracks:" \
			"01: Data  ($size MB)"

		}

		2 {
			# Ext2-Partition, mounted on mountpoint
			# or fixed-path 
			if { $fixedpath == 0 } {
				$w2 subwidget listbox insert 0 \
				"Type: Ext2-Partition" "Files:"
			} else {
				$w2 subwidget listbox insert 0 \
				"Type: Image-Data-Path" "Files:"
			}	

			# analyse directory-contents
			set rawlst ""
			catch { set rawlst [glob $IMAGE_MNTPNT/*.raw] }
			set rawlist [split $rawlst]

			set cddalst ""
			catch { set cddalst [glob $IMAGE_MNTPNT/*.cdr $IMAGE_MNTPNT/*.wav $IMAGE_MNTPNT/*.au] }
			set cddalist [split $cddalst]

			set infolst ""
			catch { set infolst [glob $IMAGE_MNTPNT/*.inf] }
			set infolist [split $infolst]			

			set runnr 1
			foreach i $rawlist {
				set name [file tail $i]
				set size [file size $i]
				set size [expr $size/1024/1024]

				if { [string length $runnr] == 1 } {
					set newnr "0$runnr"
				} else {
					set newnr $runnr
				}

				$w2 subwidget listbox insert end \
				"$newnr: $name ($size MB)"
				incr runnr
			}
			foreach i $cddalist {
				set name [file tail $i]
				set size [getaudiosize $i]

				if { [string length $runnr] == 1 } {
					set newnr "0$runnr"
				} else {
					set newnr $runnr
				}

				$w2 subwidget listbox insert end \
				"$newnr: $name ($size)"
				incr runnr
			}
		}
	}
}


# Read-Image-Dialog

proc readimagedialog { w } {
global IMAGE_PART
global IMAGE_MNTPNT
global IMAGE_LABEL
global XCDR_DATA_SOURCE_CDROM
global TMP_DESTNAME
global TMP_DEST
global NONISO
global remount_active

	# This is needed for the "file"-radiobutton. If you press this
	# button, and its needed to format the partition, this value
	# is used to find out if the programm itself triggered the 
	# button or the user. The programm invokes the button to 
	# ensure mounting after formatting.
	set remount_active 0

	set blkname [ convCD2block data ]

	# Ask user to insert CD in drive
	if {[checkifready .root data] == 1} {
		return
	}
	
	if {[checkifaudio $blkname] == 1 } {
		Msg_NoDataCD .ndcd .root 
		return
	}

	if {[checkifmixedmode $blkname] == 1 } {
		Msg_CopyAudioinData .ndcd .root 
	}

	if {[checkifiso $blkname] == 0 } {
		Msg_NoISOCD .nisocd .root 
		set NONISO 1
	} else {
		set NONISO 0
	}

	if { $NONISO == 0 } {
		set imgspace [expr [ getisosize $blkname ]/1024/1024]
		set imglabel "[getisolabel $blkname]"
	} else {
		set imgspace [expr [ getnonisosize $blkname ]/1024/1024] 
		set imglabel " - not available - "
		if { $imgspace == 0 } {
			Msg_ImpossibleNonIso .iniso .root 
			return
		}
	}

	set imgfree [ getfreeimgspace ]

        # Draw header-bar
        label $w.l -text "READ IMAGE" -relief sunken -borderwidth 2 -anchor c
        pack $w.l -fill x -expand 1 -ipady 10 -pady 5

	# Create Devices-Setup
	tixLabelFrame $w.devs -label Devices-Setup 
	set w1 [$w.devs subwidget frame]
	pack $w.devs -expand 1 -fill x

	frame $w1.1
	tixLabelWidget $w1.1.readl -label "Read Image from : " \
		-options {label.width 25 label.anchor e}
	message $w1.1.readt -anchor w -width 300 -relief groove
	$w1.1.readt configure -text $XCDR_DATA_SOURCE_CDROM

	tixForm $w1.1.readl -left %0
	tixForm $w1.1.readt -left %32 -right %80

	frame $w1.2
	tixLabelWidget $w1.2.imgl -label "Save Image on : " \
		-options {label.width 25 label.anchor e}
	message $w1.2.imgt -anchor w -width 300 -relief groove  
	label $w1.2.lbl -text "\[$IMAGE_LABEL\]"
	redraw_imagebox $w1.2.imgt

	tixForm $w1.2.imgl -left %0
	tixForm $w1.2.imgt -left %32 -right %80
	tixForm $w1.2.lbl -left %82 

	pack $w1.1 $w1.2 -side top -expand 1 -fill x

	#-------------------------------------------------

	frame $w.1
	tixLabelWidget $w.1.imgsize -label "Diskspace needed for Image : " \
		-options { label.width 30 label.anchor e }
	message $w.1.imgsizeval -width 150 -relief sunken -borderwidth 1 \
		-text "$imgspace MB"
	frame $w.15
	tixLabelWidget $w.15.imgfree -label "Diskspace available : " \
		-options { label.width 30 label.anchor e }
	message $w.15.imgfreeval -width 150 -relief sunken -borderwidth 1 \
		-text "$imgfree MB"
	frame $w.16
	tixLabelWidget $w.16.imglabel -label "Image-ISO9660-Label : " \
		-options { label.width 30 label.anchor e }
	message $w.16.imglabelval -width 150 -relief sunken -borderwidth 1 \
		-text "$imglabel"

	pack $w.1 -fill x -expand 1 -padx 10 -pady 10
	tixForm $w.1.imgsize -left %0
	tixForm $w.1.imgsizeval -left %40 -right %70
	pack $w.15 -fill x -expand 1 -padx 10 -pady 10
	tixForm $w.15.imgfree -left %0
	tixForm $w.15.imgfreeval -left %40 -right %70
	pack $w.16 -fill x -expand 1 -padx 10 -pady 10
	tixForm $w.16.imglabel -left %0
	tixForm $w.16.imglabelval -left %40 -right %70

	canvas $w.20 -height 0 -width 30 -relief sunken -borderwidth 1
	pack $w.20 -pady 10 -fill x -expand 1

	frame $w.2
	tixLabelWidget $w.2.l -label "Write Image to: " \
		-options { label.width 20 label.anchor e }
	radiobutton $w.2.b1 -text "Partition" -variable TMP_DEST \
		-value "part" -command "selectedpart $w"
	radiobutton $w.2.b2 -text "File" -variable TMP_DEST \
		-value "file" -command "selectedfile $w"
	pack $w.2 -expand 1 -fill x -padx 10
	pack $w.2.l $w.2.b1 $w.2.b2 -side left

	frame $w.3

	tixLabelEntry $w.3.imgfname -disabledforeground gray \
		-options {
			label.width 20 label.anchor e
			entry.width 15 entry.textVariable TMP_DESTNAME 
		}
	pack $w.3 -fill x -expand 1 -padx 10 -pady 10
	tixForm $w.3.imgfname -left %0 -right %70

	# set default-image-name
	if { $TMP_DESTNAME == "" } {
		set TMP_DESTNAME "image1.raw"
	}
	# Bind to Return in entry-widget the action to update the free-size
	bind $w.3.imgfname.frame.entry <Return> \
		"updatefreesize $w.15.imgfreeval"

	canvas $w.30 -height 0 -width 30 -relief sunken -borderwidth 1
	pack $w.30 -pady 10 -fill x -expand 1

	button $w.start -text "Start Read Image" \
		-command "readimagedoit .read_doit" 

	pack $w.start -pady 7 

	# Trigger default button "partition" if image is not mounted,
	# else trigger "file" 
	if { [getmountpnt $IMAGE_PART] == "" && $IMAGE_PART != "" } {
		$w.2.b1 invoke
	} else {
		$w.2.b2 invoke
	}

	# If non-iso-cd, don't allow writing to partition
	if { $NONISO == 1 || $IMAGE_PART == "" } {
		$w.2.b1 configure -state disabled
		$w.2.b2 invoke
	}

}


# Update the freesize-display...called by <Return> in image-name-entry
# Also looks if the new image-file will overwrite an old one.

proc updatefreesize { w } {
global TMP_DESTNAME
global TMP_DEST
global IMAGE_PART
global IMAGE_MNTPNT
global TMP_freespace 

	# If a file with the same name already exist on the image-partition,
	# then add its size with free space, because it will be
	# overwritten

	if { $TMP_DEST == "file" } {
		set imgfree [ getfreeimgspace ]

		if { [ file exists $IMAGE_MNTPNT/$TMP_DESTNAME ] } {
			set filesize [ file size $IMAGE_MNTPNT/$TMP_DESTNAME ]
		} else {
			set filesize 0
		}
		set filesize [expr $filesize/1024/1024]
		set newsize [expr $imgfree+$filesize]

		$w configure -text "$newsize MB"
		set TMP_freespace $newsize
	} else {
		set imgfree [ getfreeimgspace ]
		$w configure -text "$imgfree MB"
		set TMP_freespace $imgfree
	}
}	


# This procedure is called when the user presses the "Partition"-Button
# in the Read-Image-Menu

proc selectedpart { w } {
global IMAGE_PART
global TMP_DEST 

	$w.3.imgfname configure -state disabled 

	# Is the image-partition mounted? If yes umount it...
	if { [getmountpnt $IMAGE_PART] != "" } {
		set stat [Msg_MustUmountImage .selpart .root]
		if { $stat == 0 } { ;# Ok 
			set mstat [doumount $IMAGE_PART]
			if { $mstat == 0 } { ; # umount failed
				Msg_UmountImageFail .selpartfail .root 
				# Invoke file-button
				$w.2.b2 invoke
			} else {
				Msg_Umounted .umnt .root $IMAGE_PART 
			}
		} else { ;# Cancel
			$w.2.b2 invoke
		}
	}	
	# Update free-space display
	updatefreesize $w.15.imgfreeval
}


# This procedure is called when the user presses the "File"-Button
# in the Read-Image-Menu

proc selectedfile { w } {
global IMAGE_PART
global IMAGE_MNTPNT
global NONISO
global remount_active

	$w.3.imgfname configure -state normal 

	# Is the image-partition mounted? If not mount it...
	if { [getmountpnt $IMAGE_PART] == "" && $IMAGE_PART != "" } {

		# Is this a remount? If yes, don't ask the user for
		# confirmation 
		if { $remount_active == 0 } {
			set stat [Msg_MustMountImage .selfile .root]
		} else {
			set stat 0 	;# Simulate Ok
		}

		if { $stat == 0 } { 	;# Ok 
			set mstat [domountext2 $IMAGE_PART $IMAGE_MNTPNT]
			if { $mstat == 0 } { ; # mount failed
				set fstat [Msg_MountImageFail .selfilefail .root]
				if { $fstat == 0 } { ;# Format
					set fout [makeformat $IMAGE_PART .root]
					if { $fout == 0 } {
						Msg_FormatFailed .frmtfail .root $IMAGE_PART
						exit
					} else {
						# remount (or try to)
						set remount_active 1
						$w.2.b2 invoke
					}
				} else { ;# Cancel
					# Don't allow noniso-images on partition
					if { $NONISO == 1 } {
						destroy $w
						return 
					} else {
					# Invoke partition-button
						$w.2.b1 invoke
					}
				}
			} elseif { $mstat == 2 } {
				# mountdir busy
					Msg_MountdirBusy .mntbusy .root $IMAGE_MNTPNT

					# Don't allow noniso-images on partition
					if { $NONISO == 1 } {
						destroy $w
						return 
					} else {
					# Invoke partition-button
						$w.2.b1 invoke
					}

			} else { 	;# Mount ok
				Msg_Mounted .dmnt .root $IMAGE_PART $IMAGE_MNTPNT
			}
		} else { ;# Cancel
			# Don't allow noniso-images on partition
			if { $NONISO == 1 } {
				destroy $w
				return 
			} else {
				$w.2.b1 invoke
			}
		}
	}	
	set remount_active 0
	# Update free-space display
	updatefreesize $w.15.imgfreeval
	update
}


# Format image-partition and show a please-wait-window

proc makeformat { dev old } {
global IMAGE_PART

	set new .format

	set oldf [createsubwindow $new $old 2 "" ]

	.format configure -cursor watch
	label $new.l -text "Formatting Image-Partition"
	label $new.l2 -text "Please wait"
	pack $new.l $new.l2 -padx 10 -pady 10
	update
	doformat $dev 

	destroysubwindow $new $old {$oldf} 2

	log .root "formatted Image-Partition $IMAGE_PART"
}


# Update the process bar $canv to $percent
# works now with a tixmeter-widget

proc drawbar { canv percent } {

	if { $percent == "" } return

	$canv config -value [expr $percent/100.0]  
}


# Do the reading of the image, display a process bar

proc readimagedoit { w } {
global MYDD
global XCDR_DATA_SOURCE_CDROM
global XCDR_SUB_VIEW SUB_VIEW
global IMAGE_PART
global IMAGE_MNTPNT
global TMP_DEST TMP_DESTNAME
global TMP_freespace 
global NONISO

# This variables must be global, because the fileevent-command
# can't handle local-variables
global pipe tmpw waitforready outval

        # set default view
        if { $SUB_VIEW == "" } {
                set SUB_VIEW $XCDR_SUB_VIEW
        }

	# Sets the image-destination
	if { $TMP_DEST == "file" } {
		# Image to file
		set imgfile [ file tail $TMP_DESTNAME]
		set imagedest "$IMAGE_MNTPNT/$imgfile"
	} else {
		# Image to partition
		set imagedest $IMAGE_PART
	}

	set waitforready 0

	set blkname [ convCD2block data ]

	set nrblocksiso [expr [ getisosize $blkname ]/2048]
        set nrblocksnoniso [expr [ getnonisosize $blkname ]/2048] 
        if { $NONISO == 0 } {
		set nrblocks $nrblocksiso
        } else {
                set nrblocks $nrblocksnoniso 
        }

	# experimental feature
	# check if nonisosize (reported by toc) is much larger than
	# the isosize (reported by iso9660-header)

	if { $nrblocksnoniso > 0 } {
		if { [expr ($nrblocksiso*100)/$nrblocksnoniso] < 95 && $NONISO == 0 } {
			# over 5% size difference...let the user choose to 
			# copy all instead only isopart
			set isosz [expr $nrblocksiso/512]
			set tocsz [expr $nrblocksnoniso/512]
			set stat [Msg_HFSISOCD .hfsiso .root $isosz $tocsz]
			if { $stat == 2 } {	;# Cancel
				return
			}
			if { $stat == 0 } {	;# copy ISO only
				set nrblocks $nrblocksiso
			}
			if { $stat == 1 } {	;# copy all
                		set nrblocks $nrblocksnoniso 
				if { $TMP_DEST != "file" } {
					# if not file selected, quit
					Msg_NeedSaveToFile .needfile .root
					return
				}
			}
		}
	}

	# Check if enough space
	set spaceneeded [expr $nrblocks/512]
	if { $spaceneeded > $TMP_freespace } {
		set stat [Msg_NotEnoughSpace .nospace .root]
		if { $stat == 0 } { 	;# Cancel
			return
		}
	}

	log .root "Read-Image to $imagedest, $nrblocks blocks"

	set cmd "$MYDD $blkname $imagedest $nrblocks"

	log .root "Executing: $cmd"

        # create extended command-line
        set cmd [execshell $cmd]

	# create new window
	set oldf [createsubwindow $w .root 1 "Read Image" ]

	set pipe [open "|$cmd" r+]

        # create menu
        frame $w.menu -bd 1 -relief raised
        menubutton $w.menu.file -menu $w.menu.file.m -text "File" \
                -font "-*-helvetica-medium-r-normal-*-10-*-*-*-*-*-*-*"
        menu $w.menu.file.m
        $w.menu.file.m add command -label "Save Process-Output" \
                -font "-*-helvetica-medium-r-normal-*-10-*-*-*-*-*-*-*" \
                -command "saveoutputbuffer .savebuf $w $w.t.t readimg.out" 
        menubutton $w.menu.view -menu $w.menu.view.m -text "View" \
                -font "-*-helvetica-medium-r-normal-*-10-*-*-*-*-*-*-*"
        menu $w.menu.view.m
        $w.menu.view.m add radio -label "Normal" -value 0 -variable SUB_VIEW \
                -font "-*-helvetica-medium-r-normal-*-10-*-*-*-*-*-*-*" \
                -command "changedowriteview $w 0"
        $w.menu.view.m add radio -label "Extended" -value 1 -variable SUB_VIEW \
                 -font "-*-helvetica-medium-r-normal-*-10-*-*-*-*-*-*-*" \
                -command "changedowriteview $w 1"
        $w.menu.view.m add radio -label "Small" -value 2 -variable SUB_VIEW \
                -font "-*-helvetica-medium-r-normal-*-10-*-*-*-*-*-*-*" \
                -command "changedowriteview $w 2" 
        pack $w.menu.file -side left
        pack $w.menu.view -side left
        pack $w.menu -fill x -expand 1


	frame $w.1
	label $w.1.l -text "Reading Image... Please wait"
	tixMeter $w.1.c -height 20 -width 300 
	pack $w.1.l $w.1.c -padx 10 -pady 10
	pack $w.1

        # alternative "small" view 
        frame $w.2
        tixMeter $w.2.c -height 10 -width 100
        button $w.2.cancel -text "Cancel" -command {
                set waitforready 2 
                catch { close $pipe }
        }
        pack $w.2.c $w.2.cancel -side left

        tixButtonBox $w.1.box -orientation horizontal
        $w.1.box add cancel -text "Cancel" -command {
		set waitforready 2 
		catch { close $pipe }
	}
	pack $w.1.box -fill x -expand 1

        # create an optional text-widget to view any output generated by
        # subprocess
        frame $w.t      
        text $w.t.t -height 4 -width 36 -yscrollcommand "$w.t.scr set"
        scrollbar $w.t.scr -command "$w.t.t yview"
        pack $w.t.scr $w.t.t -side right -fill y
        pack $w.t


	set tmpw $w
	fileevent $pipe readable {
		global pipe tmpw waitforready outval
		set outval [gets $pipe] 

		if { [eof $pipe] } { 
			catch { close $pipe }
			set waitforready 1; 	
		}

		if { [string index $outval 0] != "P" } {
                	# add to text-window and scroll to its end
                	$tmpw.t.t insert end "$outval\n"
                	$tmpw.t.t see end
		}

                if { [string index $outval 0] == "R" || 
		     [string index $outval 0] == "E" } {
                        set outval ""
                        set waitforready 3; catch { close $pipe }
		}
                if { [string index $outval 0] == "W" } {
                        set outval ""
                        set waitforready 4; catch { close $pipe }
		}
		if { $outval == "Done" } { 
			set outval 100
			set waitforready 1; catch { close $pipe }
		}
		
		if { [string index $outval 0] == "P" } {
			set pct [string range $outval 1 end]
			drawbar $tmpw.1.c $pct 
			drawbar $tmpw.2.c $pct 
		}
	}	

        # redraw window with correct appearance
        changedowriteview $w $SUB_VIEW 

	tkwait variable waitforready

	#we are done with reading now...
	if { $waitforready == 1 } {
		if { $outval == 100 } {
			$w.1.l configure -text "Image successfully read."
			drawbar $tmpw.1.c 100 
			drawbar $tmpw.2.c 100 
			log $w "Read-Image: OK"
		} else {
			$w.1.l configure -text "Some error occured!!!"
			$w.2.cancel config -bg red
			log $w "Read-Image: Some error occured"
		}
	} elseif { $waitforready == 2 } {
		$w.1.l configure -text "Read Image aborted!"	
		$w.2.cancel config -bg red
		log $w "Read-Image: aborted"
	} elseif { $waitforready == 3 } {
		$w.1.l configure -text "Read-Error!!"	
		$w.2.cancel config -bg red
		log $w "Read-Image: read-error"
	} elseif { $waitforready == 4 } {
		$w.1.l configure -text "Write-Error!!"	
		$w.2.cancel config -bg red
		log $w "Read-Image: write-error"
	}

	$w.1.box.cancel configure -text "Ok" \
		-command "destroysubwindow $w .root {$oldf} 1" -width 5
	$w.2.cancel configure -text "Ok" \
		-command "destroysubwindow $w .root {$oldf} 1" -width 5
	sound 1
	chownfile $imagedest

	# Clear the global variables
	unset pipe tmpw waitforready

	# wait until window is destroyed
	tkwait window $w
}


# Verify-Image-Dialog

proc verifyimagedialog { w } {
global IMAGE_PART
global IMAGE_MNTPNT
global IMAGE_LABEL
global XCDR_DATA_SOURCE_CDROM
global TMP_DESTNAME
global TMP_DEST
global NONISO

	set blkname [ convCD2block data ]

	# Ask user to insert CD in drive
	if {[checkifready .root data] == 1} {
		return
	}
	
	if {[checkifaudio $blkname] == 1 } {
		Msg_NoDataCD .ndcd .root 
		return
	}
        if {[checkifiso $blkname] == 0 } {
                set NONISO 1
        } else {
                set NONISO 0
        }

        if { $NONISO == 0 } {
                set imgspace [expr [ getisosize $blkname ]/1024/1024]
		set imglabel "[getisolabel $blkname]"
        } else {
                set imgspace [expr [ getnonisosize $blkname ]/1024/1024] 
		set imglabel " - not available - "
		if { $imgspace == 0 } {
			Msg_ImpossibleNonIso .iniso .root 
			return
		}
        }

        # Draw header-bar
        label $w.l -text "VERIFY IMAGE" -relief sunken -borderwidth 2 -anchor c
        pack $w.l -fill x -expand 1 -ipady 10 -pady 5

        # Create Devices-Setup
        tixLabelFrame $w.devs -label Devices-Setup 
        set w1 [$w.devs subwidget frame]
        pack $w.devs -expand 1 -fill x

        frame $w1.1
        tixLabelWidget $w1.1.readl -label "Compare Image from : " \
                -options {label.width 25 label.anchor e}
        message $w1.1.readt -anchor w -width 300 -relief groove
        $w1.1.readt configure -text $XCDR_DATA_SOURCE_CDROM

        tixForm $w1.1.readl -left %0
        tixForm $w1.1.readt -left %32 -right %80

        frame $w1.2
        tixLabelWidget $w1.2.imgl -label "Compare with Image on : " \
                -options {label.width 25 label.anchor e}
        message $w1.2.imgt -anchor w -width 300 -relief groove  
	label $w1.2.lbl -text "\[$IMAGE_LABEL\]"
        redraw_imagebox $w1.2.imgt

        tixForm $w1.2.imgl -left %0
        tixForm $w1.2.imgt -left %32 -right %80
        tixForm $w1.2.lbl -left %82

        pack $w1.1 $w1.2 -side top -expand 1 -fill x

        #-------------------------------------------------

	frame $w.1
	tixLabelWidget $w.1.imgsize -label "Image Size: " \
		-options { label.width 30 label.anchor e }
	message $w.1.imgsizeval -width 150 -relief sunken -borderwidth 1 \
		-text "$imgspace MB"
	frame $w.16
	tixLabelWidget $w.16.imglabel -label "Image-ISO9660-Label : " \
		-options { label.width 30 label.anchor e }
	message $w.16.imglabelval -width 150 -relief sunken -borderwidth 1 \
		-text "$imglabel"

	pack $w.1 -fill x -expand 1 -padx 10 -pady 10
	tixForm $w.1.imgsize -left %0
	tixForm $w.1.imgsizeval -left %40 -right %70
	pack $w.16 -fill x -expand 1 -padx 10 -pady 10
	tixForm $w.16.imglabel -left %0
	tixForm $w.16.imglabelval -left %40 -right %70

        canvas $w.20 -height 0 -width 30 -relief sunken -borderwidth 1
        pack $w.20 -pady 10 -fill x -expand 1

	frame $w.2
	tixLabelWidget $w.2.l -label "Verify Image on: " \
		-options { label.width 20 label.anchor e }
	radiobutton $w.2.b1 -text "Partition" -variable TMP_DEST \
		-value "part" -command "selectedverifypart $w"
	radiobutton $w.2.b2 -text "File" -variable TMP_DEST \
		-value "file" -command "selectedverifyfile $w"
	pack $w.2 -expand 1 -fill x -padx 10
	pack $w.2.l $w.2.b1 $w.2.b2 -side left

	frame $w.3

	tixComboBox $w.3.imgfname -disabledforeground gray \
		-editable true -dropdown true -variable TMP_DESTNAME \
		-selectmode immediate \
		-options {
			label.width 20 
			label.anchor e
			listbox.height 5
			entry.width 15 
		}

	pack $w.3 -fill x -expand 1 -padx 10 -pady 10
	tixForm $w.3.imgfname -left %0 -right %70 

	# analyse directory-contents
	set rawlst ""
	catch { set rawlst [glob $IMAGE_MNTPNT/*.raw] }
	set rawlist [split $rawlst]
	foreach i $rawlist {
		set name [file tail $i]
		$w.3.imgfname insert end "$name"

		# If this filename was selected in the read-image-box
		# also select it now.
		if { $name == $TMP_DESTNAME } {
			tixSetSilent $w.3.imgfname $name
		}
	}
	# If there is only one image-file in the directory, select it
	if { [llength $rawlist] == 1 } {
		tixSetSilent $w.3.imgfname [file tail $rawlist]
	}

        canvas $w.30 -height 0 -width 30 -relief sunken -borderwidth 1
        pack $w.30 -pady 10 -fill x -expand 1

        button $w.start -text "Start Verify Image" \
                -command "verifyimagedoit .verify_doit data" 

        pack $w.start -pady 7 

	# Trigger default button "partition" if image is not mounted,
	# else trigger "file" 
	if { [getmountpnt $IMAGE_PART] == "" && $IMAGE_PART != ""} {
		$w.2.b1 invoke
	} else {
		$w.2.b2 invoke
	}

	# if on fixed-directory, dont allow partition
	if { $IMAGE_PART == "" } {
		$w.2.b1 configure -state disabled
		$w.2.b2 invoke
	}
}


# This procedure is called when the user presses the "Partition"-Button
# in the Verify-Image-Menu

proc selectedverifypart { w } {
global IMAGE_PART

	$w.3.imgfname configure -state disabled 

	# Is the image-partition mounted? 
	if { [getmountpnt $IMAGE_PART] != "" } {
		Msg_CantVerifyPartition .selverifypart .root

		# Press File-Button
		$w.2.b2 invoke
	}
}

		
# This procedure is called when the user presses the "File"-Button
# in the Verify-Image-Menu

proc selectedverifyfile { w } {
global IMAGE_PART

	$w.3.imgfname configure -state normal 

	# Is the image-partition mounted? 
	if { [getmountpnt $IMAGE_PART] == "" && $IMAGE_PART != "" } {
		Msg_CantVerifyFile .selverifyfile .root

		# Press Partition-Button
		$w.2.b1 invoke
		
	}	
}


# Do the verify of the image

proc verifyimagedoit { w mode } {
global MYCMP
global IMAGE_PART
global IMAGE_MNTPNT
global XCDR_DEST_WRITER_DEV
global XCDR_SUB_VIEW SUB_VIEW
global TMP_DEST TMP_DESTNAME
global NONISO

# This variables must be global, because the fileevent-command
# can't handle local-variables
global pipe tmpw waitforready

        # set default view
        if { $SUB_VIEW == "" } {
                set SUB_VIEW $XCDR_SUB_VIEW
        }

	# Sets the image-destination
	if { $TMP_DEST == "file" } {
		# Image to file
		set imgfile [ file tail $TMP_DESTNAME]
		set imagedest "$IMAGE_MNTPNT/$imgfile"
	} elseif { $TMP_DEST == "part" } {
		# Image to partition
		set imagedest $IMAGE_PART
	} elseif { $TMP_DEST == "quick" } {
		# Image on CD-R
		set imagedest [ convertCDnametoblkdevice $XCDR_DEST_WRITER_DEV ]
	} else {
                puts "verifyimagedoit: This should never happen!"
                exit;
	}

	# check if our image exists
	if { [file exists $imagedest] == 0 || \
			[file isdirectory $imagedest] == 1 } {
		Msg_ImageNotFound .imgnotf .root
		return
	}

	set waitforready 0

	set blkname [ convCD2block $mode ]

        set nrblocksiso [expr [ getisosize $blkname ]/2048]
        set nrblocksnoniso [expr [ getnonisosize $blkname ]/2048] 

        if { $NONISO == 0 } {
                set nrblocks $nrblocksiso  
        } else {
                set nrblocks $nrblocksnoniso 
        }

	# check if we have a non-standard-image
	if { $TMP_DEST == "file" && $NONISO == 0 } {
		# blocks saved in image-file
		set imagesize [expr [file size $imagedest]/2048]	
		if { $imagesize > $nrblocksiso } {
			# looks we have a non-standard image 
			# because the file is larger than the isoheader
			# tells us.
                	set nrblocks $nrblocksnoniso 
		}
	}

	log .root "Verify-Image to $imagedest, $nrblocks blocks"

	set cmd "$MYCMP $blkname $imagedest $nrblocks"

	log .root "Executing: $cmd"

	# create extended command-line
        set cmd [execshell $cmd]

	# create new window
	set oldf [createsubwindow $w .root 1 "Verify Image"]

	set pipe [open "|$cmd" r+]

        # create menu
        frame $w.menu -bd 1 -relief raised
        menubutton $w.menu.file -menu $w.menu.file.m -text "File" \
                -font "-*-helvetica-medium-r-normal-*-10-*-*-*-*-*-*-*"
        menu $w.menu.file.m
        $w.menu.file.m add command -label "Save Process-Output" \
                -font "-*-helvetica-medium-r-normal-*-10-*-*-*-*-*-*-*" \
                -command "saveoutputbuffer .savebuf $w $w.t.t vrfyimg.out" 
        menubutton $w.menu.view -menu $w.menu.view.m -text "View" \
                -font "-*-helvetica-medium-r-normal-*-10-*-*-*-*-*-*-*"
        menu $w.menu.view.m
        $w.menu.view.m add radio -label "Normal" -value 0 -variable SUB_VIEW \
                -font "-*-helvetica-medium-r-normal-*-10-*-*-*-*-*-*-*" \
                -command "changedowriteview $w 0"
        $w.menu.view.m add radio -label "Extended" -value 1 -variable SUB_VIEW \
                 -font "-*-helvetica-medium-r-normal-*-10-*-*-*-*-*-*-*" \
                -command "changedowriteview $w 1"
        $w.menu.view.m add radio -label "Small" -value 2 -variable SUB_VIEW \
                -font "-*-helvetica-medium-r-normal-*-10-*-*-*-*-*-*-*" \
                -command "changedowriteview $w 2" 
        pack $w.menu.file -side left
        pack $w.menu.view -side left
        pack $w.menu -fill x -expand 1

	
	frame $w.1
	label $w.1.l -text "Verifying Image... Please wait"
	tixMeter $w.1.c -height 20 -width 300
	pack $w.1.l $w.1.c -padx 10 -pady 10
	pack $w.1

        # alternative "small" view 
        frame $w.2
        tixMeter $w.2.c -height 10 -width 100
        button $w.2.cancel -text "Cancel" -command {
                set waitforready 2 
                catch { close $pipe }
        }
        pack $w.2.c $w.2.cancel -side left

        tixButtonBox $w.1.box -orientation horizontal
        $w.1.box add cancel -text "Cancel" -command {
		set waitforready 2 
		catch { close $pipe }
	}
	pack $w.1.box -fill x -expand 1

        # create an optional text-widget to view any output generated by
        # subprocess
        frame $w.t      
        text $w.t.t -height 4 -width 36 -yscrollcommand "$w.t.scr set"
        scrollbar $w.t.scr -command "$w.t.t yview"
        pack $w.t.scr $w.t.t -side right -fill y
        pack $w.t


	set tmpw $w
	fileevent $pipe readable {
		global pipe tmpw waitforready out
		set out [gets $pipe] 

		if { [eof $pipe] } { 
			catch { close $pipe }
			set waitforready 3 
		}

		if { [string index $out 0] != "P" } {
			# add to text-window and scroll to its end
                	$tmpw.t.t insert end "$out\n"
                	$tmpw.t.t see end
		}

		if { [string index $out 0] == "F" } {
			set out ""
			set waitforready 3; catch { close $pipe	}
		}
		if { $out == "Done" } { 
			set out 100
			set waitforready 1; catch { close $pipe }
		}

		if { [string index $out 0] == "P" } {
			set pct [string range $out 1 end]
			drawbar $tmpw.1.c $pct 
			drawbar $tmpw.2.c $pct
		}
	}	

        # redraw window with correct appearance
        changedowriteview $w $SUB_VIEW 

	tkwait variable waitforready

	#we are done with reading now...
	if { $waitforready == 1 } {
		$w.1.l configure -text "Verify ok, no errors found!"
		drawbar $tmpw.1.c 100 
		drawbar $tmpw.2.c 100 
		log $w "Verify-Image: OK"
	} elseif { $waitforready == 2 } {
		$w.1.l configure -text "Verify Image aborted!"	
		$w.2.cancel config -bg red
		log $w "Verify-Image: aborted"
	} else {
		$w.1.l configure -text "Verify failed!"	
		$w.2.cancel config -bg red
		log $w "Verify-Image: failed"
	}

	$w.1.box.cancel configure -text "Ok" \
		-command "destroysubwindow $w .root {$oldf} 1" -width 5
        $w.2.cancel configure -text "Ok" \
                -command "destroysubwindow $w .root {$oldf} 1" -width 5
	sound 1

	# Clear the global variables
	unset pipe tmpw waitforready

	# wait until window is destroyed
        tkwait window $w
}


# Write-Image-Dialog

proc writeimagedialog { w } {
global IMAGE_PART
global IMAGE_MNTPNT
global IMAGE_LABEL
global XCDR_DEST_WRITER_DEV
global XCDR_DEST_WRITER_SPEED
global TMP_DESTNAME
global TMP_DEST
global cd_type
global DUMMY EJECT PADDATA
global XCDR_DUMMY XCDR_EJECT XCDR_PADDATA

	# default setting of cd-type
	if { [ info exists cd_type ] == 0  } {
		set cd_type 74
	}
	if { $DUMMY == "" } {
		set DUMMY $XCDR_DUMMY
	}
	if { $EJECT == "" } {
		set EJECT $XCDR_EJECT
	}
	if { $PADDATA == "" } {
		set PADDATA $XCDR_PADDATA
	}

        # Draw header-bar
        label $w.l -text "WRITE IMAGE" -relief sunken -borderwidth 2 -anchor c
        pack $w.l -fill x -expand 1 -ipady 10 -pady 5

        # Create Devices-Setup
        tixLabelFrame $w.devs -label Devices-Setup 
        set w1 [$w.devs subwidget frame]
        pack $w.devs -expand 1 -fill x

        frame $w1.2
        tixLabelWidget $w1.2.imgl -label "Read Image from : " \
                -options {label.width 25 label.anchor e}
        message $w1.2.imgt -anchor w -width 300 -relief groove  
	label $w1.2.lbl -text "\[$IMAGE_LABEL\]"
        redraw_imagebox $w1.2.imgt

        tixForm $w1.2.imgl -left %0
        tixForm $w1.2.imgt -left %32 -right %80
        tixForm $w1.2.lbl -left %82 

        frame $w1.3
        tixLabelWidget $w1.3.writel -label "Write Image to : " \
                -options {label.width 25 label.anchor e}
        message $w1.3.writet -anchor w -width 300 -relief groove
        $w1.3.writet configure -text $XCDR_DEST_WRITER_DEV
        #label $w1.3.spd -text "Speed: $XCDR_DEST_WRITER_SPEED x"

	set tmpval $XCDR_DEST_WRITER_SPEED
	unset XCDR_DEST_WRITER_SPEED
	tixOptionMenu $w1.3.spd -variable XCDR_DEST_WRITER_SPEED \
		-options { label.width 7 menubutton.width 1 } \
		-label "Speed: "	
	$w1.3.spd add command "0"
	$w1.3.spd add command "1"
	$w1.3.spd add command "2"
	$w1.3.spd add command "4"
	$w1.3.spd add command "6"
	$w1.3.spd add command "8"
	if { $tmpval != "" } {
		catch { $w1.3.spd configure -value $tmpval }
	}

        tixForm $w1.3.writel -left %0
        tixForm $w1.3.writet -left %32 -right %80
        tixForm $w1.3.spd -left %82

        pack $w1.2 $w1.3 -side top -expand 1 -fill x

        #-------------------------------------------------

	# create a left and right frame
	frame $w.mid
	frame $w.mid.l
	frame $w.mid.r
	pack $w.mid
	tixForm $w.mid.l -left %0 -right %63
	tixForm $w.mid.r -left %65 -right %100

	frame $w.mid.l.6
	tixLabelWidget $w.mid.l.6.type -label "CD-Recordable-Type: " \
		-options { label.width 25 label.anchor e }
	radiobutton $w.mid.l.6.b1 -text "74 min ( 650 MB )" -variable cd_type -value 74

	pack $w.mid.l.6 -fill x -expand 1 -padx 10 
	pack $w.mid.l.6.type $w.mid.l.6.b1 -side left

	frame $w.mid.l.5
	tixLabelWidget $w.mid.l.5.type \
		-options { label.width 25 label.anchor e }
	radiobutton $w.mid.l.5.b2 -text "63 min ( 553 MB )" -variable cd_type -value 63

	pack $w.mid.l.5 -fill x -expand 1 -padx 10 
	pack $w.mid.l.5.type $w.mid.l.5.b2 -side left

	frame $w.mid.l.1
	tixLabelWidget $w.mid.l.1.imgsize -label "Image Size : " \
		-options { label.width 25 label.anchor e }
	message $w.mid.l.1.imgsizeval -width 150 -relief sunken -borderwidth 1 \
		-text "0 MB"

	pack $w.mid.l.1 -fill x -expand 1 -padx 10 -pady 10
	pack $w.mid.l.1.imgsize -side left 
	pack $w.mid.l.1.imgsizeval -expand 1 -fill x -side left

	frame $w.mid.l.16
        tixLabelWidget $w.mid.l.16.imglabel -label "Image-ISO9660-Label : " \
                -options { label.width 25 label.anchor e }
        message $w.mid.l.16.imglabelval -width 150 -relief sunken \
		-borderwidth 1 -text ""

	pack $w.mid.l.16 -fill x -expand 1 -padx 10 -pady 10
	pack $w.mid.l.16.imglabel -side left 
	pack $w.mid.l.16.imglabelval -expand 1 -fill x -side left


	tixLabelFrame $w.mid.r.4 -label "Additional Options"
	set w1 [$w.mid.r.4 subwidget frame]
	pack $w.mid.r.4 -expand 1 -fill x -padx 30 -pady 10

	checkbutton $w1.b1 -variable DUMMY -anchor w \
		-text "Simulation-Write"
	pack $w1.b1 -expand 1 -fill x -padx 10 

	checkbutton $w1.b2 -variable EJECT -anchor w \
		-text "Eject after write"
	pack $w1.b2 -expand 1 -fill x -padx 10 

	checkbutton $w1.b3 -variable PADDATA -anchor w \
		-text "Pad Data-Track"
	pack $w1.b3 -expand 1 -fill x -padx 10 

	# ----------------------------

        canvas $w.20 -height 0 -width 30 -relief sunken -borderwidth 1
        pack $w.20 -pady 10 -fill x -expand 1

	frame $w.2
	tixLabelWidget $w.2.l -label "Write from: " \
		-options { label.width 20 label.anchor e }
	radiobutton $w.2.b1 -text "Partition" -variable TMP_DEST \
		-value "part" -command "selectedwritepart $w"
	radiobutton $w.2.b2 -text "File" -variable TMP_DEST \
		-value "file" -command "selectedwritefile $w 0"
	pack $w.2 -expand 1 -fill x -padx 10
	pack $w.2.l $w.2.b1 $w.2.b2 -side left

	frame $w.3

	tixComboBox $w.3.imgfname -disabledforeground gray \
		-editable true -dropdown true -variable TMP_DESTNAME \
		-selectmode immediate \
		-command "selectedwritefile $w" \
		-options {
			label.width 20 
			label.anchor e
			listbox.height 5
			entry.width 15 
		}

	pack $w.3 -fill x -expand 1 -padx 10 -pady 10
	tixForm $w.3.imgfname -left %0 -right %70 

	# analyse directory-contents
	set rawlst ""
	catch { set rawlst [glob $IMAGE_MNTPNT/*.raw] }
	set rawlist [split $rawlst]

	set match 0
	foreach i $rawlist {
		set name [file tail $i]
		$w.3.imgfname insert end "$name"

		# If this filename was selected in the read-image-box
		# also select it now.
		if { $name == $TMP_DESTNAME } {
			tixSetSilent $w.3.imgfname $name
		 	set match 1	
		}
	}
	# No match in list, so delete the TMP_DESTNAME
	if { $match == 0 } {
		$w.3.imgfname configure -disablecallback 1
		set TMP_DESTNAME ""
		$w.3.imgfname configure -disablecallback 0
	}

	# If there is still no image-file selected, select the first 
	if { $TMP_DESTNAME == "" && [llength $rawlist] >= 1 } {
		tixSetSilent $w.3.imgfname [file tail [lindex $rawlist 0]]
	}

        canvas $w.30 -height 0 -width 30 -relief sunken -borderwidth 1
        pack $w.30 -pady 10 -fill x -expand 1

        button $w.start -text "Start Write Image" \
		-command "writeimagedoit .write_doit"
	pack $w.start -pady 7 


	# Trigger default button "partition" if image is not mounted,
	# else trigger "file" 
	if { [getmountpnt $IMAGE_PART] == "" && $IMAGE_PART != "" } {
		$w.2.b1 invoke
	} else {
		$w.2.b2 invoke
	}
	
	# if on fixed-directory, dont allow partition
	if { $IMAGE_PART == "" } {
		$w.2.b1 configure -state disabled
		$w.2.b2 invoke
	}
}


# This procedure is called when the user presses the "Partition"-Button
# in the Write-Image-Menu

proc selectedwritepart { w } {
global IMAGE_PART

	$w.3.imgfname configure -state disabled 

	# Update Image-size-display for image on partition
	set isosize [expr [ getisosize $IMAGE_PART ]/1024/1024]
	set isolabel "[getisolabel $IMAGE_PART]"
	$w.mid.l.1.imgsizeval configure -text "$isosize MB"
	$w.mid.l.16.imglabelval configure -text "$isolabel"

	# Is the image-partition mounted? 
	if { [getmountpnt $IMAGE_PART] != "" } {
		Msg_CantWritePartition .selwritepart $w 

		# Press File-Button
		$w.2.b2 invoke
	}
}

		
# This procedure is called when the user presses the "File"-Button
# in the Write-Image-Menu

proc selectedwritefile { w tmp } {
global IMAGE_PART
global IMAGE_MNTPNT
global TMP_DESTNAME 

	$w.3.imgfname configure -state normal 

	# Update Image-size-display for image on file
	set isosize 0
	set isolabel ""
	catch { set isosize [expr [ file size $IMAGE_MNTPNT/$TMP_DESTNAME ]/1024/1024] }
	catch { set isolabel "[getisolabel $IMAGE_MNTPNT/$TMP_DESTNAME]" }
	$w.mid.l.1.imgsizeval configure -text "$isosize MB"
	$w.mid.l.16.imglabelval configure -text "$isolabel"

	# Is the image-partition mounted? 
	if { [getmountpnt $IMAGE_PART] == "" && $IMAGE_PART != "" } {
		Msg_CantWriteFile .selwritefile .root 

		# Press Partition-Button
		$w.2.b1 invoke
		
	}	
}


# Do the writing of the image

proc writeimagedoit { w } {
global CDWRITE CDRECORD
global XCDR_DEST_WRITER_DEV
global XCDR_DEST_WRITER_MODE
global XCDR_DEST_WRITER_SPEED
global IMAGE_PART
global IMAGE_MNTPNT
global TMP_DEST TMP_DESTNAME
global EJECT DUMMY PADDATA
global XCDR_SUB_VIEW SUB_VIEW DEBUG
global cd_type

# This variables must be global, because the fileevent-command
# can't handle local-variables
global pipe tmpw waitforready acttrk actfull

	# set default view
	if { $SUB_VIEW == "" } {
		set SUB_VIEW $XCDR_SUB_VIEW
	}

	# Sets the image-destination
	if { $TMP_DEST == "file" } {
		# Image on file
		set imgfile [ file tail $TMP_DESTNAME]
		set imagedest "$IMAGE_MNTPNT/$imgfile"
		set out [ catch { set filesize [ file size $imagedest] }]
		# File not found?
		if { $out == 1 || [file type $imagedest] == "directory" } { 
			Msg_ImageNotFound .inf .root 
			return
		}
		set isosize $filesize
	} elseif { $TMP_DEST == "part" } {
		# Image on partition
		set imagedest $IMAGE_PART
		set filesize -1 
		set isosize [ getisosize $imagedest ]
	} elseif { $TMP_DEST == "quick" } {
		set imagedest [ convCD2block data ]
		set filesize -1
		set isosize [ getisosize $imagedest ]
	} else {
		puts "writeimagedoit: This should never happen!"
		exit;
	}

	set waitforready 0
	
	# for cdwrite(old)
	#set cdwdev [ convertCDnametogendevice $XCDR_DEST_WRITER_DEV ]

	set cdwdev [ convertCDnametoscsidevnr $XCDR_DEST_WRITER_DEV ]

	# Check if CD runs out of space
	set isomb [expr $isosize/1024/1024] 
	if { $cd_type == 74 } {
		set cdfree 650 
	} else {
		set cdfree 553
	}
	if { $isomb > $cdfree } {
		set stat [Msg_CDoverrun .cdor .root]
		if { $stat == 0 } {	;# Abort
			return
		}
	}

	# Check if Image is truncated (only works with image on file)
	if { $filesize != -1 } {
		set sizeofiso [ getisosize $imagedest ]

		# check if getisosize delivered a sane size, if not
		# then it is perhaps a noniso-image, so don't check
		# any further.
		if { $sizeofiso > 0 && $sizeofiso < 734003200 &&
		     $sizeofiso > $filesize } {
			set stat [Msg_TruncatedImage .trimg .root]
			if { $stat == 0 } {	;# Abort
				return
			}
		}	
	}					

	# Check if the isosize is not zero. This would mean that
	# there is not image to burn. 
	if { $isosize == 0 } {
		Msg_ImageNotFound .inf .root 
		return
	}

	# Prompt user for inserting CDR
	set stat [Msg_InsertCDR .inscdr .root]
	if { $stat == 1 } {	;# Cancel
		return
	}

	# Construct command-line for cdwrite
	#set cmd "$CDWRITE -v -t -s $XCDR_DEST_WRITER_SPEED -D $cdwdev"
	#if { $EJECT == 1 } {
#		set cmd "$cmd -e"
#	} 
#	if { $DUMMY == 1 } {
#		set cmd "$cmd -y"
#	} 
#	if { $XCDR_DEST_WRITER_MODE != "Autodetect" } {
#		if { $XCDR_DEST_WRITER_MODE == "Philips/Kodak/IMS" } {
#			set cmd "$cmd --philips"
#		}
#		if { $XCDR_DEST_WRITER_MODE == "HP" } {
#			set cmd "$cmd --hp"
#		}
#		if { $XCDR_DEST_WRITER_MODE == "Yamaha" } {
#			set cmd "$cmd --yamaha"
#		}
#		if { $XCDR_DEST_WRITER_MODE == "Sony" } {
#			set cmd "$cmd --sony"
#		}
#	}
#	if { $PADDATA == 1 } {
#		set cmd "$cmd -P"
#	} 

	# Construct command-line for cdrecord
	set cmd "$CDRECORD -v speed=$XCDR_DEST_WRITER_SPEED dev=$cdwdev"

	if { $DEBUG > 2 } {
		# print debug 
		set cmd "$cmd -debug"
	}
	if { $DEBUG > 3 } {
		# very verbose
		set cmd "$cmd -V"
	}

	if { $EJECT == 1 } {
		set cmd "$cmd -eject"
	} 
	if { $DUMMY == 1 } {
		set cmd "$cmd -dummy"
	} 
	if { $XCDR_DEST_WRITER_MODE != "autodetect" } {
      		# must be dynamic! Call cdrecord driver=help for a
		# driver-list. Setup is doing that 
		set cmd "$cmd driver=$XCDR_DEST_WRITER_MODE"
	}
	if { $PADDATA == 1 } {
		set cmd "$cmd -pad"
	} 

	log $w "Write-Image from $imagedest, $isosize bytes, dummy=$DUMMY"

	# if image is raw on a partition, use the -isosize switch to
	# determine the image-size in cdrecord
	if { $TMP_DEST != "file" } {
		set cmd "$cmd -isosize"
	}
	set cmd "$cmd -data $imagedest"

	log $w "Executing: $cmd"

	# output debug-information
	if { $DEBUG > 0 } {
		puts "Debug:call: $cmd"
	}

	# create extended command-line
	set cmd [execshell $cmd]


	# create new window
	set oldf [createsubwindow $w .root 1 "Write Image"]

	set pipe [open "|$cmd" r+]
	
	# create menu
	frame $w.menu -bd 1 -relief raised
	menubutton $w.menu.file -menu $w.menu.file.m -text "File" \
		-font "-*-helvetica-medium-r-normal-*-10-*-*-*-*-*-*-*"
	menu $w.menu.file.m
	$w.menu.file.m add command -label "Save Process-Output" \
		-font "-*-helvetica-medium-r-normal-*-10-*-*-*-*-*-*-*" \
		-command "saveoutputbuffer .savebuf $w $w.t.t cdrecord.out" 
	menubutton $w.menu.view -menu $w.menu.view.m -text "View" \
		-font "-*-helvetica-medium-r-normal-*-10-*-*-*-*-*-*-*"
	menu $w.menu.view.m
	$w.menu.view.m add radio -label "Normal" -value 0 -variable SUB_VIEW \
		-font "-*-helvetica-medium-r-normal-*-10-*-*-*-*-*-*-*" \
		-command "changedowriteview $w 0"
	$w.menu.view.m add radio -label "Extended" -value 1 -variable SUB_VIEW \
		 -font "-*-helvetica-medium-r-normal-*-10-*-*-*-*-*-*-*" \
		-command "changedowriteview $w 1"
	$w.menu.view.m add radio -label "Small" -value 2 -variable SUB_VIEW \
		-font "-*-helvetica-medium-r-normal-*-10-*-*-*-*-*-*-*" \
		-command "changedowriteview $w 2" 
	pack $w.menu.file -side left
	pack $w.menu.view -side left
	pack $w.menu -fill x -expand 1

	frame $w.1 
	label $w.1.l -text "Writing Image... Please wait"
	label $w.1.l2 -text ""
	tixMeter $w.1.c -height 20 -width 300
	pack $w.1.l $w.1.l2 $w.1.c -padx 10 -pady 10
	pack $w.1

	# alternative "small" view 
	frame $w.2
	tixMeter $w.2.c -height 10 -width 100
	button $w.2.cancel -text "Cancel" -command {
		set waitforready 2 
		catch { close $pipe }
	}
	pack $w.2.c $w.2.cancel -side left
	
        tixButtonBox $w.1.box -orientation horizontal
        $w.1.box add cancel -text "Cancel" -command {
		set waitforready 2 
		catch { close $pipe }
	}
	pack $w.1.box -fill x -expand 1

	# create an optional text-widget to view any output generated by
	# subprocess
	frame $w.t	
	text $w.t.t -height 4 -width 36 -yscrollcommand "$w.t.scr set"
	scrollbar $w.t.scr -command "$w.t.t yview"
	pack $w.t.scr $w.t.t -side right -fill y
	pack $w.t

	# variables passed to the fileevent block
	set tmpw $w
	set acttrk 0
	set actfull 1
	update
	fileevent $pipe readable {
		global pipe tmpw waitforready out percent acttrk actfull
		global DEBUG
		set out [gets $pipe] 
		set doneevent 0

		# output debug-information
		if { $DEBUG > 0 } {
			puts "Debug:cdrecord: $out"
		}

		# no more data? process finished
		if { [eof $pipe] } { 
			# catch exit-status of cdrecord
			set cdrecord_ok [getchildstatus [ catch { close $pipe } ]]
			if { $DEBUG > 0 } {
				puts "Debug:cdrecord terminated - code: $cdrecord_ok"
			}

			if { $acttrk != -1 } {	
				# operation finished
				if { $cdrecord_ok == 0 } {
					set waitforready 1 
				} else {
					set waitforready 4
				}
			} else {
				# cdrecord does not support this device
				set waitforready 3 
			}	
			set doneevent 1
		}
		
		# does cdrecord support this device?
		if { [string first ": Sorry," $out] != -1 } {
			set idx [string first ":" $out]
			set idx2 [string last "on" $out]
			# extract error-message
			set text [string trim [string range $out [expr $idx+1] [expr $idx2-1]]]
			$tmpw.1.l2 configure -text "$text"
			# mark as cdrecord-abort
			set acttrk -1 
			# show we are done for this event
			set doneevent 1
		}
		if { [string first "Last chance to quit" $out] != -1 } {
			# skip that 9 second wait string
			set doneevent 1
		}

		# Starting a new track?
		if { [string first "written." $out] != -1 } {
			# we got a write-progress info
			set out [stripstring $out]
			set perinfo [split $out ":"]
			set perinfo2 [string trim [lindex $perinfo 1]]
			set perinfo3 [split $perinfo2 " "]
			set track [lindex [lindex $perinfo 0] 1]
			set done [lindex $perinfo3 0]
			set full [lindex $perinfo3 2]

			if { [lindex $perinfo3 1] != "of" } {
				# we got a line not showing 
				# how big the track is
				# assume full cd.. (for now)
				set full 650
			}
		
			set acttrk $track
			set actfull $full
			$tmpw.1.l2 configure -text "Track $track: $full MB"
			set doneevent 1
		 }

		# do we get a simple megabytes-written value? 
		# works only for cdrecord-1.6a9 and above
		if { [string range $out 0 4] == "Track" && \
		     [string first "fifo" $out] != -1 && $acttrk > 0 } {
			set perinfo [split $out ":"]
			set done1 [string trim [lindex $perinfo 1]]
			set done2 [split $done1 " "]
			set done [string trim [lindex $done2 0]]
			# get also the fifo value
			if { [string trim [lindex $done2 5]] == "(fifo" } {
				set fifo1 [string trim [lindex $done2 7]]
				set fifo2 [split $fifo1 "%"]
				set fifo [string trim [lindex $fifo2 0]]
			}
			# saveguard, should the expr command fail
			set percent 0
			catch { set percent [expr $done*100/$actfull] }
			drawbar $tmpw.1.c $percent
			drawbar $tmpw.2.c $percent
			set doneevent 1
		}

		# Fixation-output
		if { [string first "Fixating..." $out] != -1 } {
			$tmpw.1.l2 configure -text "Fixating..."
			set doneevent 1
		}

		# reload-message
		if { [string first "Re-load" $out] != -1 } {
			$tmpw.1.l2 configure -text "Waiting for medium..."
			Msg_ReloadDisk .rld .root 

			# simulate return press
			puts $pipe ""; flush $pipe 	
			set doneevent 1
		}

		# all special text is parsed - add the normal stuff
		# to text-window and scroll to its end
		if { $doneevent == 0 } {
			$tmpw.t.t insert end "$out\n"
			$tmpw.t.t see end
		}

	}	

	# redraw window with correct appearance
	changedowriteview $w $SUB_VIEW 

	tkwait variable waitforready

	#we are done with reading now...
	if { $waitforready == 1 } {
		$w.1.l configure -text "Write Image completed!"
		$w.1.l2 configure -text ""
		drawbar $tmpw.1.c 100
		drawbar $tmpw.2.c 100
		log $w "Write-Image: OK"
	} elseif { $waitforready == 3 } {
		$w.2.cancel config -bg red
		log $w "CD-Recorder not supported"	
	} elseif { $waitforready == 4 } {
		$w.1.l configure -text "Some error occured!!!"
		$w.1.l2 configure -text "Please check process-output"
		$w.2.cancel config -bg red
		log $w "Write-Image: Some error occured"
	} else {
		$w.1.l configure -text "Write Image aborted!"	
		$w.1.l2 configure -text ""
		$w.2.cancel config -bg red
		log $w "Write-Image: aborted"
	}

	$w.1.box.cancel configure -text "Ok" \
		-command "destroysubwindow $w .root {$oldf} 1" -width 5
	$w.2.cancel configure -text "Ok" \
		-command "destroysubwindow $w .root {$oldf} 1" -width 5
	sound 1

	# Clear the global variables
	unset pipe tmpw waitforready

	# wait until window is destroyed
        tkwait window $w
}


# save the text-outputbuffer of sub-process to disk
proc saveoutputbuffer { w wold t deffilename } {
global waitforok

	set waitforok 0 
	set oldf [createsubwindow $w $wold 2 ""]

	label $w.header -text "Save Process-Output" -relief sunken \
		-borderwidth 2 -anchor c -width 40
	pack $w.header -fill x -expand 1 -ipadx 10 -ipady 10 -pady 5

	tixFileSelectBox $w.dlg \
                -pattern {*.out} \
		-value $deffilename
        pack $w.dlg -fill x -expand 1

	tixButtonBox $w.box -orientation horizontal
        $w.box add ok -text "Save" -width 5 \
		-command "set waitforok 1"
        $w.box add cancel -text "Cancel" -width 5 \
		-command "set waitforok 0"
        pack $w.box -fill x -expand 1

	update
	tkwait variable waitforok 
	set filename [$w.dlg cget -value] 
	destroysubwindow $w $wold {$oldf} 2

	# cancel
	if { $waitforok == 0 } { return }

	# get the whole text in the text-area
	set outtext [$t get 0.0 end]

	# write to file
	set fileid [open $filename w]
	chownfile $filename

	puts $fileid $outtext
	close $fileid

	update
	Msg_BufferSaved .msgbuf $wold $filename
}


# changes the appearance of the write/read/verify-progress-window

proc changedowriteview { w type } {

	# normal
	if { $type == 0 } {
		pack forget $w.1
		pack forget $w.2
		pack forget $w.t 
		pack $w.1
	}
	# extended
	if { $type == 1 } {
		pack forget $w.1
		pack forget $w.2
		pack forget $w.t 
		pack $w.1
		pack $w.t
	}
	# small
	if { $type == 2 } {
		pack forget $w.1
		pack forget $w.2
		pack forget $w.t 
		pack $w.2
	}
}


# Read-Audio-Dialog

proc readaudiodialog { w } {
global XCDR_AUDIO_SOURCE_CDROM
global XCDR_AUDIOREAD_SPEED
global IMAGE_PART
global IMAGE_MNTPNT
global IMAGE_LABEL
global XCDR_DSP_DEV
global TMP_AUDIOPREFIX
global audiosel
global audiomerge
global audiostats
global audioglobaloffset
global audioskip2sec
global audio_units
global audio_old_units
global audionrtracks
global audiocdtoclist
global TMP_cd_title
global TMP_freespace

	# delete the old settings
	if { [info exists audiosel] == 1 } {
		unset audiosel
	}
	if { [info exists audiomerge] == 1 } {
		unset audiomerge
	}
	if { [info exists audiostats] == 1 } {
		unset audiostats
	}

	set blkname [ convCD2block audio ]

	# ask user to insert CD in drive
	if {[checkifready .root audio] == 1} {
		return
	}

	# Check if the CD is a non-iso-cd
	if {[checkifaudio $blkname] == 0} {
		if {[checkifiso $blkname] == 0} {
			Msg_NoNonIso .nniso .root 
			return
		}
	}

	
        # Draw header-bar
        label $w.l -text "READ TRACKS" -relief sunken -borderwidth 2 -anchor c
        pack $w.l -fill x -expand 1 -ipady 10 -pady 5

        # Create Devices-Setup
        tixLabelFrame $w.devs -label Devices-Setup 
        set w1 [$w.devs subwidget frame]
        pack $w.devs -expand 1 -fill x

        frame $w1.1
        tixLabelWidget $w1.1.readl -label "Read Tracks from : " \
                -options {label.width 25 label.anchor e}
        message $w1.1.readt -anchor w -width 300 -relief groove
        $w1.1.readt configure -text $XCDR_AUDIO_SOURCE_CDROM
        if { $XCDR_AUDIOREAD_SPEED == -1 } {
                label $w1.1.spd -text "Speed: Default"
        } else {
                label $w1.1.spd -text "Speed: $XCDR_AUDIOREAD_SPEED x"
        }

        tixForm $w1.1.readl -left %0
        tixForm $w1.1.readt -left %32 -right %80
        tixForm $w1.1.spd -left %82

        frame $w1.2
        tixLabelWidget $w1.2.imgl -label "Save Tracks on : " \
                -options {label.width 25 label.anchor e}
        message $w1.2.imgt -anchor w -width 300 -relief groove  
        label $w1.2.lbl -text "\[$IMAGE_LABEL\]"
        redraw_imagebox $w1.2.imgt

        tixForm $w1.2.imgl -left %0
        tixForm $w1.2.imgt -left %32 -right %80
        tixForm $w1.2.lbl -left %82 

        pack $w1.1 $w1.2 -side top -expand 1 -fill x

        #-------------------------------------------------

	set cdtoclist [getcdinfo $blkname]
	set audiocdtoclist $cdtoclist
	set totaltime [lindex $cdtoclist 2]
	set totalsize [expr [ converttime2frames $totaltime]*2352/1024/1024]
  	set nrtracks [lindex $cdtoclist 3]
	set audionrtracks $nrtracks
	set imgfreemb [ getfreeimgspace ]
	set imgfreetime [ convertMB2time $imgfreemb ]
	set TMP_freespace $imgfreemb

	frame $w.4 
	tixLabelWidget $w.4.nrtracks -label "Tracks total: " \
		-options { label.width 20 label.anchor e }
	label $w.4.nrtracksval -width 18 -relief sunken -borderwidth 1 \
		-text $nrtracks -anchor c \
		-font "-*-helvetica-medium-r-normal-*-14-*-*-*-*-*-*-*"

	tixLabelWidget $w.4.length -label "Total length: " \
		-options { label.width 16 label.anchor e }
	label $w.4.lengthval -width 18 -relief sunken -borderwidth 1 \
		-text "$totaltime ( $totalsize MB )" -anchor c \
		-font "-*-helvetica-medium-r-normal-*-14-*-*-*-*-*-*-*"

	pack $w.4 -fill x -expand 1 
	tixForm $w.4.nrtracks -left %0
	tixForm $w.4.nrtracksval -left %25 -right %50
	tixForm $w.4.length -left %50
	tixForm $w.4.lengthval -left %70 -right %95

	frame $w.1
	tixLabelWidget $w.1.imgcount -label "Tracks selected: " \
		-options { label.width 20 label.anchor e }
	label $w.1.imgcountval -width 18 -relief sunken -borderwidth 1 \
		-text "0" -anchor c \
		-font "-*-helvetica-medium-r-normal-*-14-*-*-*-*-*-*-*"
	tixLabelWidget $w.1.imgsize -label "Selected length: " \
		-options { label.width 16 label.anchor e }
	label $w.1.imgsizeval -width 18 -relief sunken -borderwidth 1 \
		-text " 0:00.00 ( 0 MB )" -anchor c \
		-font "-*-helvetica-medium-r-normal-*-14-*-*-*-*-*-*-*"

	pack $w.1 -fill x -expand 1 -pady 10
	tixForm $w.1.imgcount -left %0
	tixForm $w.1.imgcountval -left %25 -right %50
	tixForm $w.1.imgsize -left %50
	tixForm $w.1.imgsizeval -left %70 -right %95

	frame $w.15
	tixLabelWidget $w.15.imgfree -label "Free Space: " \
		-options { label.width 20 label.anchor e }
	label $w.15.imgfreeval -width 18 -relief sunken -borderwidth 1 \
		-text "$imgfreetime ( $imgfreemb MB )" -anchor c \
		-font "-*-helvetica-medium-r-normal-*-14-*-*-*-*-*-*-*"

	pack $w.15 -fill x -expand 1 
	tixForm $w.15.imgfree -left %0
	tixForm $w.15.imgfreeval -left %25 -right %50

	#----------------------------------------------

        canvas $w.20 -height 0 -width 30 -relief sunken -borderwidth 1
        pack $w.20 -pady 10 -fill x -expand 1

	frame $w.3
	if { [info exists TMP_cd_title] == 0 } {
		set TMP_cd_title ""
	}
	tixLabelEntry $w.3.cdtitle -disabledforeground gray \
		-label "CD-Title (optional): " \
		-options {
			label.width 25 label.anchor e
			entry.width 20 entry.textVariable TMP_cd_title 
		}
	pack $w.3 -fill x -expand 1 -padx 10 
	pack $w.3.cdtitle -side left -fill x -expand 1

	frame $w.2
	tixLabelEntry $w.2.imgfname -disabledforeground gray \
		-label "Filename-prefix: " \
		-options {
			label.width 25 label.anchor e
			entry.width 18 entry.textVariable TMP_AUDIOPREFIX 
		}
	pack $w.2 -fill x -expand 1 -padx 10 
	pack $w.2.imgfname -side left 

	# set default-image-name
	if { $TMP_AUDIOPREFIX == "" } {
		set TMP_AUDIOPREFIX "audio"
	}

	#----------------------------------------------

        canvas $w.30 -height 0 -width 30 -relief sunken -borderwidth 1
        pack $w.30 -pady 10 -fill x -expand 1


        button $w.start -text "Start Read Tracks" \
                -command "readaudiodoit .readaudiodoit $w; audio_updatefreesize $w"
        button $w.start2 -text "Select/Show Tracks to Read" \
                -command "readtrackssub .readtracksub $w"
        pack $w.start2 $w.start -pady 30 -side left -expand 1

	# refresh track-count and size
	#refresh_imgcountandsize $w $audionrtracks {$audiocdtoclist} audiosel audiomerge"

 	if { [readaudiocheckpart $w ] == 1 } {
		# The user doesn't wanted to format the partition,
		# quit the whole menu in this case
		destroy $w
		update
		return
	}
}


# show the user the tracks to read.

proc readtrackssub { w wroot } {
global XCDR_AUDIO_SOURCE_CDROM
global XCDR_AUDIOREAD_SPEED
global IMAGE_PART
global IMAGE_MNTPNT
global IMAGE_LABEL
global XCDR_DSP_DEV
global XCDR_SKIP2SEC
global XCDR_GLOBAL_OFFSETS
global XCDR_AUDIO_UNITS
global XCDR_ECHOLISTEN
global TMP_AUDIOPREFIX
global audiostats
global audiosel
global audiomerge
global audioglobaloffset
global audioskip2sec
global audio_units
global audio_old_units
global audioecholisten
global audionrtracks
global audiocdtoclist
global TMP_cd_title
global TMP_freespace

	# create new window
	set oldf [createsubwindow $w .root 2 ""]

	# Defined here to have access to variable "f"   
	tixScrolledWindow $w.5 -height 300 -scrollbar auto
	set f [$w.5 subwidget window]

	# preselect var
	if { [info exists audioskip2sec] == 0 } {
		set audioskip2sec $XCDR_SKIP2SEC 
	}
	if { [info exists audioglobaloffset] == 0 } {
		set audioglobaloffset $XCDR_GLOBAL_OFFSETS
	}
	if { [info exists audioecholisten] == 0 } {
		set audioecholisten $XCDR_ECHOLISTEN
	}
	if { [info exists audio_units] == 0 } {
		set audio_units $XCDR_AUDIO_UNITS 
		set audio_old_units $XCDR_AUDIO_UNITS 
	}

	frame $w.menu -bd 1 -relief raised
	menubutton $w.menu.opt -menu $w.menu.opt.m -text "Options" 
	menu $w.menu.opt.m
	$w.menu.opt.m add check -label "Global Offsets" \
		-variable audioglobaloffset
	$w.menu.opt.m add check -label "Skip last 2 sec. of track" \
		-variable audioskip2sec
	$w.menu.opt.m add check -label "Listen to audio while recording" \
		-variable audioecholisten
	$w.menu.opt.m add sep
	$w.menu.opt.m add cascade -label "Time-Offset Unit" \
		-menu $w.menu.opt.m.radio
	set m $w.menu.opt.m.radio
	menu $m
	$m add radio -label "Seconds" -variable audio_units -value "sec" \
		-command "check_units $f $audionrtracks" 
	$m add radio -label "Frames (1/75 sec)" -variable audio_units -value "frame" \
                -command "check_units $f $audionrtracks"


	pack $w.menu.opt -side left
	pack $w.menu -fill x -expand 1


        # Draw header-bar
        label $w.l -text "SELECT TRACKS TO READ" -relief sunken \
		-borderwidth 2 -anchor c
        pack $w.l -fill x -expand 1 -ipady 10 -pady 5

	pack $w.5 -expand 1 -fill x -padx 10 -pady 10

	label $f.label -font "-misc-fixed-medium-r-normal-*-*-120-*-*-*-*-*-*" \
	-text "\
\ \ Track-   Track-title (optional)   Pre- Copy-  Start-    Track-     End-\n\
\ \ \ \ Nr.                             emph. perm.  offset    length    offset"

	pack $f.label -fill x 

	for { set i 1 } { $i <= $audionrtracks } {incr i } {
		set trktype [lindex $audiocdtoclist [expr 5*$i+2]]
		set trksize [lindex $audiocdtoclist [expr 5*$i+3]]
		if { $trktype == "Data" } {
			set trksize "$trksize MB"
		}
		# set buttons to default
		if { [info exists audiosel($i)] == 0 } {
			set audiosel($i) 0
		}
		if { [info exists audiomerge($i)] == 0 } {
			set audiomerge($i) 0
		} 
		frame $f.$i
		checkbutton $f.$i.sel -variable audiosel($i) \
			-command "check_merge $wroot $f $i $audionrtracks {$audiocdtoclist} audiosel audiomerge"

		label $f.$i.flg -image BAREMPTY -text $trktype
		set audiostats($i,type) $trktype

		label $f.$i.nrtr -text $i -width 3 -anchor c
		if { $trktype == "Data" && $i == 1 } {
			entry $f.$i.name -width 25 -textvariable audiostats($i,name)
			set cddatalabel [getisolabel [convCD2block audio ] ]
			$f.$i.name del 0 end
			$f.$i.name insert 0 "DATA: $cddatalabel"
			$f.$i.name configure -state disabled
		} elseif { $trktype == "Data" && $i != 1 } {
			entry $f.$i.name -width 25 -textvariable audiostats($i,name)
			$f.$i.name del 0 end
			$f.$i.name insert 0 "DATA: CD-Extra (unreadable)"
			$f.$i.name configure -state disabled
			$f.$i.sel config -state disabled
		} else {
			entry $f.$i.name -width 25 -textvariable audiostats($i,name)
		}
		set tmpval [lindex $audiocdtoclist [expr 5*$i+0]]
		if { $tmpval == "1" } {
			set tmpbit YESOPTICO 
		} else {
			set tmpbit NOOPTICO 
		}
		label $f.$i.preemp -image $tmpbit
		set audiostats($i,preemp) $tmpval

		set tmpval [lindex $audiocdtoclist [expr 5*$i+1]]
		if { $tmpval == "1" } {
			set tmpbit YESOPTICO 
		} else {
			set tmpbit NOOPTICO 
		}
		label $f.$i.cpperm -image $tmpbit 
		set audiostats($i,cpperm) $tmpval

		label $f.$i.tmp1 -width 1 
		label $f.$i.tmp3 -width 1 
		label $f.$i.tmp4 -width 1 

		tixControl $f.$i.off1 -integer true \
			-variable audiostats($i,off1) -min -9999 -max 9999 \
			-options { entry.width 4 } \
			-command "check_off1 $f $audionrtracks" 

		message $f.$i.time -text $trksize -width 100 -anchor c \
			-relief sunken -borderwidth 1

		tixControl $f.$i.off2 -integer true \
			-variable audiostats($i,off2) -min -9999 -max 9999 \
			-options { entry.width 4 } \
			-command "check_off2 $f $audionrtracks" 

		label $f.$i.tmp2 -width 3 
		button $f.$i.play -image PLAYICO \
			-command "preplay_track $f $i" 
		if { $trktype == "Data" || $XCDR_DSP_DEV == "None" } {
			$f.$i.play configure -state disabled	
		}

		pack $f.$i.sel $f.$i.flg $f.$i.nrtr $f.$i.name $f.$i.tmp1 \
			$f.$i.preemp $f.$i.tmp3 $f.$i.cpperm $f.$i.tmp4 \
			$f.$i.off1 -side left 
		pack $f.$i.time -side left -expand 1 -fill x
		pack $f.$i.off2 $f.$i.tmp2 $f.$i.play -side left 
		pack $f.$i -fill x 
	}
	
	# redraw the merge-arcs
	refresh_merge_tracks  $f $audionrtracks audiosel audiomerge 


	tixButtonBox $w.ctrl -orientation horizontal -relief flat
	$w.ctrl add sel_all -text "Select All" -command "sel_all_tracks $wroot $f $audionrtracks {$audiocdtoclist}"
	$w.ctrl add sel_none -text "Select None" -command "sel_no_tracks $wroot $f $audionrtracks audiomerge"
	$w.ctrl add merge -text "Merge Selected Tracks" -command "merge_tracks $f $audionrtracks audiosel audiomerge"
	$w.ctrl add unmerge -text "Un-Merge All Tracks" -command "unmerge_tracks $f $audionrtracks audiomerge"
	pack $w.ctrl -fill x -expand 1

        button $w.cancel -text "Done" \
                -command "destroysubwindow $w .root {$oldf} 2"
        pack $w.cancel -pady 5 -side left -expand 1

}


# Action when button "Select All Tracks" is pressed 

proc sel_all_tracks { w f nrtracks cdtoclist } {

	set tracksum 0
	set trackcount 0
	for { set i 1 } { $i <= $nrtracks } {incr i } {
		# skip disabled buttons (cd-extra)
		if { [$f.$i.sel cget -state] == "disabled" } {
			continue
		}
		$f.$i.sel select
#		set trksize [lindex $cdtoclist [expr 5*$i+3]]
#		set trkframes [converttime2frames $trksize]
		set trkframes [lindex $cdtoclist [expr 5*$i+4]]
		incr tracksum $trkframes
		incr trackcount 
	}
	set time [convertframes2time $tracksum]
 	set mb [expr ($tracksum*2352/1024/1024)]
	$w.1.imgsizeval configure -text "$time ( $mb MB )" 
	$w.1.imgcountval configure -text "$trackcount" 
}


# Action when button "Select None" is pressed

proc sel_no_tracks { w f nrtracks merge } {

upvar $merge audiomerge

	for { set i 1 } { $i <= $nrtracks } {incr i } {
		$f.$i.sel deselect
        	set audiomerge($i) 0
		$f.$i.flg configure -image BAREMPTY
	}
	$w.1.imgsizeval configure -text " 0:00.00 ( 0 MB )" 
	$w.1.imgcountval configure -text "0" 
}


# Action when button "Merge Selected Tracks" is pressed 

proc merge_tracks { f nrtracks sel merge } {

upvar $sel audiosel 
upvar $merge audiomerge

	set cont 0 	;# position in current track-range 
	set range 0	;# number of range

	for { set i 1 } { $i <= $nrtracks } {incr i } {

		set trktype [$f.$i.flg cget -text]

		# Ignore existing ranges and data-tracks
		if { $audiomerge($i) != 0 || $trktype == "Data" } {
			set cont 0
			continue
		}

		# Is the track and the track before selected?
		if { $audiosel($i) == 1 && $cont != 0 } {

			# First position in range?
			if { $cont == 1 } {
				$f.[expr $i-1].flg configure -image BARTOP
			} else {
				$f.[expr $i-1].flg configure -image BARMID
			}
			$f.$i.flg configure -image BARDOWN

			set audiomerge([expr $i-1]) $range 
			set audiomerge($i) $range 
		 	incr cont	
		}

		# Is the track selected and the track before is not selected?
		if { $audiosel($i) == 1 && $cont == 0 } {
			# Start new track-range
			set cont 1 
			set range [request_range_nr $nrtracks audiomerge]
		}

		# Track not selected? Set cont-flag to zero   
		if { $audiosel($i) == 0 } {
			# Stop any track-range
			set cont 0

			# Init the mergevalue
			set audiomerge($i) 0
			$f.$i.flg configure -image BAREMPTY
		}
	}
}


# redraws the merge-stuff 

proc refresh_merge_tracks { f nrtracks sel merge } {

upvar $sel audiosel 
upvar $merge audiomerge

	set cont 0 	;# position in current track-range 

	for { set i 1 } { $i <= $nrtracks } {incr i } {

		set trktype [$f.$i.flg cget -text]

		# Is the track and the track before selected?
		if { $audiomerge($i) != 0 && $cont != 0 } {

			# First position in range?
			if { $cont == 1 } {
				$f.[expr $i-1].flg configure -image BARTOP
			} else {
				$f.[expr $i-1].flg configure -image BARMID
			}
			$f.$i.flg configure -image BARDOWN

		 	incr cont	
		}

		# Is the track selected and the track before is not selected?
		if { $audiomerge($i) != 0 && $cont == 0 } {
			# Start new track-range
			set cont 1 
		}

		# Track not selected? Set cont-flag to zero   
		if { $audiomerge($i) == 0 } {
			# Stop any track-range
			set cont 0

			# Init the mergevalue
			$f.$i.flg configure -image BAREMPTY
		}
	}
}


# Returns the next available range-number in audio-merge array 

proc request_range_nr { nrtracks merge } {
upvar $merge audiomerge

	set highest 0
	for { set i 1 } { $i <= $nrtracks } {incr i } {
		if { $audiomerge($i) > $highest } {
			set highest $audiomerge($i)
		}
	}
	return [expr $highest+1]
}


# Action when button "Un-Merge All Tracks" is pressed 

proc unmerge_tracks { f nrtracks merge } {

upvar $merge audiomerge

	for { set i 1 } { $i <= $nrtracks } {incr i } {
        	set audiomerge($i) 0
		$f.$i.flg configure -image BAREMPTY
	}
}


# Called when a checkbutton is pressed. 
# Checks if the button belongs to a selected range and does 
# delete the whole range.
# Also updates the selected-track-size display

proc check_merge { w f nr nrtracks cdtoclist sel merge } {

upvar $sel audiosel 
upvar $merge audiomerge

	# We deselected a button belonging to a track-range?
	if { $audiosel($nr) == 0 && $audiomerge($nr) != 0 } {
		set range $audiomerge($nr)
		for { set i 1 } { $i <= $nrtracks } {incr i } {
			if { $audiomerge($i) == $range } {
				set audiomerge($i) 0
				$f.$i.flg configure -image BAREMPTY
			}
		}	
	}

	# Calculate how big all selected tracks are until now 
	set tracksum 0
	set trackcount 0
	for { set i 1 } { $i <= $nrtracks } {incr i } {
		if { $audiosel($i) != 0 } {
#			set trksize [lindex $cdtoclist [expr 5*$i+3]]
#			set trkframes [converttime2frames $trksize]
			set trkframes [lindex $cdtoclist [expr 5*$i+4]]
			incr tracksum $trkframes
			incr trackcount
		}
	}
	set time [convertframes2time $tracksum]
 	set mb [expr ($tracksum*2352/1024/1024)]
	$w.1.imgsizeval configure -text "$time ( $mb MB )" 
	$w.1.imgcountval configure -text "$trackcount" 
}


# redraw the track-count and track-size view in read-tracks-dialog

proc refresh_imgcountandsize { w nrtracks cdtoclist sel merge } {

upvar $sel audiosel 
upvar $merge audiomerge

	# nothing selected yet? return
	if { [info exists audiosel] == 0 } {
		return
	}

	# Calculate how big all selected tracks are until now 
	set tracksum 0
	set trackcount 0
	for { set i 1 } { $i <= $nrtracks } {incr i } {
		if { $audiosel($i) != 0 } {
#			set trksize [lindex $cdtoclist [expr 5*$i+3]]
#			set trkframes [converttime2frames $trksize]
			set trkframes [lindex $cdtoclist [expr 5*$i+4]]
			incr tracksum $trkframes
			incr trackcount
		}
	}
	set time [convertframes2time $tracksum]
 	set mb [expr ($tracksum*2352/1024/1024)]
	$w.1.imgsizeval configure -text "$time ( $mb MB )" 
	$w.1.imgcountval configure -text "$trackcount" 
}


# Called when user toggles the "global offset"-checkbutton.
# Assures that all entry-fields have the same value if switched on

proc check_globaloffset { f nrtracks } {
global audioglobaloffset

	if { $audioglobaloffset == 1 } {
		set value1 [$f.1.off1 cget -value]
		set value2 [$f.1.off2 cget -value]

		for { set i 1 } { $i <= $nrtracks } {incr i } {
			$f.$i.off1 configure -disablecallback 1
			$f.$i.off1 configure -value $value1
			$f.$i.off1 configure -disablecallback 0
			$f.$i.off2 configure -disablecallback 1
			$f.$i.off2 configure -value $value2
			$f.$i.off2 configure -disablecallback 0
		}
	}
}


# Called when a offset1 entry-field is modified.
# Used to sync all fields if global-offsets is on

proc check_off1 { f nrtracks value } {
global audioglobaloffset

	if { $audioglobaloffset == 1 } {
		for { set i 1 } { $i <= $nrtracks } {incr i } {
			$f.$i.off1 configure -disablecallback 1
			$f.$i.off1 configure -value $value
			$f.$i.off1 configure -disablecallback 0
		}
	}
}


# Called when a offset2 entry-field is modified.
# Used to sync all fields if global-offsets is on

proc check_off2 { f nrtracks value } {
global audioglobaloffset

	if { $audioglobaloffset == 1 } {
		for { set i 1 } { $i <= $nrtracks } {incr i } {
			$f.$i.off2 configure -disablecallback 1
			$f.$i.off2 configure -value $value
			$f.$i.off2 configure -disablecallback 0
		}
	}
} 


# Called when the user changes the type of offset-unit.
# Checks if value really changes and adjusts all values 
# in the entry fields.

proc check_units { f nrtracks } {
global audio_units
global audio_old_units

	# Changed the button-value really?
	if { $audio_units != $audio_old_units } {
		if { $audio_units == "frame" } {
			set audio_old_units "frame"
			for { set i 1 } { $i <= $nrtracks } {incr i } {
				set value1 [$f.$i.off1 cget -value]
				$f.$i.off1 configure -disablecallback 1
				$f.$i.off1 configure -value [expr $value1*75]
				$f.$i.off1 configure -disablecallback 0
	
				set value2 [$f.$i.off2 cget -value]
				$f.$i.off2 configure -disablecallback 1
				$f.$i.off2 configure -value [expr $value2*75]
				$f.$i.off2 configure -disablecallback 0
			}
		} else {
			set audio_old_units "sec"
			for { set i 1 } { $i <= $nrtracks } {incr i } {
				set value1 [$f.$i.off1 cget -value]
				$f.$i.off1 configure -disablecallback 1
				$f.$i.off1 configure -value [expr $value1/75]
				$f.$i.off1 configure -disablecallback 0

				set value2 [$f.$i.off2 cget -value]
				$f.$i.off2 configure -disablecallback 1
				$f.$i.off2 configure -value [expr $value2/75]
				$f.$i.off2 configure -disablecallback 0
			}
		}	
	}
}


# Called when play-button is pressed

proc preplay_track { f nr } {
global audio_units
global audioskip2sec
global preplay_track
global preplay_off1
global preplay_off2

	set preplay_track $nr
	set preplay_off1 [$f.$nr.off1 cget -value]
	set preplay_off2 [$f.$nr.off2 cget -value]

	# We need unit "frames" at this point
	if { $audio_units == "sec" } {
		set preplay_off1 [expr $preplay_off1*75]
		set preplay_off2 [expr $preplay_off2*75]
	}

	# If skip-2-sec button is pressed, substract 150 frames (2 sec)
	# from offset2
	if { $audioskip2sec == 1 } {
		incr preplay_off2 -150
	}

	# Change color of playbutton  
	$f.$nr.play configure -bg red -relief sunken

	# play it
	preplay_doit .preplayaudio .readtracksub

	$f.$nr.play configure -bg lightgray -relief raised 
}


# Called after read-audio-tracks-dialog is build up.
# Checks if the image-partition is formatted.
# Returns 1 if the user canceled, used to cancel the whole menu

proc readaudiocheckpart { w } {
global IMAGE_PART
global IMAGE_MNTPNT

	# Is the image-partition mounted? If not mount it...
	if { [getmountpnt $IMAGE_PART] == "" && $IMAGE_PART != "" } {

		set mstat [domountext2 $IMAGE_PART $IMAGE_MNTPNT]
		if { $mstat == 0 } { ; # mount failed
			set fstat [Msg_AudioMustFormatImage .audioformat .root]
			if { $fstat == 0 } { ;# Format
				set fout [makeformat $IMAGE_PART .root]
				if { $fout == 0 } {
					Msg_FormatFailed .frmtfail .root $IMAGE_PART
					exit
				} else {
					# Silently try to mount again
					set rstat [readaudiocheckpart $w]
					if { $rstat == 1 } {
						# if remount failed, return 1
						return 1
					}
				}
			} else { ;# Cancel, not format
				return 1
			}
		} elseif { $mstat == 2 } { ; # mountpoint busy
			Msg_MountdirBusy .mntbusy .root $IMAGE_MNTPNT
			return 1
		} else {
			Msg_Mounted .dmnt .root $IMAGE_PART $IMAGE_MNTPNT
		}
	}	

	# update free-size-display
	audio_updatefreesize $w
	return 0
}


# Update the free-size-display in the read-audio-tracks-dialog

proc audio_updatefreesize { w } {
global TMP_freespace

	set imgfreemb [ getfreeimgspace ]
	set imgfreetime [ convertMB2time $imgfreemb ]

	$w.15.imgfreeval configure -text "$imgfreetime ( $imgfreemb MB )" 
	set TMP_freespace $imgfreemb
}


# Do the reading of the audio-tracks, called by the Start-button
# in the Read-Audio-Tracks-Dialog

proc readaudiodoit { w wold } {
global READCDDA 
global MYDD
global XCDR_AUDIO_SOURCE_CDROM
global XCDR_AUDIOREAD_SPEED
global XCDR_AUDIOREAD_MODE
global XCDR_SUB_VIEW SUB_VIEW
global XCDR_DSP_DEV
global IMAGE_MNTPNT
global audiostats
global audio_units
global audioskip2sec
global audioecholisten
global audiosel
global audiomerge
global audionrtracks
global TMP_AUDIOPREFIX
global TMP_DESTNAME
global TMP_cd_title
global TMP_freespace
global ENDIANSWAP
global DATE

# This variables must be global, because the fileevent-command
# can't handle local-variables
global pipe tmpw waitforready outval barmult barsum

        # set default view
        if { $SUB_VIEW == "" } {
                set SUB_VIEW $XCDR_SUB_VIEW
        }

	# any tracks selected? (check 1)
	if { [$wold.1.imgcountval cget -text ] == "0" } {
		Msg_NoTracksSel .notrk .root 
		return
	}

        # Calculate how big all selected tracks are until now 
	set cdtoclist [getcdinfo [convCD2block audio]]
        set tracksum 0
        for { set i 1 } { $i <= $audionrtracks } {incr i } {
                if { $audiosel($i) != 0 } {
#                        set trksize [lindex $cdtoclist [expr 5*$i+3]]
#                        set trkframes [converttime2frames $trksize]
                        set trkframes [lindex $cdtoclist [expr 5*$i+4]]
			
			# readerror on CD results into an empty field
			if { $trkframes == "" } {
				Msg_ReadErrorOnCD .notrk .root 
				return
			}

                        incr tracksum $trkframes
                }
        }

	# Any tracks selected? (check 2)
	if { $tracksum == 0 } {
		Msg_NoTracksSel .notrk .root 
		return
	}

        set spaceneeded [expr ($tracksum*2352/1024/1024)]

	# check again if enough space
	set imgfreemb [ getfreeimgspace ]
	set TMP_freespace $imgfreemb

	# Check if enough space
        if { $spaceneeded > $TMP_freespace } {
                set stat [Msg_NotEnoughSpace .nospace .root]
                if { $stat == 0 } {     ;# Cancel
                        return
                }
        }

	# Set endian-order
        if { $ENDIANSWAP == 1 } {
                set swapstr "-x"
		set bigendian 0
        } else {
                set swapstr ""
		set bigendian 1
        } 

	# Sets the track-filename-prefix 
	set trkfile [ file tail $TMP_AUDIOPREFIX]
	set audiodest "$IMAGE_MNTPNT/$trkfile"
	set cd_title $TMP_cd_title

	set blkname [ convertCDnametoblkdevice $XCDR_AUDIO_SOURCE_CDROM ]
	set genname [ convertCDnametogendevice $XCDR_AUDIO_SOURCE_CDROM ]

	# Here we convert the two arrays audiosel and audiomerge to a
	# single list containing the start and end track to record
	set trklist ""
        for { set i 1 } { $i <= $audionrtracks } {incr i } {
	
		if { $audiosel($i) != 0 && $audiomerge($i) == 0 } { 
			# Single Track 
			lappend trklist $i $i 
		}
		if { $audiosel($i) == 1 && $audiomerge($i) != 0 } {
			# Start of merged-tracks
			lappend trklist $i
			set comp $audiomerge($i)
			# Find end of merged-tracks
			for { set j $i } { $j <= $audionrtracks } {incr j} {
				if { $audiomerge($j) == $comp } {
					set end $j
				}
			}
			lappend trklist $end
			set i $end
		}
	}

	# create new window
	set oldf [createsubwindow $w .root 1 "Read Tracks"]

        # create menu
        frame $w.menu -bd 1 -relief raised
        menubutton $w.menu.file -menu $w.menu.file.m -text "File" \
                -font "-*-helvetica-medium-r-normal-*-10-*-*-*-*-*-*-*"
        menu $w.menu.file.m
        $w.menu.file.m add command -label "Save Process-Output" \
                -font "-*-helvetica-medium-r-normal-*-10-*-*-*-*-*-*-*" \
                -command "saveoutputbuffer .savebuf $w $w.t.t readtrk.out" 
        menubutton $w.menu.view -menu $w.menu.view.m -text "View" \
                -font "-*-helvetica-medium-r-normal-*-10-*-*-*-*-*-*-*"
        menu $w.menu.view.m
        $w.menu.view.m add radio -label "Normal" -value 0 -variable SUB_VIEW \
                -font "-*-helvetica-medium-r-normal-*-10-*-*-*-*-*-*-*" \
                -command "changedowriteview $w 0"
        $w.menu.view.m add radio -label "Extended" -value 1 -variable SUB_VIEW \
                 -font "-*-helvetica-medium-r-normal-*-10-*-*-*-*-*-*-*" \
                -command "changedowriteview $w 1"
        $w.menu.view.m add radio -label "Small" -value 2 -variable SUB_VIEW \
                -font "-*-helvetica-medium-r-normal-*-10-*-*-*-*-*-*-*" \
                -command "changedowriteview $w 2" 
        pack $w.menu.file -side left
        pack $w.menu.view -side left
        pack $w.menu -fill x -expand 1


	frame $w.1
	label $w.1.l -text "Reading Track 0/0... Please wait"
	tixMeter $w.1.c -height 20 -width 300
	pack $w.1.l $w.1.c -padx 10 -pady 10
	pack $w.1

        # alternative "small" view 
        frame $w.2
        tixMeter $w.2.c -height 10 -width 100
        button $w.2.cancel -text "Cancel" 
        pack $w.2.c $w.2.cancel -side left


        tixButtonBox $w.1.box -orientation horizontal
        $w.1.box add cancel -text "Cancel" 
	pack $w.1.box -fill x -expand 1

        # create an optional text-widget to view any output generated by
        # subprocess
        frame $w.t      
        text $w.t.t -height 4 -width 36 -yscrollcommand "$w.t.scr set"
        scrollbar $w.t.scr -command "$w.t.t yview"
        pack $w.t.scr $w.t.t -side right -fill y
        pack $w.t


	# Nr of tracks to read (merged tracks count as 1)
	set nrtracks [expr [llength $trklist]/2]

	if { $nrtracks == 0 } {
		destroysubwindow $w .root {$oldf} 1
		return
	}

	# init readmode
	set readmode ""

	if { $XCDR_AUDIOREAD_MODE != "Autodetect" } {
		if { $XCDR_AUDIOREAD_MODE == "Philips" } {
			set readmode "-m PHILIPS "
		}
		if { $XCDR_AUDIOREAD_MODE == "New Philips" } {
			set readmode "-m NEW_PHIL "
		}
		if { $XCDR_AUDIOREAD_MODE == "Yamaha" } {
			set readmode "-m YAMAHA "
		}
		if { $XCDR_AUDIOREAD_MODE == "Toshiba" } {
			set readmode "-m TOSHIBA "
		}
		if { $XCDR_AUDIOREAD_MODE == "Sony" } {
			set readmode "-m SONY "
		}
		if { $XCDR_AUDIOREAD_MODE == "Ricoh" } {
			set readmode "-m RICOH "
		}
		if { $XCDR_AUDIOREAD_MODE == "Teac" } {
			set readmode "-m TEAC "
		}
		if { $XCDR_AUDIOREAD_MODE == "SCSI-3/mmc" } {
			set readmode "-m MMC "
		}
	}

	# init speed and echolisten
	set echospeed "-S $XCDR_AUDIOREAD_SPEED"
	if { $audioecholisten == 1 && $XCDR_DSP_DEV != "None" } {
		set echospeed "-S 1 -e $XCDR_DSP_DEV"
	}

        for { set i 1 } { $i <= $nrtracks } {incr i } {

		# Find out all track parameters
		set start [ lindex $trklist [expr ($i-1)*2]]
		set end [ lindex $trklist [expr ($i-1)*2+1]]
		set tsize [calcfulltracksize $start $end] 
		set off1 $audiostats($start,off1)
		set off2 $audiostats($end,off2) 
		set name $audiostats($start,name)
		set cpperm $audiostats($start,cpperm)
		set preemp $audiostats($start,preemp)
		set type $audiostats($start,type) 

                set newnr [find_nextaudionr $audiodest] 
		# create 01, 02....10, 11
		if { [string length $newnr] == 1 } {
			set newnr "0$newnr"
		}
		set us "_"
		set filename "$audiodest$us$newnr.cdr"
		set dataname "$audiodest$us$newnr.raw"
		set infoname "$audiodest$us$newnr.inf"

		# We need unit "frames" at this point
	        if { $audio_units == "sec" } {
	                set off1 [expr $off1*75]
	                set off2 [expr $off2*75]
	        }

		set oldoff2 $off2

	        # If skip-2-sec button is pressed, substract 150 frames (2 sec)
	        # from offset2
	        if { $audioskip2sec == 1 } {
	                incr off2 -150
	        }

		# how long is the track with offsets and merging?
		set tsize [expr $tsize + $off2 - $off1]
		set tsizetime [convertframes2time $tsize]
		set tsizebytes [expr $tsize * 2352]
		set date [exec $DATE "+%b %d %T"]

		# Write info-file
		set fileid [open $infoname w]
		chownfile $infoname

		puts $fileid "# Audio-Track-Description-File"
		puts $fileid "# Created: $date"
		puts $fileid "CD-Name     : $cd_title"
		puts $fileid "Track-Name  : $name"
		puts $fileid "Track-Nr.   : $start - $end"
		puts $fileid "Track-Size  : $tsizetime ($tsizebytes bytes)"

		if { $type != "Data" } {
			puts $fileid "Offsets     : $off1,$oldoff2"
			puts $fileid "Preemphasis : $preemp"
			puts $fileid "Copy-Perm.  : $cpperm"
			puts $fileid "Skip 2 Sec. : $audioskip2sec"
			puts $fileid "Big-Endian  : $bigendian"
		}
		close $fileid 

	
		set waitforready 0

		# Set the right command for Data or Audio-Mode
		if { $type == "Data" } {
   			set nrblocks [expr [ getisosize $blkname ]/2048]
			set cmd "$MYDD $blkname $dataname $nrblocks"

			log .root "Read-Track: Data-Track $dataname, $nrblocks blocks"

			# set TMP_DESTNAME to the actual filename, this
			# is used in the verify-data-track to display
			# a most reasonable default-name
			set TMP_DESTNAME [file tail $dataname] 
		} else {
 			set cmd "$READCDDA -D $genname -B $blkname -t $start -z $end -o $off1 -s $off2 -p $readmode $echospeed $swapstr $filename"
			log .root "Read-Track: Audio-Track $filename, tracks $start-$end"
		}
		log .root "Executing: $cmd"

		# create extended command-line
		set cmd [execshell $cmd]

		set pipe [open "|$cmd" r+]
	
		$w.1.l configure -text "Reading Track $i/$nrtracks... Please wait" 
		# prepare progressbar calculations
		set barmult [expr 1.0/$nrtracks]
		set barsum [expr ($i - 1) * (100.0/$nrtracks)]

		$w.1.box.cancel configure -command { 
			set waitforready 2 
			catch { close $pipe }
		}
		$w.2.cancel configure -command { 
			set waitforready 2 
			catch { close $pipe }
		}


		set tmpw $w
		fileevent $pipe readable {
			global pipe tmpw waitforready outval barmult barsum
			set outval [gets $pipe] 

			if { [eof $pipe] } { 
				set waitforready 1; catch { close $pipe }
			}

			if { [string index $outval 0] != "P" } {
                		# add to text-window and scroll to its end
                		$tmpw.t.t insert end "$outval\n"
                		$tmpw.t.t see end
			}

 			if { [string index $outval 0] == "R" || 
 			     [string index $outval 0] == "E" } {
                 	        set outval ""
                	        set waitforready 3; catch { close $pipe }
                	}
                	if { [string index $outval 0] == "W" } {
                	        set outval ""
                	        set waitforready 4; catch { close $pipe }
                	}
                	if { [string range $outval 0 1] == "_U" } {
                	        set outval ""
                	        set waitforready 5; catch { close $pipe }
                	}
			if { $outval == "Done" } { 
				set outval 100
				set waitforready 1; catch { close $pipe }
			}
			if { [string index $outval 0] == "P" } {
				set pct [string range $outval 1 end]
				drawbar $tmpw.1.c [expr ($pct * $barmult) + $barsum]
				drawbar $tmpw.2.c [expr ($pct * $barmult) + $barsum]
			}
		}	

		# redraw window with correct appearance
        	changedowriteview $w $SUB_VIEW 

		tkwait variable waitforready
	
		#we are done with reading now...
		if { $waitforready == 1 } {
			if { $outval == 100 } {	
				$w.1.l configure -text "Track successfully read."
				# last track read?
				if { $i == $nrtracks } {
					drawbar $tmpw.1.c 100 
					drawbar $tmpw.2.c 100 
				}
				log .root "Read-Track: Track OK"
          		} else {
                        	$w.1.l configure -text "Some error occured!!!"
				$w.2.cancel config -bg red
				log .root "Read-Track: Some error occured"
				break
                	}
        	} elseif { $waitforready == 2 } {
			$w.1.l configure -text "Read Track aborted!"	
			$w.2.cancel config -bg red
			log .root "Read-Track: aborted"
			break
        	} elseif { $waitforready == 3 } {
        	        $w.1.l configure -text "Read-Error!!"     
			$w.2.cancel config -bg red
			log .root "Read-Track: read-error"
			break
        	} elseif { $waitforready == 4 } {
        	        $w.1.l configure -text "Write-Error!!"    
			$w.2.cancel config -bg red
			log .root "Read-Track: write-error"
			break
        	} elseif { $waitforready == 5 } {
        	        $w.1.l configure -text "Unsupported CD-ROM!"    
			$w.2.cancel config -bg red
			log .root "Read-Track: unsupported CD-ROM found"
			break
        	}
		chownfile $filename
		chownfile $dataname
	}

	$w.1.box.cancel configure -text "Ok" \
		-command "destroysubwindow $w .root {$oldf} 1" -width 5
        $w.2.cancel configure -text "Ok" \
                -command "destroysubwindow $w .root {$oldf} 1" -width 5
	sound 1
	chownfile $filename
	chownfile $dataname

	# Clear the global variables
	unset pipe tmpw waitforready barmult barsum

	# wait until window is destroyed
        tkwait window $w
}


# Looks into the image-partition-directory, where the audio-files
# are stored, and seeks the next available number for an audio-track.
# Tracks are named: $prefix_$nr.cdr, so we extract the $nr, look for
# the highest and return the next.

proc find_nextaudionr { prefix } {

	set filelist ""
	catch {set filelist [glob $prefix*]}

	if { $filelist == "" } {
		# No files with such a name, start with number 1
		return 1
	}

	# Search the file with the highest number
	set topnr 0
	set length [ string length $prefix ]
	foreach i $filelist {
		set tmpstr [string range $i $length end]
		set hits [scan $tmpstr "_%d.cdr" nr]
		if { $hits == 1 && $nr > $topnr }  {	
			set topnr $nr
		}
	}
	incr topnr
	return $topnr
}


# calculate the size of a track (including merged tracks)
# return in frames

proc calcfulltracksize { start end } {
global audiocdtoclist

	set tracksum 0
	for { set i $start } { $i <= $end } { incr i } {
		set trksize [lindex $audiocdtoclist [expr 5*$i+4]]
		incr tracksum $trksize
	}
	return $tracksum
}


# delete audiotracks

proc delaudiodialog { w mode } {
global IMAGE_PART
global IMAGE_MNTPNT
global MINIINFO
global delaudiosel
global deltrksizes
global cddalst 
global infoarray

	# Is the image-partition mounted? If not mount it...
	if { [getmountpnt $IMAGE_PART] == "" && $IMAGE_PART != "" } {

		set mstat [domountext2 $IMAGE_PART $IMAGE_MNTPNT]
		if { $mstat == 0 } { ; # mount failed
			Msg_NoAudioImage .audiodelwarn .root
			return
		} elseif { $mstat == 2 } { ; # mountpnt busy 
			Msg_MountdirBusy .mntbusy .root $IMAGE_MNTPNT
			return
		} else {
			Msg_Mounted .dmnt .root $IMAGE_PART $IMAGE_MNTPNT
		}
	}	

        # Draw header-bar
        label $w.l -text "DELETE TRACKS" -relief sunken -borderwidth 2 -anchor c
        pack $w.l -fill x -expand 1 -ipady 10 -pady 5

	set cddalst ""
      	catch { set cddalst [glob $IMAGE_MNTPNT/*.raw $IMAGE_MNTPNT/*.cdr $IMAGE_MNTPNT/*.wav $IMAGE_MNTPNT/*.au] }
	set nrtracks [llength $cddalst]

	# Calc the total-time of all tracks
	set totalsize 0
	foreach i $cddalst {
		set filesize [ file size $i ]
		incr totalsize $filesize
	}
	set totaltime [convertframes2time [expr $totalsize/2352]]
	set totalmb [expr $totalsize/1024/1024]
	set imgfreemb [ getfreeimgspace ]
	set imgfreetime [ convertMB2time $imgfreemb ]

	frame $w.1
	tixLabelWidget $w.1.imgsize -label "Size of selected tracks: " \
		-options { label.width 25 label.anchor e }
	label $w.1.imgsizeval -width 18 -relief sunken -borderwidth 1 \
		-text " 0:00.00 ( 0 MB )" -anchor c \
		-font "-*-helvetica-medium-r-normal-*-14-*-*-*-*-*-*-*"
	tixLabelWidget $w.1.imgfree -label "Free Space: " \
		-options { label.width 15 label.anchor e }
	label $w.1.imgfreeval -width 18 -relief sunken -borderwidth 1 \
		-text "$imgfreetime ( $imgfreemb MB )" -anchor c \
		-font "-*-helvetica-medium-r-normal-*-14-*-*-*-*-*-*-*"

	pack $w.1 -fill x -expand 1 -padx 10 -pady 10
	pack $w.1.imgsize -side left 
	pack $w.1.imgsizeval -expand 1 -fill x -side left
	pack $w.1.imgfree -side left
	pack $w.1.imgfreeval -expand 1 -fill x -side left


	# Defined here to have access to variable "f"   
	tixScrolledWindow $w.5 -height 300 -scrollbar auto
	set f [$w.5 subwidget window]
	pack $w.5 -expand 1 -fill both -padx 10 -pady 10

	label $f.label -font "-misc-fixed-medium-r-normal-*-*-120-*-*-*-*-*-*" \
	-text "\
\ \ Track-          Track-title            Track-         File-name on HD \n\
\ \ \ \ Nr.                                  length                         "

	pack $f.label -fill x 

	for { set i 1 } { $i <= $nrtracks } {incr i } {
		set fname [lindex $cddalst [expr $i-1]]
		set f_name [file tail $fname]
		set basename [string range $fname 0 [expr [string last . $fname]-1]]
		set exten [string range $fname [expr [string last . $fname]+1] end]
		if { $exten == "raw" } {
			set type "Data" 
			set trksize "[expr [file size $fname]/1024/1024] MB"
		} else {
			set type "Audio"
			set trksize [getaudiosize $fname]
		}
		# Info-file-name
		set i_name "$basename.inf"
		set deltrksizes($i) [file size $fname]
		# Load the info-file into an array
		set infoarray($i) [loadfile2list $i_name]

		set delaudiosel($i) 0
		frame $f.$i
		checkbutton $f.$i.sel -variable delaudiosel($i) \
			-command "del_seltrack $w $nrtracks delaudiosel deltrksizes"

		label $f.$i.nrtr -text $i -width 3 -anchor c

		# Extract Track-name 
		if { $type == "Data" } {
			set trkname "DATA: [getisolabel $fname]"
		} else {
			set trkname [extractcolonstr [lindex $infoarray($i) 3]]
		}
		label $f.$i.name -width 25 -text $trkname \
			-relief sunken -borderwidth 1 \
			-font "-*-helvetica-medium-r-normal-*-14-*-*-*-*-*-*-*"

		label $f.$i.tmp1 -width 1 
		label $f.$i.tmp2 -width 1 

		label $f.$i.time -text $trksize -width 10 -anchor c \
			-relief sunken -borderwidth 1 \
			-font "-*-helvetica-medium-r-normal-*-14-*-*-*-*-*-*-*"

		label $f.$i.fname -text $f_name -width 20 -anchor c \
			-relief sunken -borderwidth 1 \
			-font "-*-helvetica-medium-r-normal-*-14-*-*-*-*-*-*-*"

		button $f.$i.info -image MINIINFO \
			-command "showtrackinfo $w $f $i $i infoarray" 

		pack $f.$i.sel $f.$i.nrtr $f.$i.name $f.$i.tmp1 $f.$i.time \
			$f.$i.tmp2 $f.$i.fname -side left 
		pack $f.$i.info -side right
		pack $f.$i -fill x 
	}

	button $w.selall -text "Select All" \
		-command "del_sel_all_tracks $w $f $nrtracks delaudiosel deltrksizes"
	button $w.selnone -text "Select None" \
		-command "del_sel_no_tracks $w $f $nrtracks"
	button $w.del -text  "Delete selected Tracks" \
		-command "delaudiodoit $w $nrtracks delaudiosel cddalst $mode" 

	pack $w.selall $w.selnone $w.del -pady 10 -side left -expand 1
}


# Action when button "Select All Tracks" is pressed 

proc del_sel_all_tracks { w f nrtracks sel sizes } {
upvar $sel audiosel 
upvar $sizes trksizes

	set tracksum 0
	for { set i 1 } { $i <= $nrtracks } {incr i } {
		$f.$i.sel select
		incr tracksum $trksizes($i)
	}
	set time [convertframes2time [expr $tracksum/2352]]
 	set mb [expr ($tracksum/1024/1024)]
	$w.1.imgsizeval configure -text "$time ( $mb MB )" 
}


# Action when button "Select None" is pressed

proc del_sel_no_tracks { w f nrtracks }  {

	for { set i 1 } { $i <= $nrtracks } {incr i } {
		$f.$i.sel deselect
	}
	$w.1.imgsizeval configure -text " 0:00.00 ( 0 MB )" 
}


# Called when you select a track in the delete-track-menu
# or in the write-track-menu

proc del_seltrack { w nrtracks sel sizes} {
upvar $sel audiosel 
upvar $sizes trksizes

	# Calculate how big all selected tracks are until now 
	set tracksum 0
	for { set i 1 } { $i <= $nrtracks } {incr i } {
		if { $audiosel($i) != 0 } {
			incr tracksum $trksizes($i)
		}
	}
	set time [convertframes2time [expr $tracksum/2352]]
 	set mb [expr ($tracksum/1024/1024)]
	$w.1.imgsizeval configure -text "$time ( $mb MB )" 
}


# Called when the "delete" button in the delete-menu is pressed.
# Deletes any selected audio-files and its info-files.

proc delaudiodoit { w nrtracks sel cddalst mode } {
upvar $sel audiosel 
upvar $cddalst filenames

global sidebar
global RM

	# How many selected?
	set count 0 
	for { set i 1 } { $i <= $nrtracks } {incr i } {
		if { $audiosel($i) != 0 } {
			incr count
		}
	}
	if { $count == 0 } {
		# nothing selected
		Msg_NoTracksSel .notrk .root 
		return
	} else {
		set ret [Msg_DeleteTracks .deltrk .root $count]
		if { $ret == 1 } {
			return
		}
	}

	set new .delaudiododel

	set oldf [createsubwindow $new .root 0 ""]

	$new configure -cursor watch
	label $new.l -text "Deleting selected Tracks"
	label $new.l2 -text "Please wait"

 	pack $new.l $new.l2 -padx 10 -pady 10
        update

	# Here is the action
	set count 0 
	for { set i 1 } { $i <= $nrtracks } {incr i } {
		if { $audiosel($i) != 0 } {
			set fname [lindex $filenames [expr $i-1]]
 			set basename [string range $fname 0 [expr [string last . $fname]-1]]
		        set i_name "$basename.inf"
			catch { exec $RM $fname $i_name }
			incr count
			log .root "Delete-Track: deleted track $fname"
		}
	}

	destroysubwindow $new .root {$oldf} 0

	# simulate press on "delete-tracks" sidebar button
	if { $mode == "audio" } {
		$sidebar.all.b5 invoke
	} else {
		$sidebar.all.b8 invoke
	}
}


# Called when info-button in delete, play or write-menu is pressed.

proc showtrackinfo { w f i j info } {
upvar $info infoarray

global audiotrackinfo

	set audiotrackinfo $infoarray($i)

	$f.$j.info configure -bg red -relief sunken

	# this line make from ".root.bla.window.test" -> ".root"
	set homewindow ".[lindex [split $f "."] 1]"
	showtrackinfo_doit .showtrackinfo $homewindow 

	$f.$j.info configure -bg lightgray -relief raised 

	unset audiotrackinfo
}


# Displays all information in an audio-info-file

proc showtrackinfo_doit { w wroot } {
global audiotrackinfo 

        # create new window
        set oldf [createsubwindow $w $wroot 2 ""]

	label $w.l -text "TRACK INFORMATION" -relief sunken -borderwidth 2 -anchor c
	pack $w.l -fill x -expand 1 -ipady 10 -pady 5 -ipadx 30

	if { $audiotrackinfo == {} } {
		label $w.l2 -text "No Audio-Description-file found."
		pack $w.l2 -padx 10 -pady 10
	} else {
	
		set cdname [extractcolonstr [lindex $audiotrackinfo 2]]
		set trkname [extractcolonstr [lindex $audiotrackinfo 3]]
		set trknr [extractcolonstr [lindex $audiotrackinfo 4]]
		set trksize [extractcolonstr [lindex $audiotrackinfo 5]]
		set offsets [extractcolonstr [lindex $audiotrackinfo 6]]
		set preemp [extractcolonstr [lindex $audiotrackinfo 7]]
		set cpyprm [extractcolonstr [lindex $audiotrackinfo 8]]
		set skip2 [extractcolonstr [lindex $audiotrackinfo 9]]
		set bigend [extractcolonstr [lindex $audiotrackinfo 10]]
	
		frame $w.1
		tixLabelWidget $w.1.l -label "CD-Name : " \
			-options {label.width 16 label.anchor e}
		message $w.1.v -anchor w -width 300 -text $cdname
		pack $w.1 -expand 1 -fill x  
		pack $w.1.l -side left
		pack $w.1.v -side left -expand 1 -fill x
	
		frame $w.2
		tixLabelWidget $w.2.l -label "Track-Name : " \
			-options {label.width 16 label.anchor e}
		message $w.2.v -anchor w -width 300 -text $trkname
		pack $w.2 -expand 1 -fill x
		pack $w.2.l -side left
		pack $w.2.v -side left -expand 1 -fill x
	
		frame $w.3
		tixLabelWidget $w.3.l -label "Track-Number : " \
			-options {label.width 16 label.anchor e}
		message $w.3.v -anchor w -width 300 -text $trknr
		pack $w.3 -expand 1 -fill x 
		pack $w.3.l -side left
		pack $w.3.v -side left -expand 1 -fill x

		frame $w.35
		tixLabelWidget $w.35.l -label "Track-Size : " \
			-options {label.width 16 label.anchor e}
		message $w.35.v -anchor w -width 300 -text $trksize
		pack $w.35 -expand 1 -fill x 
		pack $w.35.l -side left
		pack $w.35.v -side left -expand 1 -fill x
	
		frame $w.4
		tixLabelWidget $w.4.l -label "Offsets : " \
			-options {label.width 16 label.anchor e}
		message $w.4.v -anchor w -width 300 -text $offsets
		pack $w.4 -expand 1 -fill x
		pack $w.4.l -side left
		pack $w.4.v -side left -expand 1 -fill x
	
		frame $w.5
		tixLabelWidget $w.5.l -label "Preemphasis : " \
			-options {label.width 16 label.anchor e}
		message $w.5.v -anchor w -width 300 -text $preemp
		pack $w.5 -expand 1 -fill x 
		pack $w.5.l -side left
		pack $w.5.v -side left -expand 1 -fill x
	
		frame $w.6
		tixLabelWidget $w.6.l -label "Copy-permitted : " \
			-options {label.width 16 label.anchor e}
		message $w.6.v -anchor w -width 300 -text $cpyprm
		pack $w.6 -expand 1 -fill x
		pack $w.6.l -side left
		pack $w.6.v -side left -expand 1 -fill x
	
		frame $w.7
		tixLabelWidget $w.7.l -label "Skip last 2 sec. : " \
			-options {label.width 16 label.anchor e}
		message $w.7.v -anchor w -width 300 -text $skip2
		pack $w.7 -expand 1 -fill x
		pack $w.7.l -side left
		pack $w.7.v -side left -expand 1 -fill x
	
		frame $w.8
		tixLabelWidget $w.8.l -label "Big-Endian : " \
			-options {label.width 16 label.anchor e}
		message $w.8.v -anchor w -width 300 -text $bigend
		pack $w.8 -expand 1 -fill x
		pack $w.8.l -side left
		pack $w.8.v -side left -expand 1 -fill x
	}

  	tixButtonBox $w.box -orientation horizontal
        $w.box add ok -text "Ok"  \
		-command "destroysubwindow $w $wroot {$oldf} 2"
        pack $w.box -fill x -expand 1

        # wait until window is destroyed
        tkwait window $w

}


# Play-audio-track dialog: Plays audio-tracks from HD

proc playaudiodialog { w } {
global IMAGE_PART
global IMAGE_MNTPNT
global XCDR_DSP_DEV
global MINIINFO
global deltrksizes
global cddalst 
global infoarray

	# Is the image-partition mounted? If not mount it...
	if { [getmountpnt $IMAGE_PART] == "" && $IMAGE_PART != "" } {

		set mstat [domountext2 $IMAGE_PART $IMAGE_MNTPNT]
		if { $mstat == 0 } { ; # mount failed
			Msg_NoAudioImage .audioplaywarn .root
			return
		} elseif { $mstat == 2 } { ; # mountpnt busy 
			Msg_MountdirBusy .mntbusy .root $IMAGE_MNTPNT
			return
		} else {
			Msg_Mounted .mntd .root $IMAGE_PART $IMAGE_MNTPNT
		}
	}	

        # Draw header-bar
        label $w.l -text "PLAY AUDIO TRACKS" -relief sunken -borderwidth 2 -anchor c
        pack $w.l -fill x -expand 1 -ipady 10 -pady 5

	set cddalst ""
      	catch { set cddalst [glob $IMAGE_MNTPNT/*.cdr] }
	set nrtracks [llength $cddalst]

	# Calc the total-time of all tracks
	set totalsize 0
	foreach i $cddalst {
		set filesize [ file size $i ]
		incr totalsize $filesize
	}
	# keep this values around for later use (perhaps)
	set totaltime [convertframes2time [expr $totalsize/2352]]
	set totalmb [expr $totalsize/1024/1024]

	tixScrolledWindow $w.5 -height 400 -scrollbar auto
	set f [$w.5 subwidget window]
	pack $w.5 -expand 1 -fill both -padx 10 -pady 10

	label $f.label -font "-misc-fixed-medium-r-normal-*-*-120-*-*-*-*-*-*" \
	-text "\
\ \ Track-          Track-title            Track-         File-name on HD \n\
\ \ \ \ Nr.                                  length                         "

	pack $f.label -fill x 

	for { set i 1 } { $i <= $nrtracks } {incr i } {
		set fname [lindex $cddalst [expr $i-1]]
		set f_name [file tail $fname]
		# Info-file-name
		set i_name "[string range $fname 0 [expr [string length $fname]-4]]inf"
		set trksize [getaudiosize $fname]
		set deltrksizes($i) [file size $fname]

		# Load the info-file into an array
		set infoarray($i) [loadfile2list $i_name]

		frame $f.$i

		label $f.$i.nrtr -text $i -width 3 -anchor c

		# Extract Track-name 
		set trkname [extractcolonstr [lindex $infoarray($i) 3]]
		label $f.$i.name -width 25 -text $trkname \
			-relief sunken -borderwidth 1 \
			-font "-*-helvetica-medium-r-normal-*-14-*-*-*-*-*-*-*"

		label $f.$i.tmp1 -width 1 
		label $f.$i.tmp2 -width 1 
		label $f.$i.tmp3 -width 1 
		label $f.$i.tmp4 -width 3 

		label $f.$i.time -text $trksize -width 10 -anchor c \
			-relief sunken -borderwidth 1 \
			-font "-*-helvetica-medium-r-normal-*-14-*-*-*-*-*-*-*"

		label $f.$i.fname -text $f_name -width 20 -anchor c \
			-relief sunken -borderwidth 1 \
			-font "-*-helvetica-medium-r-normal-*-14-*-*-*-*-*-*-*"

		button $f.$i.info -image MINIINFO \
			-command "showtrackinfo $w $f $i $i infoarray" 
		button $f.$i.play -image PLAYICO \
			-command "playaudiotrack $f $i $fname"
		if { $XCDR_DSP_DEV == "None" } {
			$f.$i.play configure -state disabled	
		}

		pack $f.$i.tmp4 $f.$i.nrtr $f.$i.tmp3 $f.$i.name $f.$i.tmp1 $f.$i.time \
			$f.$i.tmp2 $f.$i.fname -side left 
		pack $f.$i.play $f.$i.info -side right
		pack $f.$i -fill x 
	}
}


# Called when play-button in play-menu is pressed.

proc playaudiotrack { f i name } {
global audioplayfname 

	set audioplayfname $name

	$f.$i.play configure -bg red -relief sunken

	audioplay_doit .doplayaudio .root

	$f.$i.play configure -bg lightgray -relief raised 

}


# Verify-Data-Track-Dialog

proc verifydatatrackdialog { w } {
global IMAGE_PART
global IMAGE_MNTPNT
global IMAGE_LABEL
global TMP_DESTNAME
global TMP_DEST
global XCDR_AUDIO_SOURCE_CDROM
global XCDR_AUDIOREAD_SPEED

	set blkname [ convCD2block audio ]

	if {[checkifready .root audio] == 1} {
		return
	}
	
	if {[checkifaudio $blkname] == 1 } {
		Msg_NoDataCD .ndcd .root 
		return
	}

        if {[checkifiso $blkname] == 0 } {
                set NONISO 1
        } else {
                set NONISO 0
        }

	# Is the image-partition mounted? If not mount it...
	if { [getmountpnt $IMAGE_PART] == "" && $IMAGE_PART != "" } {

		set mstat [domountext2 $IMAGE_PART $IMAGE_MNTPNT]
		if { $mstat == 0 } { ; # mount failed
			Msg_NoAudioImage .verifydatawarn .root
			return
		} elseif { $mstat == 2 } { ; # mountpnt busy 
			Msg_MountdirBusy .mntbusy .root $IMAGE_MNTPNT
			return
		} else {
			Msg_Mounted .mntd .root $IMAGE_PART $IMAGE_MNTPNT
		}
	}	


	set TMP_DEST "file"

        if { $NONISO == 0 } {
                set imgspace [expr [ getisosize $blkname ]/1024/1024]
		set imglabel "[getisolabel $blkname]"
        } else {
                set imgspace [expr [ getnonisosize $blkname ]/1024/1024] 
		set imglabel " - not available - "
		if { $imgspace == 0 } {
			Msg_ImpossibleNonIso .iniso .root 
			return
		}
        }

        # Draw header-bar
        label $w.l -text "VERIFY DATA-TRACK" -relief sunken -borderwidth 2 -anchor c
        pack $w.l -fill x -expand 1 -ipady 10 -pady 5

        # Create Devices-Setup
        tixLabelFrame $w.devs -label Devices-Setup 
        set w1 [$w.devs subwidget frame]
        pack $w.devs -expand 1 -fill x

        frame $w1.1
        tixLabelWidget $w1.1.readl -label "Compare Data-Track from : " \
                -options {label.width 25 label.anchor e}
        message $w1.1.readt -anchor w -width 300 -relief groove
        $w1.1.readt configure -text $XCDR_AUDIO_SOURCE_CDROM
        if { $XCDR_AUDIOREAD_SPEED == -1 } {
                label $w1.1.spd -text "Speed: Default"
        } else {
                label $w1.1.spd -text "Speed: $XCDR_AUDIOREAD_SPEED x"
        }

        tixForm $w1.1.readl -left %0
        tixForm $w1.1.readt -left %32 -right %80
        #tixForm $w1.1.spd -left %82

        frame $w1.2
        tixLabelWidget $w1.2.imgl -label "Compare with Image on : " \
                -options {label.width 25 label.anchor e}
        message $w1.2.imgt -anchor w -width 300 -relief groove  
        label $w1.2.lbl -text "\[$IMAGE_LABEL\]"
        redraw_imagebox $w1.2.imgt

        tixForm $w1.2.imgl -left %0
        tixForm $w1.2.imgt -left %32 -right %80
        tixForm $w1.2.lbl -left %82 

        pack $w1.1 $w1.2 -side top -expand 1 -fill x

        #-------------------------------------------------

	frame $w.1
	tixLabelWidget $w.1.imgsize -label "Data-Track Size : " \
		-options { label.width 30 label.anchor e }
	message $w.1.imgsizeval -width 150 -relief sunken -borderwidth 1 \
		-text "$imgspace MB"
        frame $w.16
        tixLabelWidget $w.16.imglabel -label "Data-Track ISO9660-Label : " \
                -options { label.width 30 label.anchor e }
        message $w.16.imglabelval -width 150 -relief sunken -borderwidth 1 \
                -text "$imglabel"

        pack $w.1 -fill x -expand 1 -padx 10 -pady 10
        tixForm $w.1.imgsize -left %0
        tixForm $w.1.imgsizeval -left %40 -right %70
        pack $w.16 -fill x -expand 1 -padx 10 -pady 10
        tixForm $w.16.imglabel -left %0
        tixForm $w.16.imglabelval -left %40 -right %70

        canvas $w.20 -height 0 -width 30 -relief sunken -borderwidth 1
        pack $w.20 -pady 10 -fill x -expand 1

	frame $w.3
	tixComboBox $w.3.imgfname -disabledforeground gray \
		-editable true -dropdown true -variable TMP_DESTNAME \
		-selectmode immediate \
		-label "Verify Data-Track : " \
		-options {
			label.width 20 
			label.anchor e
			listbox.height 5
			entry.width 15 
		}

	pack $w.3 -fill x -expand 1 -padx 10 -pady 10
	tixForm $w.3.imgfname -left %0 -right %70

	# analyse directory-contents
	set rawlst ""
	catch { set rawlst [glob $IMAGE_MNTPNT/*.raw] }
	set rawlist [split $rawlst]
	foreach i $rawlist {
		set name [file tail $i]
		$w.3.imgfname insert end "$name"

		# If this filename was selected in the read-image-box
		# also select it now.
		if { $name == $TMP_DESTNAME } {
			tixSetSilent $w.3.imgfname $name
		}
	}
	# If there is only one image-file in the directory, select it
	if { [llength $rawlist] == 1 } {
		tixSetSilent $w.3.imgfname [file tail $rawlist]
	}

	canvas $w.30 -height 0 -width 30 -relief sunken -borderwidth 1
        pack $w.30 -pady 10 -fill x -expand 1

        button $w.start -text "Start Verify Data-Track" \
                -command "verifyimagedoit .verify_doit audio" 

	pack $w.start -pady 7 

	# If there is still no file selected, select the last in the list
	if { $TMP_DESTNAME == "" } {
		set last [lindex $rawlist [expr [llength $rawlist]-1]]
		if { $last != "" } {
			set name [file tail $last]
			tixSetSilent $w.3.imgfname $name
		}
	}
}


# Write-Audio-Dialog

proc writeaudiodialog { w } {
global IMAGE_PART
global IMAGE_MNTPNT
global IMAGE_LABEL
global MINIINFO
global ADDARROW
global DELARROW
global cddalst 
global infoarray
global wrtaudiosel
global wrttrksizes
global towritesel
global nrtowrite
global towrtaudio
global cd_type
global audionrtracks
global tracksavailable
global trackstowrite
global trackinfolist
global need_refresh
global DUMMY EJECT PADDATA SWABAUDIO
global XCDR_DUMMY XCDR_EJECT XCDR_PADDATA XCDR_SWABAUDIO
global XCDR_DEST_WRITER_DEV
global XCDR_DEST_WRITER_SPEED

        # default setting of cd-type
        if { [ info exists cd_type ] == 0  } {
                set cd_type 74
        }
        if { $DUMMY == "" } {
                set DUMMY $XCDR_DUMMY
        }
        if { $EJECT == "" } {
                set EJECT $XCDR_EJECT
        }
        if { $PADDATA == "" } {
                set PADDATA $XCDR_PADDATA
        }
        if { $SWABAUDIO == "" } {
                set SWABAUDIO $XCDR_SWABAUDIO
        }

        # delete the old settings
        if { [info exists tracksavailable] == 1 } {
                unset tracksavailable 
        }
        if { [info exists trackstowrite] == 1 } {
                unset trackstowrite 
        }
        if { [info exists trackinfolist] == 1 } {
                unset trackinfolist 
        }

	# we are at clean status now
	set need_refresh 0

	# Is the image-partition mounted? If not mount it...
	if { [getmountpnt $IMAGE_PART] == "" && $IMAGE_PART != "" } {

		set mstat [domountext2 $IMAGE_PART $IMAGE_MNTPNT]
		if { $mstat == 0 } { ; # mount failed
			Msg_NoAudioImage .audiowritewarn .root
			return
		} elseif { $mstat == 2 } { ; # mountpnt busy 
			Msg_MountdirBusy .mntbusy .root $IMAGE_MNTPNT
			return
		} else {
			Msg_Mounted .mntd .root $IMAGE_PART $IMAGE_MNTPNT
		}
	}	

        # Draw header-bar
        label $w.l -text "WRITE TRACKS" -relief sunken -borderwidth 2 -anchor c
        pack $w.l -fill x -expand 1 -ipady 10 -pady 5

        # Create Devices-Setup
        tixLabelFrame $w.devs -label Devices-Setup 
        set w1 [$w.devs subwidget frame]
        pack $w.devs -expand 1 -fill x

        frame $w1.2
        tixLabelWidget $w1.2.imgl -label "Read Tracks from : " \
                -options {label.width 25 label.anchor e}
        message $w1.2.imgt -anchor w -width 300 -relief groove  
        label $w1.2.lbl -text "\[$IMAGE_LABEL\]"
        redraw_imagebox $w1.2.imgt

        tixForm $w1.2.imgl -left %0
        tixForm $w1.2.imgt -left %32 -right %80
        tixForm $w1.2.lbl -left %82 

        frame $w1.3
        tixLabelWidget $w1.3.writel -label "Write Tracks to : " \
                -options {label.width 25 label.anchor e}
        message $w1.3.writet -anchor w -width 300 -relief groove
        $w1.3.writet configure -text $XCDR_DEST_WRITER_DEV
        #label $w1.3.spd -text "Speed: $XCDR_DEST_WRITER_SPEED x"

	set tmpval $XCDR_DEST_WRITER_SPEED
	unset XCDR_DEST_WRITER_SPEED
	tixOptionMenu $w1.3.spd -variable XCDR_DEST_WRITER_SPEED \
		-options { label.width 7 menubutton.width 1 } \
		-label "Speed: "	
	$w1.3.spd add command "0"
	$w1.3.spd add command "1"
	$w1.3.spd add command "2"
	$w1.3.spd add command "4"
	$w1.3.spd add command "6"
	$w1.3.spd add command "8"
	if { $tmpval != "" } {
		catch { $w1.3.spd configure -value $tmpval }
	}

        tixForm $w1.3.writel -left %0
        tixForm $w1.3.writet -left %32 -right %80
        tixForm $w1.3.spd -left %82

        pack $w1.2 $w1.3 -side top -expand 1 -fill x

        #-------------------------------------------------

	set cddalst ""
      	catch { set cddalst [glob $IMAGE_MNTPNT/*.raw $IMAGE_MNTPNT/*.cdr $IMAGE_MNTPNT/*.wav $IMAGE_MNTPNT/*.au] }
	set nrtracks [llength $cddalst]
	set audionrtracks $nrtracks

	# Calc the total-time of all tracks
	set totalsize 0
	foreach i $cddalst {
		set tmpidx [expr [string length $i] - 4]

		if { [string range $i $tmpidx end] == ".raw" } {
			# this is a data-track -> use different blocksize
			set filesize [ file size $i ]
			incr totalsize [expr ($filesize/2048)*2352]
		} else {
			# audiotrack
			set filesize [ file size $i ]
			incr totalsize $filesize
		}
	}
	set totaltime [convertframes2time [expr $totalsize/2352]]
	set totalmb [expr $totalsize/1024/1024]
	set nrtowrite 0

	# scan HD for tracks
	for { set i 0 } { $i < $audionrtracks } {incr i } {
		set fname [lindex $cddalst $i]
		set f_name [file tail $fname]
		set basename [string range $fname 0 [expr [string last . $fname]-1]]
		set exten [string range $fname [expr [string last . $fname]+1] end]
		if { $exten == "raw" } {
			set type "Data" 
			set trksize "[expr [file size $fname]/1024/1024] MB"
		} else {
			set type "Audio"
			set trksize [getaudiosize $fname]
		}
		# Info-file-name
		set i_name "$basename.inf"
		# Load the info-file into an array
		set infoarray($i) [loadfile2list $i_name]

		# Extract Track-name 
                if { $type == "Data" } {
                        set trkname "DATA: [getisolabel $fname]"
                } else {
                        set trkname [extractcolonstr [lindex $infoarray($i) 3]]
                }

		set trackinfolist($i,type) $type
		set trackinfolist($i,fname) $fname
		set trackinfolist($i,iname) $i_name
		set trackinfolist($i,size) $trksize
		set trackinfolist($i,label) $trkname

		# set to -1 = empty entry
		set trackstowrite($i,stat) -1
		set trackstowrite($i,track) -1
		# set to 0 = available to select, but not selected yet
		set tracksavailable($i,stat) 0
		set tracksavailable($i,track) $i 
	}

        # create a left and right frame
        frame $w.mid
        frame $w.mid.l
        frame $w.mid.r
        pack $w.mid
        tixForm $w.mid.l -left %0 -right %63
        tixForm $w.mid.r -left %65 -right %100

        frame $w.mid.l.6
        tixLabelWidget $w.mid.l.6.type -label "CD-Recordable-Type: " \
                -options { label.width 25 label.anchor e }
        radiobutton $w.mid.l.6.b1 -text "74 min ( 650 MB )" -variable cd_type -value 74

        pack $w.mid.l.6 -fill x -expand 1 -padx 10 
        pack $w.mid.l.6.type $w.mid.l.6.b1 -side left

        frame $w.mid.l.5
        tixLabelWidget $w.mid.l.5.type \
                -options { label.width 25 label.anchor e }
        radiobutton $w.mid.l.5.b2 -text "63 min ( 553 MB )" -variable cd_type -value 63

        pack $w.mid.l.5 -fill x -expand 1 -padx 10 
        pack $w.mid.l.5.type $w.mid.l.5.b2 -side left

        frame $w.mid.l.1
        tixLabelWidget $w.mid.l.1.imgcount -label "Tracks on HD : " \
                -options { label.width 25 label.anchor e }
        message $w.mid.l.1.imgcountval -width 150 -relief sunken -borderwidth 1 \
                -text "$nrtracks"

        pack $w.mid.l.1 -fill x -expand 1 -padx 10 -pady 10
        pack $w.mid.l.1.imgcount -side left 
        pack $w.mid.l.1.imgcountval -expand 1 -fill x -side left

        frame $w.mid.l.16
        tixLabelWidget $w.mid.l.16.imgsize -label "Total length : " \
                -options { label.width 25 label.anchor e }
        message $w.mid.l.16.imgsizeval -width 150 -relief sunken \
                -borderwidth 1 -text "$totaltime ( $totalmb MB )"

        pack $w.mid.l.16 -fill x -expand 1 -padx 10 -pady 10
        pack $w.mid.l.16.imgsize -side left 
        pack $w.mid.l.16.imgsizeval -expand 1 -fill x -side left

        frame $w.mid.l.17
        tixLabelWidget $w.mid.l.17.imgsel -label "Tracks to write on CD : " \
                -options { label.width 25 label.anchor e }
        message $w.mid.l.17.imgselval -width 150 -relief sunken \
                -borderwidth 1 -text "0"

        pack $w.mid.l.17 -fill x -expand 1 -padx 10 -pady 10
        pack $w.mid.l.17.imgsel -side left 
        pack $w.mid.l.17.imgselval -expand 1 -fill x -side left

        frame $w.mid.l.18
        tixLabelWidget $w.mid.l.18.wrtsize -label "Total CD-Size : " \
                -options { label.width 25 label.anchor e }
        message $w.mid.l.18.wrtsizeval -width 150 -relief sunken \
                -borderwidth 1 -text " 0:00.00 ( 0 MB )"

        pack $w.mid.l.18 -fill x -expand 1 -padx 10 -pady 10
        pack $w.mid.l.18.wrtsize -side left 
        pack $w.mid.l.18.wrtsizeval -expand 1 -fill x -side left


        tixLabelFrame $w.mid.r.4 -label "Additional Options"
        set w1 [$w.mid.r.4 subwidget frame]
        pack $w.mid.r.4 -expand 1 -fill x -padx 30 -pady 10

        checkbutton $w1.b1 -variable DUMMY -anchor w \
                -text "Simulation-Write"
        pack $w1.b1 -expand 1 -fill x -padx 10 

        checkbutton $w1.b2 -variable EJECT -anchor w \
                -text "Eject after write"
        pack $w1.b2 -expand 1 -fill x -padx 10 

        checkbutton $w1.b3 -variable PADDATA -anchor w \
                -text "Pad Data-Track"
        pack $w1.b3 -expand 1 -fill x -padx 10 

        checkbutton $w1.b4 -variable SWABAUDIO -anchor w \
                -text "Swap Audio"
        pack $w1.b4 -expand 1 -fill x -padx 10 

        # ----------------------------

        canvas $w.20 -height 0 -width 30 -relief sunken -borderwidth 1
        pack $w.20 -pady 10 -fill x -expand 1


        button $w.start -text "Start Write Tracks" \
                -command "writeaudiodoit .writeaudiodoit $w"
        button $w.start2 -text "Select/Show Tracks to Write" \
                -command "writetrackssub .writetracksub $w"
        pack $w.start2 $w.start -pady 10 -side left -expand 1

}


# show and arrange the tracks to write

proc writetrackssub { w wroot } {
global IMAGE_PART
global IMAGE_MNTPNT
global IMAGE_LABEL
global MINIINFO
global ADDARROW
global DELARROW
global cddalst 
global infoarray
global wrtaudiosel
global wrttrksizes
global towritesel
global nrtowrite
global audionrtracks
global towrtaudio
global trackinfolist
global tracksavailable
global trackstowrite
global cd_type
global TMP_INSERT_HOOK

        # create new window
        set oldf [createsubwindow $w .root 2 ""]

	frame $w.menu -bd 1 -relief raised
	menubutton $w.menu.file -menu $w.menu.file.m -text "File" 
	menu $w.menu.file.m
	$w.menu.file.m add command -label "Save Track-list" \
		-command "savetracklist .svtrk $w track.lst"

	pack $w.menu.file -side left
	pack $w.menu -fill x -expand 0

	 # Draw header-bar
        label $w.l -text "SELECT TRACKS TO WRITE" -relief sunken \
                -borderwidth 2 -anchor c
        pack $w.l -fill x -expand 0 -ipady 10 -pady 5

        tixScrolledWindow $w.5 -height 300 -scrollbar auto
        set f [$w.5 subwidget window]
	pack $w.5 -expand 0 -fill x -padx 10 -pady 10
	
	label $f.l1 -text "Tracks to write on CD" -relief raised \
		-anchor c -borderwidth 1 -bg linen
	pack $f.l1 -expand 0 -fill x

	set labelstr "\
Trk-Nr.          Track-title            Trk-size         File-name on HD  "
	label $f.label -font "-misc-fixed-medium-r-normal-*-*-120-*-*-*-*-*-*" \
	-text $labelstr
	pack $f.label -fill x 

	frame $f.cd 
	frame $f.cd.all 
	set nrdisplayed [fillwritesel $w $f.cd.all $audionrtracks 0]
	pack $f.cd.all
	pack $f.cd

	canvas $f.20 -height 0 -width 30 -relief sunken -borderwidth 1
	pack $f.20 -pady 3 -fill x -expand 0

	label $f.l2 -text "Tracks available on HD" -relief raised \
		-anchor c -borderwidth 1 -bg linen
	pack $f.l2 -expand 0 -fill x

	set labelstr2 "\
\ Order           Track-title            Trk-size         File-name on HD  "
	label $f.label2 -font "-misc-fixed-medium-r-normal-*-*-120-*-*-*-*-*-*" \
	-text $labelstr2
	pack $f.label2 -fill x 

	frame $f.hd 
	frame $f.hd.all
	fillwritesel $w $f.hd.all $audionrtracks 1
	pack $f.hd.all
	pack $f.hd

	set tmpval $TMP_INSERT_HOOK
	unset TMP_INSERT_HOOK

	tixOptionMenu $w.opt -variable TMP_INSERT_HOOK \
		-label "Insert selected Tracks " \
		-options { label.width 25 label.anchor e menubutton.width 15 }

	$w.opt add command "after last track"
	$w.opt add command "at beginning"
	for { set i 1 } { $i <= $nrdisplayed } { incr i } {
		$w.opt add command "after track $i"
	}
	if { $tmpval != "" } {
		catch { $w.opt configure -value $tmpval }
	}

	pack $w.opt 

        button $w.selall -text "Select All" \
		-command "wrt_sel_all_tracks $f.hd.all $audionrtracks" 
        button $w.selnone -text "Select None" \
		-command "wrt_sel_no_tracks $f.hd.all $audionrtracks" 
        button $w.refresh -text "Refresh" \
		-command "selwriterefresh $w $f $audionrtracks $wroot"
        button $w.cancel -text "Done" \
                -command "doneseltracks $w .root {$oldf}"

        pack $w.selall $w.selnone $w.refresh $w.cancel \
		 -pady 5 -side left -expand 1

	# wait until window is destroyed
        tkwait window $w
}


# called by the done-button in select-write-tracks

proc doneseltracks { w wold oldf } {
global need_refresh

	if { $need_refresh == 1 } {
		Msg_RefreshNeeded .msgnr $w
	} else {	
      		destroysubwindow $w $wold {$oldf} 2
	}
}


# called by save-track-list menu item

proc savetracklist { w wold deffilename } {
global need_refresh
global waitforok
global trackstowrite
global trackinfolist
global audionrtracks

	if { $need_refresh == 1 } {
		Msg_RefreshNeeded .msgnr $wold
		return
	} 	

        set waitforok 0 
        set oldf [createsubwindow $w $wold 2 ""]

        label $w.header -text "Save Track-List" -relief sunken \
                -borderwidth 2 -anchor c -width 40
        pack $w.header -fill x -expand 1 -ipadx 10 -ipady 10 -pady 5

        tixFileSelectBox $w.dlg \
                -pattern {*.out} \
                -value $deffilename
        pack $w.dlg -fill x -expand 1

        tixButtonBox $w.box -orientation horizontal
        $w.box add ok -text "Save" -width 5 \
                -command "set waitforok 1"
        $w.box add cancel -text "Cancel" -width 5 \
                -command "set waitforok 0"
        pack $w.box -fill x -expand 1

        tkwait variable waitforok 
        set filename [$w.dlg cget -value] 
        destroysubwindow $w $wold {$oldf} 2

        # cancel
        if { $waitforok == 0 } { return }

	# write to file
	set fileid [open $filename w]
	chownfile $filename

	set count 1
	for { set i 0 } { $i < $audionrtracks } { incr i } {
		if { $trackstowrite($i,stat) > 0 } {
			set trk $trackstowrite($i,track)
			set label $trackinfolist($trk,label)
			set size $trackinfolist($trk,size)

			set outstr [format "%2d. %-30s %10s" $count $label $size]
			puts $fileid $outstr
			incr count
		}
	}

	close $fileid
	
	Msg_TrackListSaved .msgbuf $wold $filename	
}


# fill the select-tracks-to-write list on screen
# mode = 0 if towriteoncd, 1 if availableonhd
# returns the number of tracks displayed

proc fillwritesel { w f nrtracks mode } {
global trackstowrite
global trackinfolist
global tracksavailable
global MINIINFO

	set count 0
	for { set i 0 } { $i < $nrtracks } {incr i } {

		frame $f.$i
		if { $mode == 0 } {
			set stat $trackstowrite($i,stat)
			set trk $trackstowrite($i,track)
		} else {
			set stat $tracksavailable($i,stat)
			set trk $tracksavailable($i,track)
		}
		# this track is not selectable
		if { $stat == -1 } {
			continue
		}
		incr count
	
		button $f.$i.sel -borderwidth 1 -width 3 -anchor c \
			-command "selwritetrack $f.$i.sel $i $mode $nrtracks" 

		# update button-contents
		if { $stat > 0 } {
			$f.$i.sel config -text "$stat"
		}

		label $f.$i.name -width 25 -text $trackinfolist($trk,label) \
			-relief sunken -borderwidth 1 \
			-font "-*-helvetica-medium-r-normal-*-14-*-*-*-*-*-*-*"

		label $f.$i.tmp1 -width 1 
		label $f.$i.tmp2 -width 1 
		label $f.$i.tmp3 -width 1 
		label $f.$i.tmp4 -width 1 

		label $f.$i.time -text $trackinfolist($trk,size) -width 10 \
			-anchor c -relief sunken -borderwidth 1 \
			-font "-*-helvetica-medium-r-normal-*-14-*-*-*-*-*-*-*"

		label $f.$i.fname -text $trackinfolist($trk,fname) \
			-width 20 -anchor c -relief sunken -borderwidth 1 \
			-font "-*-helvetica-medium-r-normal-*-14-*-*-*-*-*-*-*"

		button $f.$i.info -image MINIINFO \
			-command "showtrackinfo $w $f $trk $i infoarray" 

		pack $f.$i.sel $f.$i.tmp4 $f.$i.name $f.$i.tmp1 \
			$f.$i.time $f.$i.tmp2 $f.$i.fname -side left 
		pack $f.$i.info $f.$i.tmp3 -side right
		pack $f.$i -fill x 
	}

	# no tracks available to select?
	if { $count == 0 } {
		label $f.none -text "- None -" -anchor c
		pack $f.none -pady 10
	}

	return $count
}


# called when a button in the sel-write-tracks menu is pressed

proc selwritetrack { button index mode nrtracks } {
global trackstowrite
global trackinfolist
global tracksavailable
global need_refresh

	if { $mode == 0 } {
		# click on track in upper half

		# track already selected? if yes deselect
		if { $trackstowrite($index,stat) > 0 } {
			$button config -text "" 
			set trackstowrite($index,stat) 0	
		} else {
			# search next free number and assign to that track
			set free -1
			for { set i 1 } { $i <= $nrtracks } { incr i } {
				set found 0
				for { set j 0 } { $j < $nrtracks } { incr j } {
					if { $i == $trackstowrite($j,stat) } {	
						# track with idx $i found
						set found 1
						break
					}
				}
				if { $found == 0 } {
					# $i is the lowest free number
					set free $i
					break
				}	
			}

			$button config -text "$free"
			set trackstowrite($index,stat) $free
		}
	} else {
		# click on track in lower half

		# track already selected? if yes deselect
		if { $tracksavailable($index,stat) > 0 } {
			$button config -text "" 
			set tracksavailable($index,stat) 0	
		} else {
			# search for highest next free number
			set high 0
			for { set i 0 } { $i < $nrtracks } { incr i } {
				set stat $tracksavailable($i,stat)
				if { $high < $stat } {
					set high $stat 
				}
			}
			set high [expr $high + 1]

			$button config -text "$high"
			set tracksavailable($index,stat) $high	
		}
	}	

	set need_refresh 1
}
 

# called by the refresh-button in the sel-tracks-menu
# calculates the current track-layout and updates the screen

proc selwriterefresh { w f nrtracks wroot } {
global trackstowrite
global trackinfolist
global tracksavailable
global need_refresh

	# get value of optionmenu
	set val [$w.opt cget -value]
	if { $val == "after last track" } {
		set insertafter 999
	} elseif { $val == "at beginning" } {
		set insertafter 0 
	} else {
		set insertafter [lindex [split $val " "] 2]	
	}


	# look for not selected tracks and move down
	for { set i 0 } { $i < $nrtracks } { incr i } {
		if { $trackstowrite($i,stat) == 0 } {
			# now search a free in lower half
			for { set j 0 } { $j < $nrtracks } { incr j } {
				if { $tracksavailable($j,stat) == -1 } {
					set trackstowrite($i,stat) -1 
					set tracksavailable($j,track) \
						$trackstowrite($i,track)	
					set tracksavailable($j,stat) 0 
					break
				}
			}
		}
	}

	# add to tracks that are before the insertion-point 500
	# to ensure that later sorting will move them to the end.
	# this way all new tracks are inserted after the insertion
	# point selected via the optionmenu 
	for { set i 0 } { $i < $nrtracks } { incr i } {

		if { $trackstowrite($i,stat) > $insertafter } {
			set trackstowrite($i,stat) \
				[expr $trackstowrite($i,stat) + 500]
		} 
	}

	# move tracks selected to upper half
	set low -1 
	while { $low != 999 } {
	# search lowest number > 0
	set low 999
	set idx -1
	for { set i 0 } { $i < $nrtracks } { incr i } {
		set stat $tracksavailable($i,stat) 
		if { $low > $stat && $stat > 0 } {
			set low $stat
			set idx $i
		}
	}

	# we found a track to move up
	if { $idx != -1 } {
		# search first empty slot 
		set idx2 -1
		set count 1
		for { set i 0 } { $i < $nrtracks } { incr i } {
			set stat $trackstowrite($i,stat)
			if { $stat == -1 } {
				set idx2 $i
				break;
			} else {
				incr count
			}
		}
		
		# found a slot - move track
		if { $idx2 != -1 } {
			set trackstowrite($idx2,stat) $count
			set trackstowrite($idx2,track) \
				$tracksavailable($idx,track)	
			set tracksavailable($idx,stat) -1
		}
	}
	}

	# sort tracks in upper half
	# covert array to list -> sort list -> convert back to array
	set sortlist {}
	for { set i 0 } { $i < $nrtracks } { incr i } {

		set stat $trackstowrite($i,stat)
		if { $stat <= 0 } {
			continue
		}
		set trk $trackstowrite($i,track)
		set tmpstr [format "%03d-%03d" $stat $trk]
		lappend sortlist $tmpstr
		set trackstowrite($i,stat) -1
	}
	set sortedlist [lsort $sortlist]
	set i 0
	set tracksum 0
	foreach ele $sortedlist {
		scan $ele "%03d-%03d" stat trk
		set trackstowrite($i,stat) [expr $i + 1] 
		set trackstowrite($i,track) $trk	
		if { $trackinfolist($trk,type) == "Data" } {
			# data-track -> use different blocksize
			set ffsize [file size $trackinfolist($trk,fname)]
			incr tracksum [expr ($ffsize/2048)*2352]
		} else {
			# audio-track
			incr tracksum [file size $trackinfolist($trk,fname)]
		}
		incr i
	}

	# update number-of-selected-tracks
	set nrtowrite [llength $sortedlist]
	$wroot.mid.l.17.imgselval config -text $nrtowrite 

	# update size-of-selected-tracks
	# Take in account the 2 sec pause between each track!!!

	# Pausetime, between each track 2 sec (created by the cdwriter
	# itself due the Track-At-Once-Mode of cdwrite.
	if { $nrtowrite == 1 || $nrtowrite == 0 } {
		set pausetime 0 
	} else {
		set pausetime [expr ($nrtowrite-1)*2*75*2352]
	}

	set time [convertframes2time [expr ($tracksum+$pausetime)/2352]]
 	set mb [expr (($tracksum+$pausetime)/1024/1024)]
	$wroot.mid.l.18.wrtsizeval config -text "$time ( $mb MB )" 

 
	# redraw track-view
	destroy $f.cd.all 
	frame $f.cd.all
	set nrdisplayed [fillwritesel $w $f.cd.all $nrtracks 0]
	pack $f.cd.all

	destroy $f.hd.all 
	frame $f.hd.all
	fillwritesel $w $f.hd.all $nrtracks 1
	pack $f.hd.all

	# delete content of optionmenu
	foreach i [$w.opt entries] {
		$w.opt del "$i"
	}

	# fill it again
	$w.opt add command "after last track"
	$w.opt add command "at beginning"
	for { set i 1 } { $i <= $nrdisplayed } { incr i } {
		$w.opt add command "after track $i"
	}

	set need_refresh 0

	update
}


# Called by the Select-All-Button in the Select-Tracks-Menu 

proc wrt_sel_all_tracks { f nrtracks } {
global tracksavailable

	for { set i 0 } { $i < $nrtracks } { incr i } {
		if { $tracksavailable($i,stat) == 0 } {
			# simulate button-press in lower half
			selwritetrack $f.$i.sel $i 1 $nrtracks 
		}	
	} 
}


# Called by the Select-None-Button in the Select-Tracks-Menu 

proc wrt_sel_no_tracks { f nrtracks } {
global tracksavailable

	for { set i 0 } { $i < $nrtracks } { incr i } {
		if { $tracksavailable($i,stat) > 0 } {
			# simulate button-press in lower half
			selwritetrack $f.$i.sel $i 1 $nrtracks 
		}	
	}
}


# Do the writing of the tracks

proc writeaudiodoit { w wold } {
global CDWRITE CDRECORD
global XCDR_DEST_WRITER_DEV
global XCDR_DEST_WRITER_MODE
global XCDR_DEST_WRITER_SPEED
global IMAGE_PART
global IMAGE_MNTPNT
global EJECT DUMMY PADDATA SWABAUDIO DEBUG
global XCDR_SUB_VIEW SUB_VIEW
global cd_type
global audionrtracks
global trackinfolist
global trackstowrite

# This variables must be global, because the fileevent-command
# can't handle local-variables
global pipe tmpw waitforready barmult barsum percent acttrk actfull

        # set default view
        if { $SUB_VIEW == "" } {
                set SUB_VIEW $XCDR_SUB_VIEW
        }

	set nrtowrite 0
	set tracksum 0
	for { set i 0 } { $i < $audionrtracks } { incr i } {
		if { $trackstowrite($i,stat) > 0 } {
			set trk $trackstowrite($i,track)
			if { $trackinfolist($trk,type) == "Data" } {
				# data-track -> use different blocksize
				set ffsize [file size $trackinfolist($trk,fname)]
				incr tracksum [expr ($ffsize/2048)*2352]
			} else {
				# audio-track
				incr tracksum [file size $trackinfolist($trk,fname)]
			}
			incr nrtowrite
		} 
	}

        # Pausetime, between each track 2 sec (created by the cdwriter
        # itself due the Track-At-Once-Mode of cdwrite.
        if { $nrtowrite == 1 || $nrtowrite == 0 } {
                set pausetime 0 
        } else {
                set pausetime [expr ($nrtowrite-1)*2*75*2352]
        }
	set mb [expr (($tracksum+$pausetime)/1024/1024)]

	# Any tracks selected?
        if { $nrtowrite == 0 } {
                Msg_NoTracksSel .notrk .root
                return
        }

	# Convert space from MB to minutes
	set needframes [expr $mb*1024*1024/2352]
	set needmin [expr $needframes/(60*75)]

	# Check if enough space on CDR is free
        if { $needmin >= $cd_type } {
                set stat [Msg_CDoverrun .cdor .root]
                if { $stat == 0 } {     ;# Abort
                        return
                }
        }

	set waitforready 0

	# for cdwrite(old)
	#set cdwdev [ convertCDnametogendevice $XCDR_DEST_WRITER_DEV ]
	set cdwdev [ convertCDnametoscsidevnr $XCDR_DEST_WRITER_DEV ]

	# Construct command-line for cdwrite
#	set cmd "$CDWRITE -v -t -s $XCDR_DEST_WRITER_SPEED -D $cdwdev"
#	if { $EJECT == 1 } {
#		set cmd "$cmd -e"
#	} 
#	if { $DUMMY == 1 } {
#		set cmd "$cmd -y"
#	} 
#	if { $XCDR_DEST_WRITER_MODE != "Autodetect" } {
#		if { $XCDR_DEST_WRITER_MODE == "Philips/Kodak/IMS" } {
#			set cmd "$cmd --philips"
#		}
#		if { $XCDR_DEST_WRITER_MODE == "HP" } {
#			set cmd "$cmd --hp"
#		}
#		if { $XCDR_DEST_WRITER_MODE == "Yamaha" } {
#			set cmd "$cmd --yamaha"
#		}
#		if { $XCDR_DEST_WRITER_MODE == "Sony" } {
#			set cmd "$cmd --sony"
#		}
#	}
#	if { $PADDATA == 1 } {
#		set cmd "$cmd -P"
#	} 

        # Construct command-line for cdrecord
        set cmd "$CDRECORD -v speed=$XCDR_DEST_WRITER_SPEED dev=$cdwdev"

	if { $DEBUG > 2 } {
		# print debug 
		set cmd "$cmd -debug"
	}
	if { $DEBUG > 3 } {
		# very verbose
		set cmd "$cmd -V"
	}

        if { $EJECT == 1 } {
                set cmd "$cmd -eject"
        } 
        if { $DUMMY == 1 } {
                set cmd "$cmd -dummy"
        } 
        if { $XCDR_DEST_WRITER_MODE != "autodetect" } {
                # must be dynamic! Call cdrecord driver=help for a
                # driver-list. Setup is doing that 
                set cmd "$cmd driver=$XCDR_DEST_WRITER_MODE"
        }
        if { $PADDATA == 1 } {
                set cmd "$cmd -pad"
        } 
        if { $SWABAUDIO == 1 } {
                set cmd "$cmd -swab"
        } 

	# set cmd "$cmd -audio"

	set datafirst 0
	# Loop through all tracks
	for { set i 0 } { $i < $nrtowrite } {incr i } {

		# get index to track
		set trk $trackstowrite($i,track)
		set fname $trackinfolist($trk,fname)
		set iname $trackinfolist($trk,iname)
		set trtype $trackinfolist($trk,type)
 
		if { $trtype == "Data" } {
			set type "-data" 
			set datafirst $i

			# check if image is truncated
			set filesize [ file size $fname]
			set isosize [ getisosize $fname]
			if { $filesize < $isosize } {
				set stat [Msg_TruncatedDataTrack .trimg .root]
 				if { $stat == 0 } {     ;# Abort
 		                       return
 		               	}
			}	
		} else {
			set type "-audio"
		}
		# Get Preemphasis from description-file
		set nfoarray [loadfile2list $iname]
		set preemp [extractcolonstr [lindex $nfoarray 7]]
		if { $preemp == "1" } {
			set pre "-preemp"
		} else {
			set pre "-nopreemp"
		}

		set cmd "$cmd $type $pre $fname"
	}

	# Check if there is the data-track (if any) on the right position
	if { $datafirst != 0 } {
		set stat [Msg_DataNotFirst .dnf .root]
        	if { $stat == 0 } {     ;# Abort
        	        return
        	}
	}

        # Prompt user for inserting CDR
        set stat [Msg_InsertCDR .inscdr .root]
        if { $stat == 1 } {     ;# Cancel
                return
        }

	log $w "Write-Tracks: writing $nrtowrite tracks, dummy=$DUMMY" 

	log $w "Executing: $cmd"

	# output debug-information
	if { $DEBUG > 0 } {
		puts "Debug:call: $cmd"
	}

        # create extended command-line
        set cmd [execshell $cmd]

        # create new window
        set oldf [createsubwindow $w .root 1 "Write Tracks"]

        # create menu
        frame $w.menu -bd 1 -relief raised
        menubutton $w.menu.file -menu $w.menu.file.m -text "File" \
                -font "-*-helvetica-medium-r-normal-*-10-*-*-*-*-*-*-*"
        menu $w.menu.file.m
        $w.menu.file.m add command -label "Save Process-Output" \
                -font "-*-helvetica-medium-r-normal-*-10-*-*-*-*-*-*-*" \
                -command "saveoutputbuffer .savebuf $w $w.t.t cdrecord.out" 
        menubutton $w.menu.view -menu $w.menu.view.m -text "View" \
                -font "-*-helvetica-medium-r-normal-*-10-*-*-*-*-*-*-*"
        menu $w.menu.view.m
        $w.menu.view.m add radio -label "Normal" -value 0 -variable SUB_VIEW \
                -font "-*-helvetica-medium-r-normal-*-10-*-*-*-*-*-*-*" \
                -command "changedowriteview $w 0"
        $w.menu.view.m add radio -label "Extended" -value 1 -variable SUB_VIEW \
                 -font "-*-helvetica-medium-r-normal-*-10-*-*-*-*-*-*-*" \
                -command "changedowriteview $w 1"
        $w.menu.view.m add radio -label "Small" -value 2 -variable SUB_VIEW \
                -font "-*-helvetica-medium-r-normal-*-10-*-*-*-*-*-*-*" \
                -command "changedowriteview $w 2" 
        pack $w.menu.file -side left
        pack $w.menu.view -side left
        pack $w.menu -fill x -expand 1

	set pipe [open "|$cmd" r+]
	
        frame $w.1 
        label $w.1.l -text "Writing Tracks... Please wait"
        label $w.1.l2 -text ""
        tixMeter $w.1.c -height 20 -width 300
        pack $w.1.l $w.1.l2 $w.1.c -padx 10 -pady 10
        pack $w.1

        # prepare progressbar calculations
        set barmult [expr 1.0/$nrtowrite]
        set barsum 0 
	set percent 0

        # alternative "small" view 
        frame $w.2
        tixMeter $w.2.c -height 10 -width 100
        button $w.2.cancel -text "Cancel" -command {
                set waitforready 2 
                catch { close $pipe }
        }
        pack $w.2.c $w.2.cancel -side left

        tixButtonBox $w.1.box -orientation horizontal
        $w.1.box add cancel -text "Cancel" -command {
		set waitforready 2 
		catch { close $pipe }
	}
	pack $w.1.box -fill x -expand 1

	# create an optional text-widget to view any output generated by
        # subprocess
        frame $w.t      
        text $w.t.t -height 4 -width 36 -yscrollcommand "$w.t.scr set"
        scrollbar $w.t.scr -command "$w.t.t yview"
        pack $w.t.scr $w.t.t -side right -fill y
        pack $w.t
	
	set tmpw $w
	set acttrk 0
	set actfull 1
	update
	fileevent $pipe readable {
		global pipe tmpw waitforready out percent barmult barsum 
		global acttrk actfull DEBUG
		set out [gets $pipe] 
		set doneevent 0

		# output debug-information
		if { $DEBUG > 0 } {
			puts "Debug:cdrecord: $out"
		}

		# no more data? process finished
		if { [eof $pipe] } { 
			# catch exit-status of cdrecord
			set cdrecord_ok [ getchildstatus [ catch { close $pipe } ]]
			if { $DEBUG > 0 } {
				puts "Debug:cdrecord terminated - code: $cdrecord_ok"
			}

                        if { $acttrk != -1 } {  
                                # operation finished
                                if { $cdrecord_ok == 0 } {
                                        set waitforready 1 
                                } else {
                                        set waitforready 4
                                }
                        } else {
                                # cdrecord does not support this device
                                set waitforready 3 
                        }       
			set doneevent 1
		}

                # does cdrecord support this device?
                if { [string first ": Sorry," $out] != -1 } {
                        set idx [string first ":" $out]
                        set idx2 [string last "on" $out]
                        # extract error-message
                        set text [string trim [string range $out [expr $idx+1] [expr $idx2-1]]]
                        $tmpw.1.l2 configure -text "$text"
                        # mark as cdrecord-abort
                        set acttrk -1 
                        # show we are done for this event
                        set doneevent 1
                }
                if { [string first "Last chance to quit" $out] != -1 } {
                        # skip that 9 second wait string
                        set doneevent 1
                }

                # Starting a new track?
                if { [string first "written." $out] != -1 } {
                        # we got a write-progress info
			set out [stripstring $out]
                        set perinfo [split $out ":"]
                        set perinfo2 [string trim [lindex $perinfo 1]]
                        set perinfo3 [split $perinfo2 " "]
                        set track [lindex [lindex $perinfo 0] 1]
			set ttrack [string trimleft $track "0"]
			if { [string trim $ttrack] == "" } {
				set ttrack 0
			}
                        set done [lindex $perinfo3 0]
                        set full [lindex $perinfo3 2]
			set barsum [expr ($ttrack - 1) * (100.0 * $barmult)] 

                        if { [lindex $perinfo3 1] != "of" } {
                                # we got a line not showing 
                                # how big the track is
                                # assume full cd.. (for now)
                                set full 650
                        }
                
                        set acttrk $track
                        set actfull $full
			set percent 0
                        $tmpw.1.l2 configure -text "Track $track: $full MB"
                        set doneevent 1
                 }

		# do we get a simple megabytes-written value? 
		# works only for cdrecord-1.6a9 and above
		if { [string range $out 0 4] == "Track" && \
		     [string first "fifo" $out] != -1 && $acttrk > 0 } {
			set perinfo [split $out ":"]
			set done1 [string trim [lindex $perinfo 1]]
			set done2 [split $done1 " "]
			set done [string trim [lindex $done2 0]]
			# get also the fifo value
			if { [string trim [lindex $done2 5]] == "(fifo" } {
				set fifo1 [string trim [lindex $done2 7]]
				set fifo2 [split $fifo1 "%"]
				set fifo [string trim [lindex $fifo2 0]]
			}
			# saveguard, should the expr command fail
			set percent 0
			catch { set percent [expr $done*100/$actfull] }
			drawbar $tmpw.1.c [expr ($percent * $barmult) + $barsum] 
			drawbar $tmpw.2.c [expr ($percent * $barmult) + $barsum] 
			set doneevent 1
		}

                # Fixation-output
                if { [string first "Fixating..." $out] != -1 } {
                        $tmpw.1.l2 configure -text "Fixating..."
                        set doneevent 1
                }

		# reload-message
		if { [string first "Re-load" $out] != -1 } {
			$tmpw.1.l2 configure -text "Waiting for medium..."
			Msg_ReloadDisk .rld .root 

			# simulate return press
			puts $pipe ""; flush $pipe 	
			set doneevent 1
		}

                # all special text is parsed - add the normal stuff
                # to text-window and scroll to its end
                if { $doneevent == 0 } {
                        $tmpw.t.t insert end "$out\n"
                        $tmpw.t.t see end
                }

	}	

        # redraw window with correct appearance
        changedowriteview $w $SUB_VIEW 

	tkwait variable waitforready

	#we are done with reading now...
	if { $waitforready == 1 } {
		$w.1.l configure -text "Write Tracks completed!"
		$w.1.l2 configure -text ""
		drawbar $tmpw.1.c 100
                drawbar $tmpw.2.c 100
		log $w "Write-Tracks: OK"
        } elseif { $waitforready == 3 } {
                $w.2.cancel config -bg red
                log $w "CD-Recorder not supported"      
        } elseif { $waitforready == 4 } {
                $w.1.l configure -text "Some error occured!!!"
                $w.1.l2 configure -text "Please check process-output"
                $w.2.cancel config -bg red
                log $w "Write-Image: Some error occured"
	} else {
		$w.1.l configure -text "Write Tracks aborted!"	
		$w.1.l2 configure -text ""
		$w.2.cancel config -bg red
		log $w "Write-Tracks: aborted"
	}

        $w.1.box.cancel configure -text "Ok" \
                -command "destroysubwindow $w .root {$oldf} 1" -width 5
        $w.2.cancel configure -text "Ok" \
                -command "destroysubwindow $w .root {$oldf} 1" -width 5
	sound 1

	# Clear the global variables
	unset pipe tmpw waitforready barsum barmult 

	# wait until window is destroyed
        tkwait window $w
}


# Dialog for verify burned Data-CD 

proc verify2imagedialog { new } {

	if { [Msg_InsertBurnedCDR .dlg .root] == 1 } {
		return
	}
	verifyimagedialog $new 
}


# Dialog for verify burned Mixed-Mode-CD

proc verify2datadialog { new } {

	if { [Msg_InsertBurnedCDR .dlg .root] == 1 } {
		return
	}
	verifydatatrackdialog $new 
}


# Quick CD->CD dump. Works only for pure ISO9660-Data CDs.
# Use only at own risk
 
proc quickcopydialog { w } {
global XCDR_DEST_WRITER_DEV
global XCDR_DEST_WRITER_SPEED
global XCDR_DATA_SOURCE_CDROM
global TMP_DEST
global cd_type
global DUMMY EJECT PADDATA
global XCDR_DUMMY XCDR_EJECT XCDR_PADDATA

	log $w "entering Quick CD-Copy"
	
	set stat [Msg_QuickCopyWarning .qwarn .root]
	if { $stat == 1 } {	;# Cancel
		return
	}

	if { [ info exists cd_type ] == 0  } {
		set cd_type 74
	}
	if { $DUMMY == "" } {
		set DUMMY $XCDR_DUMMY
	}
	if { $EJECT == "" } {
		set EJECT $XCDR_EJECT
	}
	if { $PADDATA == "" } {
		set PADDATA $XCDR_PADDATA
	}

      	set blkname [ convCD2block data ] 
      	set blkname2 [ convertCDnametoblkdevice $XCDR_DEST_WRITER_DEV ]

	# Do we have 2 different CD-Devices?
	if { $blkname == $blkname2 } {
		Msg_Need2CDRoms .ntwocd .root 
		return
	}

        if {[checkifready .root data] == 1} {
                return
        }
        
        if {[checkifaudio $blkname] == 1 || [checkifmixedmode $blkname] == 1 ||
	    [checkifiso $blkname] == 0 } {
                Msg_NotPureIso .ndcd .root 
                return
        }

	set nrblocksiso [expr [ getisosize $blkname ]/2048]
	set nrblocksnoniso [expr [ getnonisosize $blkname ]/2048]
        # experimental feature
	if { $nrblocksnoniso > 0 } {
		if { [expr ($nrblocksiso*100)/$nrblocksnoniso] < 95 } {
			set isosz [expr $nrblocksiso/512]
			set tocsz [expr $nrblocksnoniso/512]
			set stat [Msg_NoQuickHFS .hfsiso .root $isosz $tocsz]
			if { $stat == 1 } {	;# Cancel
				return
			}
		}
	}

        # Draw header-bar
        label $w.l -text "QUICK CD-COPY" -relief sunken -borderwidth 2 -anchor c
        pack $w.l -fill x -expand 1 -ipady 10 -pady 5

	# Create Devices-Setup
	tixLabelFrame $w.3 -label "Devices-Setup"
	set w1 [$w.3 subwidget frame]
	pack $w.3 -expand 1 -fill x 

        frame $w1.1
        tixLabelWidget $w1.1.readl -label "Read from : " \
                -options {label.width 25 label.anchor e}
        message $w1.1.readt -anchor w -width 300 -relief groove
        $w1.1.readt configure -text $XCDR_DATA_SOURCE_CDROM

	tixForm $w1.1.readl -left %0
        tixForm $w1.1.readt -left %32 -right %80

        frame $w1.3
        tixLabelWidget $w1.3.writel -label "Write to : " \
                -options {label.width 25 label.anchor e}
        message $w1.3.writet -anchor w -width 300 -relief groove
        $w1.3.writet configure -text $XCDR_DEST_WRITER_DEV
	#label $w1.3.spd -text "Speed: $XCDR_DEST_WRITER_SPEED x"

	set tmpval $XCDR_DEST_WRITER_SPEED
	unset XCDR_DEST_WRITER_SPEED
	tixOptionMenu $w1.3.spd -variable XCDR_DEST_WRITER_SPEED \
		-options { label.width 7 menubutton.width 1 } \
		-label "Speed: "	
	$w1.3.spd add command "0"
	$w1.3.spd add command "1"
	$w1.3.spd add command "2"
	$w1.3.spd add command "4"
	$w1.3.spd add command "6"
	$w1.3.spd add command "8"
	if { $tmpval != "" } {
		catch { $w1.3.spd configure -value $tmpval }
	}

	tixForm $w1.3.writel -left %0
        tixForm $w1.3.writet -left %32 -right %80
        tixForm $w1.3.spd -left %82

        pack $w1.1 $w1.3 -side top -expand 1 -fill x

	#--------------------------------------------------

	# create a left and right frame
        frame $w.mid
        frame $w.mid.l
        frame $w.mid.r
        pack $w.mid
        tixForm $w.mid.l -left %0 -right %63
        tixForm $w.mid.r -left %65 -right %100

	frame $w.mid.l.6
	tixLabelWidget $w.mid.l.6.type -label "CD-Recordable-Type: " \
		-options { label.width 25 label.anchor e }
	radiobutton $w.mid.l.6.b1 -text "74 min ( 650 MB )" -variable cd_type -value 74

	pack $w.mid.l.6 -fill x -expand 1 -padx 10 
	pack $w.mid.l.6.type $w.mid.l.6.b1 -side left

	frame $w.mid.l.5
	tixLabelWidget $w.mid.l.5.type \
		-options { label.width 25 label.anchor e }
	radiobutton $w.mid.l.5.b2 -text "63 min ( 553 MB )" -variable cd_type -value 63

	pack $w.mid.l.5 -fill x -expand 1 -padx 10 
	pack $w.mid.l.5.type $w.mid.l.5.b2 -side left

	set imgspace [expr [ getisosize $blkname ]/1024/1024]
	set imglabel "[getisolabel $blkname]"
	set TMP_DEST "quick"

	frame $w.mid.l.1
	tixLabelWidget $w.mid.l.1.imgsize -label "CD Size : " \
		-options { label.width 25 label.anchor e }
	message $w.mid.l.1.imgsizeval -width 150 -relief sunken -borderwidth 1 \
		-text "$imgspace MB"

	pack $w.mid.l.1 -fill x -expand 1 -padx 10 -pady 10
	pack $w.mid.l.1.imgsize -side left 
	pack $w.mid.l.1.imgsizeval -expand 1 -fill x -side left

	frame $w.mid.l.16
        tixLabelWidget $w.mid.l.16.imglabel -label "CD-ISO9660-Label : " \
                -options { label.width 25 label.anchor e }
        message $w.mid.l.16.imglabelval -width 150 -relief sunken \
                -borderwidth 1 -text "$imglabel"

        pack $w.mid.l.16 -fill x -expand 1 -padx 10 -pady 10
        pack $w.mid.l.16.imglabel -side left 
        pack $w.mid.l.16.imglabelval -expand 1 -fill x -side left


	tixLabelFrame $w.mid.r.4 -label "Additional Options"
	set w1 [$w.mid.r.4 subwidget frame]
	pack $w.mid.r.4 -expand 1 -fill x -padx 30 -pady 10

        checkbutton $w1.b1 -variable DUMMY -anchor w \
                -text "Simulation-Write"
        pack $w1.b1 -expand 1 -fill x -padx 10 

        checkbutton $w1.b2 -variable EJECT -anchor w \
                -text "Eject after write"
        pack $w1.b2 -expand 1 -fill x -padx 10 

        checkbutton $w1.b3 -variable PADDATA -anchor w \
                -text "Pad Data-Track"
        pack $w1.b3 -expand 1 -fill x -padx 10 

        # ----------------------------

        canvas $w.20 -height 0 -width 30 -relief sunken -borderwidth 1
        pack $w.20 -pady 10 -fill x -expand 1


        button $w.start -text "Write CD" \
                -command "writeimagedoit .write_doit"
        button $w.start2 -text "Verify burned CD" \
                -command "verifyimagedoit .write_doit data"
        pack $w.start $w.start2 -pady 30 -side left -expand 1

}
		

