/* volname.c copyright 1996 Andrew Tefft

   version 1.0    1/19/96    first public release

*/

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/uio.h>
#include <unistd.h>
#include <errno.h>
#include <sys/param.h>
#ifdef __linux__
#include <linux/cdrom.h>
#include <mntent.h>
#else
#include <sys/cdio.h>
#endif

#include "iso9660.h"

#ifdef __linux__
static FILE *_fs_fp;
#endif

extern int errno;
char *mode();

/* the struct in iso_primary_descriptor is the first thing on the disk,
   after 16 2048-byte blocks of zeroes. */

main( int argc, char *argv[]) {
  int file;
  FILE *fstabfile;
  int audio_id;
  struct iso_primary_descriptor buf;
  struct cdrom_tocentry entry;
  struct cdrom_subchnl sc;
  char dev[MAXPATHLEN];
  int i;

#ifdef __linux__
  struct mntent *ent;
#endif

  if (argc == 1 || (argc == 2 && !strcmp( argv[1], "-id"))) {
    fprintf(stderr, "usage: %s [-id ] device [ device ... ]\n",argv[0]);
    exit (0);
  }

  audio_id = !(strcmp(argv[1],"-id"));
  entry.cdte_track = 0;
  entry.cdte_format = CDROM_MSF;
  i=argc-1;

  while (i--) {
    if (i==0 && audio_id) continue;
    
    strncpy(dev, argv[i+1], MAXPATHLEN);
    dev[MAXPATHLEN]='\0';

    if ((argc > 2 && !audio_id ) || (argc > 3 && audio_id)) 
      printf("%s: ",dev);

    if ((file = open(dev, O_RDONLY)) == -1) {
      perror(dev);
      continue;
    }
    
    if (-1 == ioctl(file, CDROMREADTOCENTRY, &entry)) {
      perror(argv[0]);
      continue;
    }
    
    if (ioctl (file, CDROMSUBCHNL, &sc)) {
      printf("No CD in drive\n");
      continue;
    }
    
    if (!( entry.cdte_ctrl & CDROM_DATA_TRACK) ) {
      printf("Audio CD (%s)", mode(&sc));
      if (audio_id)
	tracks(file);
      printf("\n");
      continue; 
    }
    
    
    lseek(file, (off_t) 2048*16, SEEK_SET);
    read(file,  &buf, 2048);
    
    printf(buf.volume_id);

#ifdef __linux__    
    if ( (_fs_fp=setmntent("/etc/mtab", "r")) != NULL ) {
      while (( ent = getmntent(_fs_fp)) != NULL) {
	if (!strcmp(ent->mnt_fsname, dev) ) 
	  printf(" mounted on %s",ent->mnt_dir);
      }
      endmntent(_fs_fp);
    }
#endif
    putchar('\n');
    
  }
  exit(0);
}

char *mode(struct cdrom_subchnl *sc) {
char stat[128];
    switch (sc->cdsc_audiostatus) {
    case CDROM_AUDIO_PLAY:
      sprintf(stat,"playing, trk %d, %d:%02d",
	      sc->cdsc_trk,
	      sc->cdsc_reladdr.msf.minute,
	      sc->cdsc_reladdr.msf.second);
      return stat;
      break;
    case CDROM_AUDIO_PAUSED:
      sprintf(stat, "paused, trk %d, %d:%02d",
	      sc->cdsc_trk,
	      sc->cdsc_reladdr.msf.minute,
	      sc->cdsc_reladdr.msf.second);
      return stat;
      break;
    case CDROM_AUDIO_COMPLETED:
    case CDROM_AUDIO_NO_STATUS:
      return "stopped";
      break;
    case CDROM_AUDIO_INVALID:
      return "invalid";
      break;
    default:
      return "dunno!";
    }
   }

/* print the starting times of all tracks. this would uniquely identify
   the cd with pretty good accuracy. Assumes the device *is* a valid cd */
tracks(int device) {
  struct cdrom_tocentry entry;
  struct cdrom_tochdr hdr;
  int i;

/* get the number of tracks: */
  ioctl(device, CDROMREADTOCHDR, &hdr);

/*  printf("%d tracks ",hdr.cdth_trk1); */

  printf(" ");
  for (i=1; i<=hdr.cdth_trk1; i++) {
    entry.cdte_track=i;
    entry.cdte_format = CDROM_MSF;

    ioctl(device, CDROMREADTOCENTRY, &entry);
    printf("%x", entry.cdte_addr.msf.minute * 60 * 75 +
	   entry.cdte_addr.msf.second * 75 +
	   entry.cdte_addr.msf.frame);
    if (i != hdr.cdth_trk1) putchar(':');
  }
}

