#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/uio.h>
#include <unistd.h>
#include <errno.h>
#include <sys/param.h>
#ifdef __linux__
#include <linux/cdrom.h>
#else
#include <sys/cdio.h>
#endif

void eject (char *);

main(int argc, char *argv[]) {
  int i;

  if (argc == 2 && !strcmp(argv [1], "-h")) {
    fprintf(stderr,"usage: %s [ device ... ]\n",argv[0]);
    exit(0);
  }

  if (argc == 1) 
    eject("/dev/cdrom");
  
  else
    for (i=1; i<argc; i++) 
      eject(argv[i]);
}

void eject(char *dev) {
int file;
if ((file = open(dev,O_RDONLY)) == -1) {
  perror(dev);
  return;
}

if (-1 == ioctl(file, CDROMEJECT)) 
  perror(dev);
return;
}
