#include <scsilib.h>


int main(int argc, char **argv)
{
    struct scsi_fd	*h = NULL;

    if(argc != 2) {
	fprintf(stderr, "Missing argument.\n");
	exit(1);
    }

    if(!(h = scsi_open_dev(argv[1], 0, 0))) {
	fprintf(stderr, "Could not open %s - %m\n", argv[1]);
	exit(1);
    }


    if(!(scsi_TEST_UNIT_READY(h, 1024))) {
	fprintf(stdout, "*** Not ready.\n");
	goto cleanup;

    }

    fprintf(stdout, "Device is ready.\n");

cleanup:


    if(h)
	scsi_close_dev(h);

    exit(0);
}
