#include <scsilib.h>


int main(int argc, char **argv)
{
    struct scsi_fd	*h = NULL;
    int	    flag = 0;
    u32	    timeout = ( 10 * 1000 );


    if(argc != 3) {
	fprintf(stderr, "Missing argument.\n");
	exit(1);
    }

    if(strcmp(argv[2], "start") == 0)
	flag |= F_START;
    else if(strcmp(argv[2], "stop") == 0)
	flag |= F_STOP;
    else {
	fprintf(stderr, "Second argument must be either stop or start.\n");
	exit(1);
    }

/*    flag |= F_LOEJ|F_IMMED; */

    if(!(h = scsi_open_dev(argv[1], 0, 0))) {
	fprintf(stderr, "Could not open %s - %m\n", argv[1]);
	exit(1);
    }

    scsi_set_timeout(h, timeout);

    if(!(scsi_START_STOP_UNIT(h, flag))) {
	if(errno) {
	    fprintf(stderr, "START_STOP_UNIT Failed - %m\n");
	    goto cleanup;
	}

	if(h->hdr.masked_status != GOOD)
	    goto cleanup;

	fprintf(stderr, "START_STOP_UNIT Choked.\n");
	goto cleanup;
    }

    fprintf(stdout, "Device has been %s.\n", flag & F_START ? "started" : "stopped");

cleanup:
    if(h->hdr.masked_status)
	scsi_sense_dump(stderr, (void *)h->hdr.sbp);

    if(h)
	scsi_close_dev(h);

    exit(0);
}
