#include <scsilib.h>

#include <getopt.h>

struct option long_options[] =
{
    {"timeout",	    1,  NULL,   't'},
    {"help",	    0,  NULL,	'h'},
    {NULL, 0, NULL, 0}
};

static char *short_options = "t:h";



int main(int argc, char **argv)
{
    struct scsi_fd  *h = NULL;
    char	    *dev;
    char	    opt;
    int		    i;

    int	    timeout = ( 1000 * 1 );
    int	    flag = 0;

    u32	    buffer[256] = { [0 ... 255] = 0 };

    struct scsi_buffer_header *bp;


    while(1) {
	opt = getopt_long (argc, argv,short_options,long_options, &i);
        if(opt == -1)
	    break;

	switch(opt) {
	    case('t'):
		timeout = strtoul(optarg, NULL, 0);
		if(errno) {
		    fprintf(stderr, "Could not parse timeout - %m\n");
		    exit(1);
		}

		timeout *= 1000;

		break;

	    case('h'):
		fprintf(stdout, 
"Usage:      read_buffers [options] device

options:    --timeout=N       Set timout for the command. [10 sec.]
            --help            This text.
");
	    exit(1);

	    case('?'):
	    default:
		fprintf(stderr, "Bad option.\n");
		exit(1);
	}
    }

    if(optind == argc) {
	fprintf(stderr, "No device name specified.\n");
	exit(1);
    }

    if(optind < (argc - 1)) {
	fprintf(stderr, "Too many arguments.\n");
	exit(0);
    }

    dev = argv[optind];

    if(!(h = scsi_open_dev(dev, 0, 0))) {
	fprintf(stderr, "Could not open %s - %m\n", argv[1]);
	exit(1);
    }

    scsi_set_timeout(h, timeout);

/*
    if(!(scsi_set_sg_reserve_size(h, ((tlen) ? tlen : 256) * h->sector_size))) {
	fprintf(stderr, "Could not set the kernel buffer size - %m\n");
	goto cleanup;
    }
*/

    for(i = 0; i < 255; i++) {
	if(!(scsi_READ_BUFFER(h, BUFFER_DESCRIPTOR, i, 0, &buffer[i], sizeof(u32)))) {
	    if(errno) {
		fprintf(stderr, "READ BUFFER %i failed - %m\n", i);
		goto cleanup;
	    }

	    continue;
	}

	flag = 1;
    }

    h->hdr.masked_status = 0;

    if(flag) {
	fprintf(stdout, "Buffer list for %s:\n", argv[1]);
	fprintf(stdout, "-------------------------\n");
	fprintf(stdout, "         size  align\n");

	for(i = 0; i < 256; i++) {
	    if(buffer[i]) {
		bp = (void *)(&buffer[i]);
		fprintf(stdout, "%02x: 0x%06x  0x%02x\n", i, U24TOS(bp->capacity), bp->offset_boundary);
	    }
	}
    } else {
	fprintf(stdout, "No buffers found.\n");
    }

cleanup:

    if(h->hdr.masked_status == CHECK_CONDITION) {
	scsi_cdb_dump(stderr, (void *)h->hdr.cmdp);
	scsi_sense_dump(stderr, h->hdr.sbp);
    }

    if(h)
	scsi_close_dev(h);

    exit(0);
}
