#include <scsilib.h>


int main(int argc, char **argv)
{
    struct scsi_fd *h;
    struct scsi_capacity *cap = NULL;


    if(argc != 2) {
	fprintf(stderr, "Missing argument.\n");
	exit(1);
    }

    if(!(h = scsi_open_dev(argv[1], 0, 0))) {
	fprintf(stderr, "Could not open %s - %m\n", argv[1]);
	exit(1);
    }


    if(!(cap = scsi_READ_CAPACITY(h, 0, 0))) {
	fprintf(stdout, "*** Failed.\n");
	goto abt;
    }

    fprintf(stdout, "*** Sectors = 0x%x, sector size = 0x%x.\n", cap->capacity, cap->sector_size);

    free(cap);

abt:
    scsi_close_dev(h);

    exit(0);
}
