#include <scsilib.h>


int main(int argc, char **argv)
{
    struct scsi_fd	*h = NULL;
    struct scsi_inquiry *inq = NULL;
    struct scsi_vpd_page *sp = NULL;
    int			page = -1;


    if(argc != 2 && argc != 3) {
	fprintf(stderr, "Missing argument.\n");
	exit(1);
    }

    if(argc == 3) {
	page = strtol(argv[2], NULL, 0);

	if(page < 0 || page > 255) {
	    fprintf(stderr, "Page number out of range\n");
	    exit(1);
	}
    }

    if(!(h = scsi_open_dev(argv[1], 0, 0))) {
	fprintf(stderr, "Could not open %s - %m\n", argv[1]);
	exit(1);
    }

    if(page == -1) {
	if(!(inq = scsi_INQUIRY(h, NULL, 0, 0, 0))) {
	    fprintf(stderr, "INQUIRY failed - %m\n");
	    goto cleanup;
	}

	scsi_inquiry_text_print(stdout, inq);
    } else {
	if(!(sp = scsi_INQUIRY(h, NULL, 0, F_EVPD, page))) {
	    if(errno) {
		fprintf(stderr, "VPD page %d inquiry failed - %m\n", page);
		goto cleanup;
	    }

	    fprintf(stderr, "INQUIRY for VPD page %d failed.\n", page);

	    goto cleanup;
	}

	scsi_vpd_page_text(stdout, sp);
    }

cleanup:

    if(h->hdr.masked_status == CHECK_CONDITION)
	scsi_sense_dump(stderr, h->hdr.sbp);

    if(sp)
	free(sp);

    if(inq)
	free(inq);

    if(h)
	scsi_close_dev(h);

    exit(0);
}
