#include <scsilib.h>


int main(int argc, char **argv)
{
    struct scsi_fd	    *h = NULL;
    struct scsi_vpd_page    *sp = NULL;
    struct scsi_inquiry	    *inq = NULL;
    struct scsi_device_name *name = NULL;
    struct scsi_capacity    *cap = NULL;
    char		    *serial = NULL;
    int			    lss = 0;


    if(argc != 2) {
	fprintf(stderr, "Missing argument.\n");
	exit(1);
    }

    if(!(h = scsi_open_dev(argv[1], 0, 0))) {
	fprintf(stderr, "Could not open %s - %m\n", argv[1]);
	exit(1);
    }

    if(!(inq = scsi_INQUIRY(h, NULL, 0, 0, 0))) {
       fprintf(stderr, "INQUIRY failed - %m\n");
       goto cleanup;
    }

    if(!(name = scsi_get_device_name(inq))) {
	fprintf(stderr, "malloc() - %m\n");
	goto cleanup;
    }

    if(!(serial = scsi_get_serial_number(h))) {
	fprintf(stderr, "Coudl not get serial number for %s - %m\n", argv[1]);
	goto cleanup;
    }

    switch(inq->u.s1.peripheral_device_type) {
	case(TYPE_DIRECT):
	case(TYPE_WORM):
	case(TYPE_CDROM):
	case(TYPE_OPTICAL):
	case(TYPE_STORAGE):
	case(TYPE_RBC):
	    if(!(cap = scsi_READ_CAPACITY(h, 0, 0)))
		fprintf(stdout, "Failed to read device capacity.\n");
	
	    if(!(lss = scsi_get_long_sector_size(h, 0)))
		fprintf(stderr, "*** Failed to get the long sector size.\n");
    }

    fprintf(stdout, "Vendor       : '%s'\n", name->vendor);
    fprintf(stdout, "Product      : '%s'\n", name->product);
    fprintf(stdout, "Revision     : '%s'\n", name->revision);
    fprintf(stdout, "Serial number: '%s'\n", serial);
    fprintf(stdout, "Device type  :  %s\n", scsi_peripheral_device_type[inq->u.s1.peripheral_device_type]);

    if(cap) {
	fprintf(stdout, "Sector size  :  %d\n", cap->sector_size);
	fprintf(stdout, "Capacity     :  %d\n", cap->capacity);
    }

    if(lss)
	fprintf(stdout, "Long sector  :  %d\n", lss);


cleanup:

    if(h->hdr.masked_status == CHECK_CONDITION)
	scsi_sense_dump(stderr, h->hdr.sbp);

    if(serial)
	free(serial);

    if(sp)
	free(sp);

    if(h)
	scsi_close_dev(h);

    exit(0);
}
