/*
    Copyright 2002, 2003, Steve Thompson <stevet010@softhome.net>

    This software is free for non-commercial, non-military use.

    Included with this package, you should have received a file called
    `Licensing' which contains detailed terms of use.

*/

#include <scsilib.h>


int scsi_VERIFY_10(struct scsi_fd *fd, void *buf, u32 lba, u16 len, u32 flags)
{
    struct scsi_cdb *	cdb = NULL;

    assert(fd);

    if(!buf) {
	errno = EINVAL;
	return(0);
    }

    if(!fd->sector_size) {
	errno = EINVAL;
	return(0);
    }


    if((len * fd->sector_size) > fd->len) {
	errno = E2BIG;
	return(0);
    }

    cdb = (void *)fd->hdr.cmdp;

    ZERO_CDB(cdb);

    SET_CDB10_OPCODE(cdb, VERIFY_10);

    SET_CDB10_LBA(cdb, lba);

    SET_CDB10_TLEN(cdb, len);

    if(flags & F_DPO)
	SET_CDB10_DPO(cdb);

    if(flags & F_BYTCHK)
	SET_CDB10_BYTCHK(cdb);

    if(flags & F_RELADDR)
	SET_CDB10_RELADDR(cdb);


    fd->hdr.dxfer_direction = SG_DXFER_TO_DEV;
    fd->hdr.cmd_len	    = 10;
    fd->hdr.iovec_count	    = 0;
    fd->hdr.dxfer_len	    = len * fd->sector_size;
    fd->hdr.dxferp	    = buf;

    if(ioctl(fd->fd, SG_IO, &fd->hdr) == -1)
	goto abt;

    if(fd->hdr.masked_status != GOOD)
	goto abt;


    return(1);


abt:
    if(fd->hdr.masked_status == CHECK_CONDITION)
	scsi_byteswap_sense_data(fd->hdr.sbp);

    return(0);
}
