/*
    Copyright 2002, 2003, Steve Thompson <stevet010@softhome.net>

    This software is free for non-commercial, non-military use.

    Included with this package, you should have received a file called
    `Licensing' which contains detailed terms of use.

*/

#include <scsilib.h>


int scsi_TEST_UNIT_READY(struct scsi_fd *fd, int timeout)
{
    struct scsi_cdb *	cdb = NULL;
    int			oto;


    if(!fd) {
	errno = EINVAL;
	return(0);
    }

    cdb = (void *)fd->hdr.cmdp;

    ZERO_CDB(cdb);

    SET_CDB6_OPCODE(cdb, TEST_UNIT_READY);

    oto = fd->hdr.timeout;

    fd->hdr.dxfer_direction = SG_DXFER_NONE;
    fd->hdr.cmd_len	    = 6;
    fd->hdr.iovec_count	    = 0;
    fd->hdr.timeout	    = timeout;
    fd->hdr.dxfer_len	    = 0;
    fd->hdr.dxferp	    = NULL;

    if(ioctl(fd->fd, SG_IO, &fd->hdr) == -1)
	goto abt;

    fd->hdr.timeout = oto;

    if(fd->hdr.masked_status == 0x00)
	return(1);

abt:
    if(fd->hdr.masked_status == CHECK_CONDITION)
        scsi_byteswap_sense_data(fd->hdr.sbp);

    fd->hdr.timeout = oto;

    return(0);
}
