/*
    Copyright 2002, 2003, Steve Thompson <stevet010@softhome.net>

    This software is free for non-commercial, non-military use.

    Included with this package, you should have received a file called
    `Licensing' which contains detailed terms of use.

*/

#include <scsilib.h>


int	scsi_START_STOP_UNIT(struct scsi_fd *fd, u32 flags)
{
    struct scsi_cdb *	cdb = NULL;

    assert(fd);

    cdb = (void *)fd->hdr.cmdp;

    memset(cdb, 0, 16);

    SET_CDB6_OPCODE(cdb, START_STOP_UNIT);

    if(flags & F_IMMED)
	SET_CDB6_SSIMMED(cdb);

    if(flags & F_LOEJ)
	SET_CDB6_LOEJ(cdb);

    if(flags & F_START)
	SET_CDB6_START(cdb);


    fd->hdr.dxfer_direction = SG_DXFER_NONE;
    fd->hdr.cmd_len	    = 6;
    fd->hdr.iovec_count	    = 0;
    fd->hdr.dxfer_len	    = 0;
    fd->hdr.dxferp	    = NULL;

    if(ioctl(fd->fd, SG_IO, &fd->hdr) == -1)
	goto abt;

    if(fd->hdr.masked_status != GOOD)
	goto abt;

    return(1);


abt:
    if(fd->hdr.masked_status == CHECK_CONDITION)
	scsi_byteswap_sense_data(fd->hdr.sbp);

    return(0);
}
