/*
    Copyright 2002, 2003, Steve Thompson <stevet010@softhome.net>

    This software is free for non-commercial, non-military use.

    Included with this package, you should have received a file called
    `Licensing' which contains detailed terms of use.

*/

#include <scsilib.h>


void * scsi_RECEIVE_DIAGNOSTIC(struct scsi_fd *fd, void *buf, u16 len)
{
    struct scsi_cdb *	cdb = NULL;
    void *		p = NULL;


    assert(fd);


    if(!buf) {
	if(!(buf = malloc(len)))
	    return(NULL);

	memset(buf, 0, len);
    }

    p = buf;

    cdb = (void *)fd->hdr.cmdp;

    memset(cdb, 0, 16);

    SET_CDB6_OPCODE(cdb, RECEIVE_DIAGNOSTIC);

    SET_CDB6_ALEN16(cdb, len);


    fd->hdr.dxfer_direction = SG_DXFER_FROM_DEV;
    fd->hdr.cmd_len	    = 6;
    fd->hdr.iovec_count	    = 0;
    fd->hdr.dxfer_len	    = len;
    fd->hdr.dxferp	    = p;

    if(ioctl(fd->fd, SG_IO, &fd->hdr) == -1)
	goto abt;

    if(fd->hdr.masked_status != GOOD)
	goto abt;

    return(p);


abt:
    if(fd->hdr.masked_status == CHECK_CONDITION)
	scsi_byteswap_sense_data(fd->hdr.sbp);

    if(p && !buf)
	free(p);

    return(NULL);
}
