/*
    Copyright 2002, 2003, Steve Thompson <stevet010@softhome.net>

    This software is free for non-commercial, non-military use.

    Included with this package, you should have received a file called
    `Licensing' which contains detailed terms of use.

*/

#include <scsilib.h>


int scsi_REASSIGN_BLOCKS(struct scsi_fd *fd, struct scsi_reassign_blocks_header *defect)
{
    struct scsi_cdb *	cdb = NULL;
    size_t		len;

    assert(fd && defect);

    len = sizeof(struct scsi_reassign_blocks_header) + defect->list_len;

    if(len > fd->len) {
	errno = E2BIG;
	return(0);
    }

    cdb = (void *)fd->hdr.cmdp;

    ZERO_CDB(cdb);

    SET_CDB6_OPCODE(cdb, REASSIGN_BLOCKS);


    fd->hdr.dxfer_direction = SG_DXFER_TO_DEV;
    fd->hdr.cmd_len	    = 6;
    fd->hdr.iovec_count	    = 0;
    fd->hdr.dxfer_len	    = len;
    fd->hdr.dxferp	    = defect;

    if(ioctl(fd->fd, SG_IO, &fd->hdr) == -1)
	goto abt;

    if(fd->hdr.masked_status != GOOD)
	goto abt;


    return(1);


abt:
    if(fd->hdr.masked_status == CHECK_CONDITION)
	scsi_byteswap_sense_data(fd->hdr.sbp);

    return(0);
}
