/*
    Copyright 2002, 2003, Steve Thompson <stevet010@softhome.net>

    This software is free for non-commercial, non-military use.

    Included with this package, you should have received a file called
    `Licensing' which contains detailed terms of use.

*/

#include <scsilib.h>


void * scsi_READ_LONG(struct scsi_fd *fd, void *buf, u32 lba, u16 lss, u32 flags)
{
    struct scsi_cdb *	cdb = NULL;
    void *		p = NULL;


    assert(fd);

    if(lss > fd->len) {
	errno = E2BIG;
	return(NULL);
    }

    if(!buf) {
	if(!(buf = malloc(lss)))
	    return(NULL);

	memset(buf, 0, lss);
    }

    p = buf;

    cdb = (void *)fd->hdr.cmdp;

    ZERO_CDB(cdb);

    SET_CDB10_OPCODE(cdb, READ_LONG);

    SET_CDB10_LBA(cdb, lba);

    SET_CDB10_ALEN(cdb, lss);

    if(flags & F_CORRCT)
	SET_CDB10_CORRCT(cdb);

    if(flags & F_RELADDR)
	SET_CDB10_RELADDR(cdb);


    fd->hdr.dxfer_direction = SG_DXFER_FROM_DEV;
    fd->hdr.cmd_len	    = 10;
    fd->hdr.iovec_count	    = 0;
    fd->hdr.dxfer_len	    = lss;
    fd->hdr.dxferp	    = p;

    if(ioctl(fd->fd, SG_IO, &fd->hdr) == -1)
	goto abt;

    if(fd->hdr.masked_status != GOOD)
	goto abt;


    return(p);


abt:
    if(fd->hdr.masked_status == CHECK_CONDITION)
	scsi_byteswap_sense_data(fd->hdr.sbp);

    if(p && !buf)
	free(p);

    return(NULL);
}
