/*
    Copyright 2002, 2003, Steve Thompson <stevet010@softhome.net>

    This software is free for non-commercial, non-military use.

    Included with this package, you should have received a file called
    `Licensing' which contains detailed terms of use.

*/

#include <scsilib.h>


struct scsi_defect_list_header_12 * scsi_READ_DEFECT_DATA_12(struct scsi_fd *fd, void *buf, u32 len, u32 flags, u8 format)
{
    struct scsi_cdb		    *cdb = NULL;
    struct scsi_defect_list_header_12  *p = NULL;


    assert(fd);


    if(len > fd->len) {
	errno = E2BIG;
	return(NULL);
    }

    if(!len)
	len = sizeof(struct scsi_defect_list_header);

    if(!buf) {
	if(!(p = malloc(len)))
	    return(NULL);

	memset(p, 0, len);
    } else
	p = buf;

    cdb = (void *)fd->hdr.cmdp;

    ZERO_CDB(cdb);

    SET_CDB12_OPCODE(cdb, READ_DEFECT_DATA_12);

    SET_CDB12_DLEN(cdb, U32TOS(len));

    if(flags & F_GLIST)
	SET_CDB12_GLIST(cdb);

    if(flags & F_PLIST)
	SET_CDB12_PLIST(cdb);

    SET_CDB12_DLFMT(cdb, format);

    fd->hdr.dxfer_direction = SG_DXFER_FROM_DEV;
    fd->hdr.cmd_len	    = 12;
    fd->hdr.iovec_count	    = 0;
    fd->hdr.dxfer_len	    = len;
    fd->hdr.dxferp	    = p;

    if(ioctl(fd->fd, SG_IO, &fd->hdr) == -1)
	goto abt;

    if(fd->hdr.masked_status != GOOD)
	goto abt;

#if defined(LITTLE_ENDIAN)
    scsi_byteswap_defect_list_header_12(p, len, format);
#endif	

    return(p);


abt:

#ifdef LITTLE_ENDIAN
    if(fd->hdr.masked_status == CHECK_CONDITION)
	scsi_byteswap_sense_data(fd->hdr.sbp);
#endif

    if(p && !buf)
	free(p);

    return(NULL);
}
