/*
    Copyright 2002, 2003, Steve Thompson <stevet010@softhome.net>

    This software is free for non-commercial, non-military use.

    Included with this package, you should have received a file called
    `Licensing' which contains detailed terms of use.

*/

#include <scsilib.h>


struct scsi_defect_list_header * scsi_READ_DEFECT_DATA(struct scsi_fd *fd, void *buf, u16 len, u32 flags, u8 format)
{
    struct scsi_cdb		    *cdb = NULL;
    struct scsi_defect_list_header  *p = NULL;


    assert(fd);

    if(len > fd->len) {
	errno = E2BIG;
	return(NULL);
    }

    if(!len)
	len = sizeof(struct scsi_defect_list_header);

    if(!buf) {
	if(!(p = malloc(len)))
	    return(NULL);

	memset(p, 0, len);
    } else
	p = buf;

    cdb = (void *)fd->hdr.cmdp;

    memset(cdb, 0, 16);

    SET_CDB10_OPCODE(cdb, READ_DEFECT_DATA);

    SET_CDB10_DLEN(cdb, len);

    if(flags & F_GLIST)
	SET_CDB10_GLIST(cdb);

    if(flags & F_PLIST)
	SET_CDB10_PLIST(cdb);

    SET_CDB10_DLFMT(cdb, format);

    fd->hdr.dxfer_direction = SG_DXFER_FROM_DEV;
    fd->hdr.cmd_len	    = 10;
    fd->hdr.iovec_count	    = 0;
    fd->hdr.dxfer_len	    = len;
    fd->hdr.dxferp	    = p;

    if(ioctl(fd->fd, SG_IO, &fd->hdr) == -1)
	goto abt;

    if(fd->hdr.masked_status != GOOD)
	goto abt;

#if defined(LITTLE_ENDIAN)
    scsi_byteswap_defect_list_header(p, len, format);
#endif	

    return(p);


abt:

#ifdef LITTLE_ENDIAN
    if(fd->hdr.masked_status == CHECK_CONDITION)
	scsi_byteswap_sense_data(fd->hdr.sbp);
#endif

    if(p && !buf)
	free(p);

    return(NULL);
}
