/*
    Copyright 2002, 2003, Steve Thompson <stevet010@softhome.net>

    This software is free for non-commercial, non-military use.

    Included with this package, you should have received a file called
    `Licensing' which contains detailed terms of use.

*/

#include <scsilib.h>


struct scsi_capacity *	scsi_READ_CAPACITY(struct scsi_fd *fd, u32 LBA, u32 flags)
{
    struct scsi_capacity *	cap = NULL;
    struct scsi_cdb *		cdb = NULL;


    if(!fd || (!(flags & F_PMI) && LBA)) {
	errno = EINVAL;
	return(NULL);
    }

    if(!(cap = malloc(sizeof(struct scsi_capacity))))
	return(NULL);


    cdb = (void *)fd->hdr.cmdp;

    memset(cdb, 0, 10);

    SET_CDB10_OPCODE(cdb, READ_CAPACITY);
    SET_CDB10_LBA(cdb, LBA);

    if(flags & F_RELADDR)
	SET_CDB10_RELADDR(cdb);

    if(flags & F_PMI)
	SET_CDB10_PMI(cdb);


    fd->hdr.dxfer_direction = SG_DXFER_FROM_DEV;
    fd->hdr.cmd_len	    = 10;
    fd->hdr.iovec_count	    = 0;
    fd->hdr.dxfer_len	    = sizeof(struct scsi_capacity);
    fd->hdr.dxferp	    = cap;

    if(ioctl(fd->fd, SG_IO, &fd->hdr) == -1)
	goto abt;

    if(fd->hdr.masked_status)
	goto abt;

    byteswap_struct_scsi_capacity(cap);

    return(cap);


abt:
    if(fd->hdr.masked_status == CHECK_CONDITION)
	scsi_byteswap_sense_data(fd->hdr.sbp);

    if(cap)	free(cap);

    return(NULL);
}
