/*
    Copyright 2002, 2003, Steve Thompson <stevet010@softhome.net>

    This software is free for non-commercial, non-military use.

    Included with this package, you should have received a file called
    `Licensing' which contains detailed terms of use.

*/

#include <scsilib.h>


void * scsi_READ_BUFFER(struct scsi_fd *fd, u8 mode, u8 buffer_id, u32 offset, void *buf, u32 len) 
{
    struct scsi_cdb *	cdb = NULL;
    void *		p = NULL;

    assert(fd);

    if(mode > 0x07) {
	errno = EINVAL;
	return(NULL);
    }

    if(buffer_id > 0xff) {
	errno = EINVAL;
	return(NULL);
    }

    if(offset > 0x00ffffff) {
	errno = EINVAL;
	return(NULL);
    }

    if(len > 0x00ffffff) {
	errno = EINVAL;
	return(NULL);
    }

    if(len > fd->len) {
	errno = E2BIG;
	return(NULL);
    }

    if(!buf) {
	if(!(buf = malloc(len)))
	    return(NULL);

	memset(buf, 0, len);
    }

    p = buf;

    cdb = (void *)fd->hdr.cmdp;

    memset(cdb, 0, 16);

    cdb->u.b[0] = READ_10;
    cdb->u.b[1] = mode;
    cdb->u.b[2] = buffer_id;
    cdb->u.b[3] = (offset & 0x00ff0000) >> 16;
    cdb->u.b[4] = (offset & 0x0000ff00) >> 8;
    cdb->u.b[5] = (offset & 0x000000ff);
    cdb->u.b[6] = (len & 0x00ff0000) >> 16;
    cdb->u.b[7] = (len & 0x0000ff00) >> 8;
    cdb->u.b[8] = (len & 0x000000ff);

    fd->hdr.dxfer_direction = SG_DXFER_FROM_DEV;
    fd->hdr.cmd_len	    = 10;
    fd->hdr.iovec_count	    = 0;
    fd->hdr.dxfer_len	    = len;
    fd->hdr.dxferp	    = p;

    if(ioctl(fd->fd, SG_IO, &fd->hdr) == -1)
	goto abt;

    if(fd->hdr.masked_status != GOOD)
	goto abt;


    return(p);


abt:
    if(fd->hdr.masked_status == CHECK_CONDITION)
	scsi_byteswap_sense_data(fd->hdr.sbp);

    if(p && !buf)
	free(p);

    return(NULL);
}
