/*
    Copyright 2002, 2003, Steve Thompson <stevet010@softhome.net>

    This software is free for non-commercial, non-military use.

    Included with this package, you should have received a file called
    `Licensing' which contains detailed terms of use.

*/

#include <scsilib.h>


void * scsi_READ_6(struct scsi_fd *fd, void *buf, u32 lba, u16 len)
{
    struct scsi_cdb *	cdb = NULL;
    void *		p = NULL;

    assert(fd);

    if(len > 256) {
	errno = EINVAL;
	return(NULL);
    }

    if(lba > 0x001fffff) {
	errno = EINVAL;
	return(NULL);
    }

    if(!fd->sector_size) {
	errno = EINVAL;
	return(NULL);
    }

    if((((len) ? len : 256) * fd->sector_size) > fd->len) {
	errno = E2BIG;
	return(NULL);
    }

    if(!buf) {
	if(!(buf = malloc(len * fd->sector_size)))
	    return(NULL);

	memset(buf, 0, len * fd->sector_size);
    }

    p = buf;

    cdb = (void *)fd->hdr.cmdp;

    memset(cdb, 0, 16);

    SET_CDB6_OPCODE(cdb, READ_6);

    SET_CDB6_LBA(cdb, lba);

    SET_CDB6_TLEN(cdb, len);


    fd->hdr.dxfer_direction = SG_DXFER_FROM_DEV;
    fd->hdr.cmd_len	    = 6;
    fd->hdr.iovec_count	    = 0;
    fd->hdr.dxfer_len	    = len * fd->sector_size;
    fd->hdr.dxferp	    = p;

    if(ioctl(fd->fd, SG_IO, &fd->hdr) == -1)
	goto abt;

    if(fd->hdr.masked_status != GOOD)
	goto abt;


    return(p);


abt:
    if(fd->hdr.masked_status == CHECK_CONDITION)
	scsi_byteswap_sense_data(fd->hdr.sbp);

    if(p && !buf)
	free(p);

    return(NULL);
}
