/*
    Copyright 2002, 2003, Steve Thompson <stevet010@softhome.net>

    This software is free for non-commercial, non-military use.

    Included with this package, you should have received a file called
    `Licensing' which contains detailed terms of use.

*/

#include <scsilib.h>


void * scsi_READ_12(struct scsi_fd *fd, void *buf, u32 lba, u32 len, u32 flags)
{
    struct scsi_cdb *	cdb = NULL;
    void *		p = NULL;

    assert(fd);

    if(!fd->sector_size) {
	errno = EINVAL;
	return(NULL);
    }

    if((len * fd->sector_size) > fd->len) {
	errno = E2BIG;
	return(NULL);
    }

    if(!buf) {
	if(!(buf = malloc(len * fd->sector_size)))
	    return(NULL);

	memset(buf, 0, len * fd->sector_size);
    }

    p = buf;

    cdb = (void *)fd->hdr.cmdp;

    memset(cdb, 0, 16);

    SET_CDB12_OPCODE(cdb, READ_10);

    SET_CDB12_LBA(cdb, lba);

    SET_CDB12_ALEN(cdb, len);

    if(flags & F_DPO)
	SET_CDB12_DPO(cdb);

    if(flags & F_FUA)
	SET_CDB12_FUA(cdb);

    if(flags & F_RELADDR)
	SET_CDB12_RELADDR(cdb);


    fd->hdr.dxfer_direction = SG_DXFER_FROM_DEV;
    fd->hdr.cmd_len	    = 6;
    fd->hdr.iovec_count	    = 0;
    fd->hdr.dxfer_len	    = len * fd->sector_size;
    fd->hdr.dxferp	    = p;

    if(ioctl(fd->fd, SG_IO, &fd->hdr) == -1)
	goto abt;

    if(fd->hdr.masked_status != GOOD)
	goto abt;


    return(p);


abt:
    if(fd->hdr.masked_status == CHECK_CONDITION)
	scsi_byteswap_sense_data(fd->hdr.sbp);

    if(p && !buf)
	free(p);

    return(NULL);
}
