/*
    Copyright 2002, 2003, Steve Thompson <stevet010@softhome.net>

    This software is free for non-commercial, non-military use.

    Included with this package, you should have received a file called
    `Licensing' which contains detailed terms of use.

*/

#include <scsilib.h>


struct scsi_mode_param * scsi_MODE_SENSE(struct scsi_fd *fd, void *buf, u16 len, u8 PC, u8 Page, u32 flags)
{
    struct scsi_cdb		*cdb = NULL;
    struct scsi_mode_param 	*p = NULL;


    assert(fd);

    if(!len)
	len = sizeof(struct scsi_mode_param) 
		+ sizeof(struct scsi_mode_param_block_desc) 
		+ sizeof(struct scsi_mode_page);

    if(len > 256) {
	errno = EINVAL;
	return(NULL);
    }

    if(len > fd->len) {
	errno = E2BIG;
	return(NULL);
    }

    if(PC > 3) {
	errno = EINVAL;
	return(NULL);
    }

    if(Page > 0x3e) {
	errno = EINVAL;
	return(NULL);
    }


    if(!buf) {
	if(!(buf = malloc(len)))
	    return(NULL);

	memset(buf, 0, len);
    }

    p = buf;

    cdb = (void *)fd->hdr.cmdp;

    ZERO_CDB(cdb);

    SET_CDB6_OPCODE(cdb, MODE_SENSE);

    if(flags & F_DBD)
	SET_CDB6_DBD(cdb);

    SET_CDB6_PC(cdb, PC);

    SET_CDB6_PAGE(cdb, Page);

    SET_CDB6_ALEN(cdb, len);


    fd->hdr.dxfer_direction = SG_DXFER_FROM_DEV;
    fd->hdr.cmd_len	    = 6;
    fd->hdr.iovec_count	    = 0;
    fd->hdr.dxfer_len	    = len;
    fd->hdr.dxferp	    = p;

    if(ioctl(fd->fd, SG_IO, &fd->hdr) == -1)
	goto abt;

    if(fd->hdr.masked_status != GOOD)
	goto abt;


    return(p);


abt:
    if(fd->hdr.masked_status == CHECK_CONDITION)
	scsi_byteswap_sense_data(fd->hdr.sbp);

    if(p && !buf)
	free(p);

    return(NULL);
}
