/*
    Copyright 2002, 2003, Steve Thompson <stevet010@softhome.net>

    This software is free for non-commercial, non-military use.

    Included with this package, you should have received a file called
    `Licensing' which contains detailed terms of use.

*/

#include <scsilib.h>


int scsi_MODE_SELECT(struct scsi_fd *fd, struct scsi_mode_param *page, u32 flags)
{
    struct scsi_cdb *	cdb = NULL;
    size_t		len;
    int			PS;
    struct scsi_mode_page *p;


    assert(fd);
    if(!page) {
	errno = EINVAL;
	return(0);
    }

    if(!page->mode_data_len) {
	errno = EINVAL;
	return(0);
    }


    (u8 *)p = page->p + page->desc_len;
    PS = p->hdr.PS;
    p->hdr.PS = 0;


    len = 1 + page->mode_data_len;
    if(len > fd->len) {
	errno = E2BIG;
	return(0);
    }
    page->mode_data_len = 0;


    cdb = (void *)fd->hdr.cmdp;

    ZERO_CDB(cdb);

    SET_CDB6_OPCODE(cdb, MODE_SELECT);

    SET_CDB6_PLEN(cdb, len);

    if(flags & F_SP)
	SET_CDB6_SP(cdb);

    if(flags & F_PF)
	SET_CDB6_PF(cdb);


    fd->hdr.dxfer_direction = SG_DXFER_TO_DEV;
    fd->hdr.cmd_len	    = 6;
    fd->hdr.iovec_count	    = 0;
    fd->hdr.dxfer_len	    = len;
    fd->hdr.dxferp	    = page;

    if(ioctl(fd->fd, SG_IO, &fd->hdr) == -1)
	goto abt;

    if(fd->hdr.masked_status != GOOD)
	goto abt;

    p->hdr.PS = PS;
    page->mode_data_len = len - 1;

    return(1);


abt:
    if(fd->hdr.masked_status == CHECK_CONDITION)
	scsi_byteswap_sense_data(fd->hdr.sbp);

    p->hdr.PS = PS;
    page->mode_data_len = len - 1;

    return(0);
}
