/*
    Copyright 2002, 2003, Steve Thompson <stevet010@softhome.net>

    This software is free for non-commercial, non-military use.

    Included with this package, you should have received a file called
    `Licensing' which contains detailed terms of use.

*/

#include <scsilib.h>


void * scsi_LOG_SENSE(struct scsi_fd *fd, void *buf, u8 PC, u8 Page, struct scsi_logpage_param *param, u16 len, u32 flags)
{
    struct scsi_cdb *	cdb = NULL;
    void *		p = NULL;


    assert(fd);

    if(len > fd->len) {
	errno = E2BIG;
	return(NULL);
    }

    if(PC > 3) {
	errno = EINVAL;
	return(NULL);
    }

    if(Page > 0x3f) {
	errno = EINVAL;
	return(NULL);
    }


    if(!buf) {
	if(!(buf = malloc(len)))
	    return(NULL);

	memset(buf, 0, len);
    }

    p = buf;

    cdb = (void *)fd->hdr.cmdp;

    memset(cdb, 0, 16);

    SET_CDB10_OPCODE(cdb, LOG_SENSE);

    if(flags & F_SP)
	SET_CDB10_SP(cdb);

    if(flags & F_PPC)
	SET_CDB10_PPC(cdb);

    SET_CDB10_PC(cdb, PC);

    SET_CDB10_PAGE(cdb, Page);

    if(param)
	SET_CDB10_PARAM_PTR(cdb, *((u16 *)param));

    SET_CDB10_ALEN(cdb, len);


    fd->hdr.dxfer_direction = SG_DXFER_FROM_DEV;
    fd->hdr.cmd_len	    = 10;
    fd->hdr.iovec_count	    = 0;
    fd->hdr.dxfer_len	    = len;
    fd->hdr.dxferp	    = p;

    if(ioctl(fd->fd, SG_IO, &fd->hdr) == -1)
	goto abt;

    if(fd->hdr.masked_status != GOOD)
	goto abt;


    return(p);


abt:
    if(fd->hdr.masked_status == CHECK_CONDITION)
	scsi_byteswap_sense_data(fd->hdr.sbp);

    if(p && !buf)
	free(p);

    return(NULL);
}
