/*
    Copyright 2002, 2003, Steve Thompson <stevet010@softhome.net>

    This software is free for non-commercial, non-military use.

    Included with this package, you should have received a file called
    `Licensing' which contains detailed terms of use.

*/

#include <scsilib.h>


void * scsi_INQUIRY(struct scsi_fd *fd, void *buf, size_t len, u32 flags, u8 Page)
{
    struct scsi_cdb *	cdb = NULL;
    void *		p = NULL;


    assert(fd);

    if( (!(flags & F_EVPD) && Page) | ((flags & F_EVPD) && (flags & F_CMDDT)) ) {
	errno = EINVAL;
	return(NULL);
    }

    if(len > 255) {
	errno = EINVAL;
	return(NULL);
    }

    if(!len)
	len = SCSI_DEFAULT_PAGE_LEN;

    if(!buf) {
	if(!(buf = malloc(len)))
	    return(NULL);
    }

    memset(buf, 0, len);

    p = buf;

    cdb = (void *)fd->hdr.cmdp;

    memset(cdb, 0, 16);

    SET_CDB6_OPCODE(cdb, INQUIRY);

    if(flags & F_EVPD)
	SET_CDB6_EVPD(cdb);

    if(flags & F_CMDDT)
	SET_CDB6_CMDDT(cdb);

    if(Page)
	SET_CDB6_PAGECODE(cdb, Page);

    SET_CDB6_ALEN(cdb, len);


    fd->hdr.dxfer_direction = SG_DXFER_FROM_DEV;
    fd->hdr.cmd_len	    = 6;
    fd->hdr.iovec_count	    = 0;
    fd->hdr.dxfer_len	    = len;
    fd->hdr.dxferp	    = p;

    if(ioctl(fd->fd, SG_IO, &fd->hdr) == -1)
	goto abt;

    if(fd->hdr.masked_status != GOOD)
	goto abt;

#if defined(LITTLE_ENDIAN)
    if(flags & F_EVPD)
	scsi_byteswap_vpd_page(p);
#endif	

    return(p);


abt:
    if(fd->hdr.masked_status == CHECK_CONDITION)
	scsi_byteswap_sense_data(fd->hdr.sbp);

    if(p && !buf)
	free(p);

    return(NULL);
}
