/*
    Copyright 2002, 2003, Steve Thompson <stevet010@softhome.net>

    This software is free for non-commercial, non-military use.

    Included with this package, you should have received a file called
    `Licensing' which contains detailed terms of use.

*/

#include <scsilib.h>


int scsi_FORMAT_UNIT(	struct scsi_fd	    *fd,
			int		    timeout,
			u32		    flags,
			void		    *init,
			u16		    init_len,
			u8		    init_type,
			u8		    init_mod,
			void		    *dlist,
			u16		    dlist_len,
			u8		    dlist_type,
			u32		    dlist_flags)
{
    struct scsi_cdb *	cdb = NULL;
    int			oto;

    size_t		len = 0;
    void		*fmt_data = NULL;
    void		*p;
    struct scsi_initialisation_pattern	    *ip;
    struct scsi_format_defect_list_header   *dlh;


    if(!fd) {
	errno = EINVAL;
	return(0);
    }

    if(init && !init_len) {
	errno = EINVAL;
	return(0);
    }

    if(init_type && !init) {
	errno = EINVAL;
	return(0);
    }

    if(init_type > 255) {
	errno = EINVAL;
	return(0);
    }

    if(init_mod > 2) {
	errno = EINVAL;
	return(0);
    }

    if(dlist && !dlist_len) {
	errno = EINVAL;
	return(0);
    }

    cdb = (void *)fd->hdr.cmdp;

    ZERO_CDB(cdb);

    SET_CDB6_OPCODE(cdb, FORMAT_UNIT);

    if(flags & F_CMPLIST)
	SET_CDB6_CMPLIST(cdb);

    if(flags & F_FMTDATA)
	SET_CDB6_FMTDATA(cdb);


    if(dlist_flags || dlist || init)
	len += sizeof(struct scsi_defect_list_header);

    if(init) {
	len += sizeof(struct scsi_initialisation_pattern);
	len += init_len;
    }

    if(dlist)
	len += dlist_len;

    if(len) {
	if(!(p = fmt_data = malloc(len)))
	    return(0);

	memset(p, 0, sizeof(struct scsi_defect_list_header));

	dlh = p;

	if(dlist_flags & DLH_VS)
	    dlh->VS = 1;

	if(dlist_flags & DLH_IMMED)
	    dlh->Immed = 1;

	if(dlist_flags & DLH_DSP)
	    dlh->DSP = 1;

	if(dlist_flags & DLH_IP)
	    dlh->IP = 1;

	if(dlist_flags & DLH_STPF)
	    dlh->STPF = 1;

	if(dlist_flags & DLH_DCRT)
	    dlh->DCRT = 1;

	if(dlist_flags & DLH_DPRY)
	    dlh->DPRY = 1;

	if(dlist_flags & DLH_FOV)
	    dlh->FOV = 1;

	dlh->list_len = U16TOS(dlist_len);

	p += sizeof(struct scsi_defect_list_header);

	if(init) {
	    ip = p;

	    memset(ip, 0, sizeof(struct scsi_initialisation_pattern));

	    ip->IP_modifier = init_mod;

	    ip->pattern_type = init_type;

	    ip->pattern_length = U16TOS(init_len);

	    p += sizeof(struct scsi_initialisation_pattern);

	    memcpy(p, init, init_len);

	    p += init_len;
	}

	if(dlist) {
	    memcpy(p, dlist, dlist_len);

	    scsi_byteswap_defect_list(p, dlist_len, dlist_type);
	}
    }

#ifdef DEBUG
    scsi_cdb_dump(stdout, cdb);

    if(len)
	hexdump(fileno(stdout), 0, fmt_data, len);
#endif

    oto = fd->hdr.timeout;

    fd->hdr.cmd_len	    = 6;
    fd->hdr.iovec_count	    = 0;
    fd->hdr.timeout	    = timeout;

    if(len) {
	fd->hdr.dxfer_direction = SG_DXFER_TO_DEV;
	fd->hdr.dxfer_len	= len;
	fd->hdr.dxferp		= fmt_data;
    } else {
	fd->hdr.dxfer_direction = SG_DXFER_NONE;
	fd->hdr.dxfer_len	= 0;
	fd->hdr.dxferp		= NULL;
    }

    if(ioctl(fd->fd, SG_IO, &fd->hdr) == -1)
	goto abt;

    fd->hdr.timeout = oto;

    if(fd->hdr.masked_status != GOOD)
	goto abt;

    if(fmt_data) {
	free(fmt_data);
	fd->hdr.dxferp = NULL;
    }

    return(1);


abt:
    if(fd->hdr.masked_status == CHECK_CONDITION)
	scsi_byteswap_sense_data(fd->hdr.sbp);

    if(fmt_data) {
	free(fmt_data);
	fd->hdr.dxferp = NULL;
    }

    fd->hdr.timeout = oto;

    return(0);
}
