/*
    Copyright 2002, 2003, Steve Thompson <stevet010@softhome.net>

    This software is free for non-commercial, non-military use.

    Included with this package, you should have received a file called
    `Licensing' which contains detailed terms of use.

*/

#include <scsilib.h>




char * scsi_get_serial_number(struct scsi_fd *fd)
{
    char *  serial = NULL;
    struct scsi_vpd_page *page = NULL;


    assert(fd);

    if(!(page = scsi_INQUIRY(fd, NULL, 0, F_EVPD, VPD_SERIAL_NUMBER))) {
        if(errno) {
            fprintf(stderr, "VPD page %d inquiry failed - %m\n", VPD_SERIAL_NUMBER);
            goto abt;
	}

        fprintf(stderr, "INQUIRY for VPD page %d failed.\n", VPD_SERIAL_NUMBER);

        goto abt;
    }

    if(!(serial = malloc(VPD_PAGE_LEN(page) + 1)))
        goto abt;

    memset(serial, 0, VPD_PAGE_LEN(page) + 1);

    memcpy(serial, page->u.serial_no.text, VPD_PAGE_LEN(page));

    free(page);

    return(serial);

abt:
    if(serial)
	free(serial);

    if(page)
	free(page);

    return(NULL);
}
