/*
    Copyright 2002, 2003, Steve Thompson <stevet010@softhome.net>

    This software is free for non-commercial, non-military use.

    Included with this package, you should have received a file called
    `Licensing' which contains detailed terms of use.

*/

#include <scsilib.h>



void	scsi_byteswap_vpd_page(struct scsi_vpd_page *p)
{
    assert(p);

    if(!VPD_PAGE_LEN(p))
	return;

    /*
	This is probably really wrong.

    switch(VPD_PAGECODE(p)) {
	case (VPD_DEVICE_IDENTIFICATION):
	    for(i=0; i < (VPD_PAGE_LEN(p) / sizeof(struct scsi_vpd_ident_desc)); i++)
		if(p->u.device_id.desc[i].code_set == 2) 
		    scsi_byteswap_u8(p->u.device_id.desc[i].identifier, p->u.device_id.desc[i].identifier_len);

	break;
    }
    */

    return;
}


void	scsi_vpd_page_text(FILE * s, struct scsi_vpd_page *p)
{
    int	    i;

    assert(p);

    fprintf(s, "Page 0x%02x Contents:\n---------------------\n\n", VPD_PAGECODE(p));

    switch(VPD_PAGECODE(p)) {
	case(0):
	    /*	Supported vital product data pages */

	    fprintf(s, "Supported VPD pages: ");

	    for(i = 0; i < VPD_PAGE_LEN(p); i++)
		fprintf(s, "0x%02x ", p->u.supported.page_list[i]);

	    fputc('\n', s);

	    break;

	case(0x01) ... (0x7f):
	    for(i = 0; i < VPD_PAGE_LEN(p); i++)
	    fputc(p->u.ascii_page.ascii_info[i], s);

	    fputc('\n', s);

	    break;

	case(0x80):
	    /*
		Unit serial number page
	    */

	    fprintf(s, "Serial Number: `");

	    for(i = 0; i < VPD_PAGE_LEN(p); i++)
	    fputc(p->u.serial_no.text[i], s);

	    fputc('\'', s);
	    fputc('\n', s);

	    break;

	case(0x81):
	    /*
		Implemented operating definitions page
	    */
	    fprintf(stdout, "Curent Operating Definition:     %02x\n", p->u.op_def.definition[0].def);
	    fprintf(stdout, "Default Operating Definition:    %02x\n", p->u.op_def.definition[1].def);

	    fprintf(stdout, "Supported Operating Definitions: ");

	    for(i = 2 ; i < VPD_PAGE_LEN(p); i++)
		fprintf(stdout, "%02x%c ",  p->u.op_def.definition[i].def, 
					    p->u.op_def.definition[i].SavImp ? '=' : ' ');
					   
	    fputc('\n', stdout);

	    break;

	case(0x82):
	    /*
		ASCII Implimented operating definition page
	    */
	    fprintf(stdout, "ASCII Operating Definition: `");

	    for(i = 0; i < p->u.ascii_op_def.ascii_def_len; i++)
		fputc(p->u.ascii_op_def.ascii_def[i], stdout);

	    fputc('\'', stdout);
	    fputc('\n', stdout);

	    break;

	case(0x83):
	    /*
		Device Identification Page
	    */
	


	default:

	    fflush(s);
	    hexdump(fileno(s), 0, p, VPD_PAGE_SIZE(p));

    }

}



