/*
    Copyright 2002, 2003, Steve Thompson <stevet010@softhome.net>

    This software is free for non-commercial, non-military use.

    Included with this package, you should have received a file called
    `Licensing' which contains detailed terms of use.

*/
#include <scsilib.h>


char *scsi_opcode_support_text(struct scsi_opcode_support_data *p)
{
    p=NULL;

    return(strdup("Function not written yet\n"));
}


const char *scsi_opcode[] = {
    "TEST_UNIT_READY",        /* 0x00 */
    "REZERO_UNIT",            /* 0x01 */
    "reserved 0x02",
    "REQUEST_SENSE",          /* 0x03 */
    "FORMAT_UNIT",            /* 0x04 */
    "READ_BLOCK_LIMITS",      /* 0x05 */
    "reserved 0x06",
    "REASSIGN_BLOCKS",        /* 0x07 */
    "READ_6",                 /* 0x08 */
    "reserved 0x09",
    "WRITE_6",                /* 0x0a */
    "SEEK_6",                 /* 0x0b */
    "reserved 0x0c",
    "reserved 0x0d",
    "reserved 0x0e",
    "READ_REVERSE",           /* 0x0f */

    "WRITE_FILEMARKS",        /* 0x10 */
    "SPACE",                  /* 0x11 */
    "INQUIRY",                /* 0x12 */
    "reserved 0x13",
    "RECOVER_BUFFERED_DATA",  /* 0x14 */
    "MODE_SELECT",            /* 0x15 */
    "RESERVE",                /* 0x16 */
    "RELEASE",                /* 0x17 */
    "COPY",                   /* 0x18 */
    "ERASE",                  /* 0x19 */
    "MODE_SENSE",             /* 0x1a */
    "START_STOP",             /* 0x1b */
    "RECEIVE_DIAGNOSTIC",     /* 0x1c */
    "SEND_DIAGNOSTIC",        /* 0x1d */
    "ALLOW_MEDIUM_REMOVAL",   /* 0x1e */
    "reserved 0x1f",

    "reserved 0x20",
    "reserved 0x21",
    "reserved 0x22",
    "reserved 0x23",
    "SET_WINDOW",             /* 0x24 */
    "READ_CAPACITY",          /* 0x25 */
    "reserved 0x26",
    "reserved 0x27",
    "READ_10",                /* 0x28 */
    "reserved 0x29",
    "WRITE_10",               /* 0x2a */
    "SEEK_10",                /* 0x2b */
    "reserved 0x2c",
    "reserved 0x2d",
    "WRITE_VERIFY",           /* 0x2e */
    "VERIFY",                 /* 0x2f */

    "SEARCH_HIGH",            /* 0x30 */
    "SEARCH_EQUAL",           /* 0x31 */
    "SEARCH_LOW",             /* 0x32 */
    "SET_LIMITS",             /* 0x33 */
    "PRE_FETCH/READ_POSITION",/* 0x34 */
    "SYNCHRONIZE_CACHE",      /* 0x35 */
    "LOCK_UNLOCK_CACHE",      /* 0x36 */
    "READ_DEFECT_DATA",       /* 0x37 */
    "MEDIUM_SCAN",            /* 0x38 */
    "COMPARE",                /* 0x39 */
    "COPY_VERIFY",            /* 0x3a */
    "WRITE_BUFFER",           /* 0x3b */
    "READ_BUFFER",            /* 0x3c */
    "UPDATE_BLOCK",           /* 0x3d */
    "READ_LONG",              /* 0x3e */
    "WRITE_LONG",             /* 0x3f */

    "CHANGE_DEFINITION",      /* 0x40 */
    "WRITE_SAME",             /* 0x41 */
    "reserved 0x42",
    "READ_TOC",               /* 0x43 */
    "reserved 0x44",
    "reserved 0x45",
    "reserved 0x46",
    "reserved 0x47",
    "reserved 0x48",
    "reserved 0x49",
    "reserved 0x4a",
    "reserved 0x4b",
    "LOG_SELECT",             /* 0x4c */
    "LOG_SENSE",              /* 0x4d */
    "reserved 0x4e",
    "reserved 0x4f",

    "reserved 0x50",
    "reserved 0x51",
    "reserved 0x52",
    "reserved 0x53",
    "reserved 0x54",
    "MODE_SELECT_10",         /* 0x55 */
    "reserved 0x56",
    "reserved 0x57",
    "reserved 0x58",
    "reserved 0x59",
    "MODE_SENSE_10",          /* 0x5a */
    "reserved 0x5b",
    "reserved 0x5c",
    "reserved 0x5f",
    "reserved 0x5e",
    "reserved 0x5f",

    "reserved 0x60",
    "reserved 0x61",
    "reserved 0x62",
    "reserved 0x63",
    "reserved 0x64",
    "reserved 0x65",
    "reserved 0x66",
    "reserved 0x67",
    "reserved 0x68",
    "reserved 0x69",
    "reserved 0x6a",
    "reserved 0x6b",
    "reserved 0x6c",
    "reserved 0x6d",
    "reserved 0x6e",
    "reserved 0x6f",

    "reserved 0x70",
    "reserved 0x71",
    "reserved 0x72",
    "reserved 0x73",
    "reserved 0x74",
    "reserved 0x75",
    "reserved 0x76",
    "reserved 0x77",
    "reserved 0x78",
    "reserved 0x79",
    "reserved 0x7a",
    "reserved 0x7b",
    "reserved 0x7c",
    "reserved 0x7d",
    "reserved 0x7e",
    "reserved 0x7f",

    "reserved 0x80",
    "reserved 0x81",
    "reserved 0x82",
    "reserved 0x83",
    "reserved 0x84",
    "reserved 0x85",
    "reserved 0x86",
    "reserved 0x87",
    "reserved 0x88",
    "reserved 0x89",
    "reserved 0x8a",
    "reserved 0x8b",
    "reserved 0x8c",
    "reserved 0x8d",
    "reserved 0x8e",
    "reserved 0x8f",

    "reserved 0x90",
    "reserved 0x91",
    "reserved 0x92",
    "reserved 0x93",
    "reserved 0x94",
    "reserved 0x95",
    "reserved 0x96",
    "reserved 0x97",
    "reserved 0x98",
    "reserved 0x99",
    "reserved 0x9a",
    "reserved 0x9b",
    "reserved 0x9c",
    "reserved 0x9d",
    "reserved 0x9e",
    "reserved 0x9f",

    "reserved 0xa0",
    "reserved 0xa1",
    "reserved 0xa2",
    "reserved 0xa3",
    "reserved 0xa4",
    "MOVE_MEDIUM",            /* 0xa5 */
    "reserved 0xa6",
    "reserved 0xa7",
    "READ_12",                /* 0xa8 */
    "reserved 0xa9",
    "WRITE_12",               /* 0xaa */
    "reserved 0xab",
    "reserved 0xac",
    "reserved 0xad",
    "WRITE_VERIFY_12",        /* 0xae */
    "reserved 0xaf",

    "SEARCH_HIGH_12",         /* 0xb0 */
    "SEARCH_EQUAL_12",        /* 0xb1 */
    "SEARCH_LOW_12",          /* 0xb2 */
    "reserved 0xb3",
    "reserved 0xb4",
    "reserved 0xb5",
    "SEND_VOLUME_TAG",        /* 0xb6 */
    "reserved 0xb7",
    "READ_ELEMENT_STATUS",    /* 0xb8 */
    "reserved 0xb8",
    "reserved 0xb9",
    "reserved 0xba",
    "reserved 0xbb",
    "reserved 0xbc",
    "reserved 0xbd",
    "reserved 0xbe",
    "reserved 0xbf",

    "reserved 0xc0",
    "reserved 0xc1",
    "reserved 0xc2",
    "reserved 0xc3",
    "reserved 0xc4",
    "reserved 0xc5",
    "reserved 0xc6",
    "reserved 0xc7",
    "reserved 0xc8",
    "reserved 0xc9",
    "reserved 0xca",
    "reserved 0xcb",
    "reserved 0xcc",
    "reserved 0xcd",
    "reserved 0xce",
    "reserved 0xcf",

    "reserved 0xd0",
    "reserved 0xd1",
    "reserved 0xd2",
    "reserved 0xd3",
    "reserved 0xd4",
    "reserved 0xd5",
    "reserved 0xd6",
    "reserved 0xd7",
    "reserved 0xd8",
    "reserved 0xd9",
    "reserved 0xda",
    "reserved 0xdb",
    "reserved 0xdc",
    "reserved 0xdd",
    "reserved 0xde",
    "reserved 0xdf",

    "reserved 0xe0",
    "reserved 0xe1",
    "reserved 0xe2",
    "reserved 0xe3",
    "reserved 0xe4",
    "reserved 0xe5",
    "reserved 0xe6",
    "reserved 0xe7",
    "reserved 0xe8",
    "reserved 0xe9",
    "WRITE_LONG_2",           /* 0xea */
    "reserved 0xeb",
    "reserved 0xec",
    "reserved 0xed",
    "reserved 0xee",
    "reserved 0xef",

    "reserved 0xf0",
    "reserved 0xf1",
    "reserved 0xf2",
    "reserved 0xf3",
    "reserved 0xf4",
    "reserved 0xf5",
    "reserved 0xf6",
    "reserved 0xf7",
    "reserved 0xf8",
    "reserved 0xf9",
    "reserved 0xfa",
    "reserved 0xfb",
    "reserved 0xfc",
    "reserved 0xfd",
    "reserved 0xfe",
    "reserved 0xff",
};


