/*
    Copyright 2002, 2003, Steve Thompson <stevet010@softhome.net>

    This software is free for non-commercial, non-military use.

    Included with this package, you should have received a file called
    `Licensing' which contains detailed terms of use.

*/
#include <scsilib.h>





char *scsi_mode_pages[] = {
        "Supported mode pages page",
        "Read-Write Error Recovery",	/* 01h   8.3.3.6 */
        "Disconnect-Reconnect",		/* 02h   7.3.3.2 */
        "Format Device",		/* 03h   8.3.3.3 */
        "Rigid Disk Geometry",		/* 04h   8.3.3.7 */
        "Flexible Disk",		/* 05h   8.3.3.2 */
        "Unassigned",				
        "Verify Error Recovery",	/* 07h   8.3.3.8 */
        "Caching",			/* 08h   8.3.3.1 */
        "Peripheral Device",		/* 09h   7.3.3.3 */
        "Control Mode",			/* 0Ah   7.3.3.1 */
        "Medium Types Supported",	/* 0Bh   8.3.3.4 */
        "Notch and Partition",		/* 0Ch   8.3.3.5 */
        "Power Parameters/CD-ROM",	/* 0Dh           */
					/* 0Dh  13.3.3.2 */
        "CD-ROM Audio Control",		/* 0Eh  13.3.3.1 */
        "Device Configuration",		/* 10h   9.3.3.1 */
        "Medium Partition (1)",		/* 11h   9.3.3.2 */
        "Medium Partition (2)",		/* 12h   9.3.3.3 */
        "Medium Partition (3)",		/* 13h   9.3.3.3 */
        "Medium Partition (4)",		/* 14h   9.3.3.3 */

	[0x15 ... 0x1f] = "Undefined page",
	[0x20 ... 0x3e] = "Vendor Specific Page",
	[0x3f] = "Return All Pages",
	NULL
    };






int	scsi_unpack_mode_param(struct scsi_mode_param *param, void *pagep, void *descp)
{
	struct scsi_mode_page **page = pagep;
	struct scsi_mode_param_block_desc **desc = descp;
	size_t	page_len = 0;
	size_t	desc_len = 0;
	void *	p;


	assert(param);

	if(!page && !desc) {
	    errno = EINVAL;
	    return(0);
	}

	if(desc)
	    desc_len = param->desc_len;

	if(page)
	    page_len = 1 + param->mode_data_len - desc_len;

	p = param->p;

	if(desc_len) {
	    if(!*desc)
		if(!(*desc = malloc(desc_len)))
		    return(0);

	    memcpy(*desc, p, desc_len);
	    p += desc_len;
	}

	if(page_len) {
	    if(!*page)
		if(!(*page = malloc(page_len)))
		    return(0);

	    memcpy(*page, p, page_len);
	}

	return(1);
}




void	scsi_byteswap_mode_param_block_desc(struct scsi_mode_param_block_desc *desc)
{
    assert(desc);

    desc->block_count = U24TOS(desc->block_count);
    desc->block_len = U24TOS(desc->block_len);

    return;
}



void	scsi_byteswap_mode_param(struct scsi_mode_param *param)
{
    assert(param);

    if(param->desc_len)
	scsi_byteswap_mode_param_block_desc((void *)param->p);

    scsi_byteswap_mode_page((void *)(param->p + param->desc_len));

    return; 
}



void	scsi_byteswap_mode_param_10(struct scsi_mode_param_10 *param)
{
    assert(param);

    param->mode_data_len = U16TOS(param->mode_data_len);
    param->desc_len = U16TOS(param->desc_len);

    if(param->desc_len)
	scsi_byteswap_mode_param_block_desc((void *)param->p);

    scsi_byteswap_mode_page((void *)(param->p + param->desc_len));

    return;
}




void	scsi_byteswap_mode_page(struct scsi_mode_page *page)
{
    assert(page);

    switch(page->hdr.page_code) {
	case(MODE_DISCONNECT_RECONNECT):
	    page->u.disconnect.bus_inactivity_limit = U16TOS(page->u.disconnect.bus_inactivity_limit);
	    page->u.disconnect.disconnect_time_limit= U16TOS(page->u.disconnect.disconnect_time_limit);
	    page->u.disconnect.connect_time_limit = U16TOS(page->u.disconnect.connect_time_limit);
	    page->u.disconnect.maximum_burst_size = U16TOS(page->u.disconnect.maximum_burst_size);
	    page->u.disconnect.first_burst_size = U16TOS(page->u.disconnect.first_burst_size);
	    break;

	case(MODE_PERIPHERAL_DEVICE):
	    page->u.peripheral.interface_identifier = U16TOS(page->u.peripheral.interface_identifier);
	    break;

	case(MODE_CONTROL):
	    page->u.control.AER_holdoff_period = U16TOS(page->u.control.AER_holdoff_period);
	    page->u.control.busy_timeout_period = U16TOS(page->u.control.busy_timeout_period);
	    page->u.control.extended_self_test_completion_time = U16TOS(page->u.control.extended_self_test_completion_time);
	    break;

	case(MODE_POWER_CONDITIONS):
	    page->u.power.idle_condition_timer = U32TOS(page->u.power.idle_condition_timer);
	    page->u.power.standby_condition_timer = U32TOS(page->u.power.standby_condition_timer);
	    break;

	case(MODE_PROTOCOL_SPECIFIC_LUN):
	    break;

	case(MODE_PROTOCOL_SPECIFIC_PORT):
	    break;

	case(MODE_EXCEPTIONS):
	    page->u.exceptions.interval_timer = U32TOS(page->u.exceptions.interval_timer);
	    page->u.exceptions.report_count = U32TOS(page->u.exceptions.report_count);
	    break;

	case(MODE_ERROR_RECOVERY):
	    page->u.error.recovery_limit = U16TOS(page->u.error.recovery_limit);
	    break;

	case(MODE_FORMAT_DEVICE):
	    page->u.format.tracks_per_zone  = U16TOS(page->u.format.tracks_per_zone);
	    page->u.format.alternate_sectors_per_zone = U16TOS(page->u.format.alternate_sectors_per_zone);
	    page->u.format.alternate_tracks_per_zone = U16TOS(page->u.format.alternate_tracks_per_zone);
	    page->u.format.alternate_tracks_per_lun = U16TOS(page->u.format.alternate_tracks_per_lun);
	    page->u.format.sectors_per_track = U16TOS(page->u.format.sectors_per_track);
	    page->u.format.bytes_per_sector = U16TOS(page->u.format.bytes_per_sector);
	    page->u.format.interleave = U16TOS(page->u.format.interleave);
	    page->u.format.track_skew_factor = U16TOS(page->u.format.track_skew_factor);
	    page->u.format.cylinder_skew_factor = U16TOS(page->u.format.cylinder_skew_factor);
	    break;

	case(MODE_RIGID_DISK):
            page->u.rigid.cylinders = U16TOS(page->u.rigid.cylinders);
            page->u.rigid.write_precomp_lsb = U16TOS(page->u.rigid.write_precomp_lsb);
            page->u.rigid.reduced_current_lsb = U16TOS(page->u.rigid.reduced_current_lsb);
            page->u.rigid.step_rate = U16TOS(page->u.rigid.step_rate);
            page->u.rigid.landing_zone_lsb = U16TOS(page->u.rigid.landing_zone_lsb);
            page->u.rigid.rotation_rate = U16TOS(page->u.rigid.rotation_rate);
	    break;

	case(MODE_FLEXIBLE_DISK):
            page->u.flexible.transfer_rate = U16TOS(page->u.flexible.transfer_rate);
            page->u.flexible.sector_size = U16TOS(page->u.flexible.sector_size);
            page->u.flexible.cylinders = U16TOS(page->u.flexible.cylinders);
            page->u.flexible.write_precompensation = U16TOS(page->u.flexible.write_precompensation);
            page->u.flexible.reduced_write_current = U16TOS(page->u.flexible.reduced_write_current);
            page->u.flexible.step_rate = U16TOS(page->u.flexible.step_rate);
            page->u.flexible.head_settle_delay = U16TOS(page->u.flexible.head_settle_delay);
            page->u.flexible.rotation_rate = U16TOS(page->u.flexible.rotation_rate);
	    break;

	case(MODE_RBC_PARAMETER_LIST):
	    page->u.rbc.logical_block_size = U16TOS(page->u.rbc.logical_block_size);
	    page->u.rbc.logical_block_capacity = U32TOS(page->u.rbc.logical_block_capacity);
	    break;

	case(MODE_VERIFY_ERROR_RECOVERY):
	    page->u.verify.verify_recovery_time_limit = U16TOS(page->u.verify.verify_recovery_time_limit);
	    break;

	case(MODE_CACHING):
	    page->u.caching.disable_prefetch_transfer_length = U16TOS(page->u.caching.disable_prefetch_transfer_length);
	    page->u.caching.minimum_prefetch = U16TOS(page->u.caching.minimum_prefetch);
	    page->u.caching.maximum_prefetch = U16TOS(page->u.caching.maximum_prefetch);
	    page->u.caching.maximum_prefetch_ceiling = U16TOS(page->u.caching.maximum_prefetch_ceiling);
	    break;

	case(MODE_NOTCH_PARTITION):
	    page->u.notch.maximum_notches = U16TOS(page->u.notch.maximum_notches);
	    page->u.notch.active_notch = U16TOS(page->u.notch.active_notch);
	    page->u.notch.starting_boundary = U32TOS(page->u.notch.starting_boundary);
	    page->u.notch.ending_boundary = U32TOS(page->u.notch.ending_boundary);
	    break;

	case(MODE_MEDIUM_TYPES):
	    break;

	case(MODE_XOR_CONTROL):
            page->u.xor.maximum_xor_write_size = U32TOS(page->u.xor.maximum_xor_write_size);
            page->u.xor.maximum_regenerate_size = U32TOS(page->u.xor.maximum_regenerate_size);
            page->u.xor.maximum_rebuild_read_size = U32TOS(page->u.xor.maximum_rebuild_read_size);
	    page->u.xor.rebuild_delay = U16TOS(page->u.xor.rebuild_delay);
	    break;

	case(MODE_MEDIUM_PARTITION):
	    break;

	case(MODE_MEDIUM_PARTITION_2):
	case(MODE_MEDIUM_PARTITION_3):
	case(MODE_MEDIUM_PARTITION_4):
	    assert(0);
	    break;

#if 0
	case(MODE_DEVICE_CONFIGURATION):
	    page->u.device_configuration.write_delay_time = U16TOS(page->u.device_configuration.write_delay_time);
	    page->u.device_configuration.buffer_size_early_warning_lsb = U16TOS(page->u.device_configuration.buffer_size_early_warning_lsb);
	    break;
#endif
#if 0
	case(MODE_PRINTER_CONTROL):
	    page->u.printer.maximum_line_length = U16TOS(page->u.printer.maximum_line_length);
	    break;
#endif

	case(MODE_CDROM_AUDIO):
	    page->u.audio_control.audio_playback_rate = U16TOS(page->u.audio_control.audio_playback_rate);
	    break;

#if 0
	case(MODE_OPTICAL_MEMORY):
	    break;
#endif
    }

    return;
}






struct scsi_mode_param * scsi_dup_mode_param(struct scsi_mode_param *old)
{
    struct scsi_mode_param *new;

    assert(old);

    if(!(new = malloc(1 + old->mode_data_len)))
	return(NULL);

    memcpy(new, old, 1 + old->mode_data_len);

    return(new);
}
