/*
    Copyright 2002, 2003, Steve Thompson <stevet010@softhome.net>

    This software is free for non-commercial, non-military use.

    Included with this package, you should have received a file called
    `Licensing' which contains detailed terms of use.

*/

#include <scsilib.h>


int	scsi_set_sg_reserve_size(struct scsi_fd *fd, size_t size)
{
    assert(fd);

    if(ioctl(fd->fd, SG_SET_RESERVED_SIZE, &size) == -1)
	return(0);

    fd->len = size;

    return(1);
}


int scsi_get_sg_reserve_size(struct scsi_fd *fd)
{
    assert(fd);

    if(ioctl(fd->fd, SG_GET_RESERVED_SIZE, &fd->len) == -1)
	return(0);

    return(1);
}


void scsi_set_timeout(struct scsi_fd *fd, u32 timeout)
{
    assert(fd);

    fd->hdr.timeout = timeout;

    return;
}


u32 scsi_get_timeout(struct scsi_fd *fd)
{
    assert(fd);

    return(fd->hdr.timeout);
}


struct scsi_fd *    scsi_open_dev(char *file, int flags, size_t size)
{
    struct scsi_fd *sfd = NULL;

    assert(file);


    if(!(sfd = malloc(sizeof(struct scsi_fd))))
	return(NULL);

    sfd->fd = -1;
    sfd->len = 0;

    sfd->hdr.interface_id = 'S';
    sfd->hdr.dxfer_direction = SG_DXFER_NONE;
    sfd->hdr.cmd_len = 0;
    sfd->hdr.mx_sb_len = 32;
    sfd->hdr.iovec_count = 0;
    sfd->hdr.dxfer_len = 0;
    sfd->hdr.dxferp = NULL;
    sfd->hdr.cmdp = NULL;
    sfd->hdr.sbp = NULL;
    sfd->hdr.timeout = 20480;
    sfd->hdr.flags = 0;
    sfd->hdr.pack_id = 0;
    sfd->hdr.usr_ptr = 0;
    sfd->hdr.status = 0;
    sfd->hdr.msg_status = 0;
    sfd->hdr.sb_len_wr = 0;
    sfd->hdr.host_status = 0;
    sfd->hdr.driver_status = 0;
    sfd->hdr.resid = 0;
    sfd->hdr.duration = 0;
    sfd->hdr.info = 0;


    if((sfd->fd = open(file, O_RDWR, O_EXCL)) == -1)
	goto abt;

    if(size) {
	if(!scsi_set_sg_reserve_size(sfd, size)) {
	    fprintf(stderr, "Could not set sg buffer size - %m\n");
	    goto abt;
	}
    } else {
	if(!scsi_get_sg_reserve_size(sfd)) {
	    fprintf(stderr, "Could not get the sg buffer size - %m\n");
	    goto abt;
	}
    }

    if(!(sfd->hdr.sbp = malloc(32)))
	goto abt;

    if(!(sfd->hdr.cmdp = malloc(16)))
	goto abt;

    sfd->sector_size = 0;
    sfd->capacity = 0;

    return(sfd);


abt:
    scsi_close_dev(sfd);

    return(NULL);
}




void	scsi_close_dev(struct scsi_fd *sfd)
{
    if(sfd) {
	if(sfd->fd != -1)
	    close(sfd->fd);

	if(sfd->hdr.sbp)
	    free(sfd->hdr.sbp);

/*
	if(sfd->hdr.dxferp)
	    free(sfd->hdr.dxferp);
*/

	if(sfd->hdr.cmdp)
	    free(sfd->hdr.cmdp);

    }

    return;
}






