/*
    Copyright 2002, 2003, Steve Thompson <stevet010@softhome.net>

    This software is free for non-commercial, non-military use.

    Included with this package, you should have received a file called
    `Licensing' which contains detailed terms of use.

*/

#include <scsilib.h>


struct scsi_device_name *   scsi_get_device_name(struct scsi_inquiry *i)
{
    struct scsi_device_name *name = NULL;
    int c;
    char *p;


    assert(i);


    if(!(name = malloc(sizeof(struct scsi_device_name))))
	return(NULL);

    memset(name, 0, sizeof(struct scsi_device_name));


    switch INQUIRY_RDF(i) {
	case (0):
	    return(name);

	case (1):
	case (2):
	case (3):
	    break;

	case (4):
	    return(name);
    }


    p = name->vendor;
    for(c = 0 ; c < 8; c++)
	*p++ = i->u.s2.vendor_id[c];

    p = name->product;
    for(c = 0 ; c < 16; c++)
	*p++ = i->u.s2.product_id[c];
    
    p = name->revision;
    for(c = 0 ; c < 4; c++)
	*p++ = i->u.s2.product_rev[c];


    return(name);
}
