/*
    Copyright 2002, 2003, Steve Thompson <stevet010@softhome.net>

    This software is free for non-commercial, non-military use.

    Included with this package, you should have received a file called
    `Licensing' which contains detailed terms of use.

*/

#include <scsilib.h>




void	scsi_inquiry_text_print(FILE * stream, struct scsi_inquiry *i)
{
    char *p;
    int c;

    assert(stream && i);

    switch (INQUIRY_RDF(i)) {
	case (0):	/* SCSI 1 */
	    fprintf(stream, "Peripheral Device Type: %s (0x%02x)\n", 
			scsi_peripheral_device_type[i->u.s1.peripheral_device_type & 0x1f],
			i->u.s1.peripheral_device_type);

	    fprintf(stream, "Device Type Qualifier : %s (0x%02x)\n", 
			scsi_peripheral_qualifier[i->u.s1.device_type_qualifier & 0x7],
			i->u.s1.device_type_qualifier);

	    fprintf(stream, "Removable Medium      : %s\n\n", BOOLYN(i->u.s1.RMB));
	    fprintf(stream, "ANSI Version: %s (0x%02x)\n", scsi_ansi_approved_version[i->u.s1.ANSI+1], i->u.s1.ANSI);

	    fprintf(stream, "ECMA Version: %x\n", i->u.s1.ECMA);
	    fprintf(stream, "ISO Version : %x\n\n", i->u.s1.ISO);

	    fprintf(stream, "Reserved byte        : 0x%02x\n", i->u.s1.reserved);

/*	    fprintf(stream, "Additional Length: 0x%02x\n", i->u.s1.additional_length); */

	    if(i->u.s1.additional_length) {
		fprintf(stream, "Vendor specific bytes:\n\n");

		fflush(stream);

		hexdump(fileno(stream), 0, i->u.s1.vendor_unique, i->u.s1.additional_length);
	    }
    
	    break;

	case (1):	/* CCS	  */
	case (2):	/* SCSI 2 */
	case (3):	/* SCSI 3 */
	    fprintf(stream, "Peripheral Device Type: %s (0x%02x)\n", 
			    scsi_peripheral_device_type[i->u.s2.peripheral_device_type & 0x1f],
			    i->u.s2.peripheral_device_type);

	    fprintf(stream, "Peripheral Qualifier  : %s (0x%02x)\n", 
			    scsi_peripheral_qualifier[i->u.s2.peripheral_qualifier & 0x7],
			    i->u.s2.peripheral_qualifier);

	    fprintf(stream, "Device Type Modifier  : 0x%02d\n", i->u.s2.device_type_modifier);

	    fprintf(stream, "Removable Medium      : %s\n\n", BOOLYN(i->u.s2.RMB));
	    fprintf(stream, "ANSI Version: %s (0x%02x)\n", scsi_ansi_approved_version[i->u.s2.ANSI+1], i->u.s2.ANSI);

	    fprintf(stream, "ECMA Version: %x\n", i->u.s2.ECMA);
	    fprintf(stream, "ISO Version:  %x\n\n", i->u.s2.ISO);

	    if(INQUIRY_RDF(i) == 3) {
		fprintf(stream, "AERC:    %-3s  NormACA: %-3s  RDF: %x\n", 
				    BOOLYN(i->u.s3.AERC),
				    BOOLYN(i->u.s3.NormACA), i->u.s3.response_data_format);
	    } else {
		fprintf(stream, "AENC:    %-3s  TrmIOP: %-3s  RDF:    %x\n", BOOLYN(i->u.s2.AENC),
				    BOOLYN(i->u.s2.TrmIOP), i->u.s2.response_data_format);
	    }

	    if(i->u.s2.additional_length) {
		if(INQUIRY_RDF(i) == 3) {
		    fprintf(stream, "Resvd:   %-3s  EncServ: %-3s  VS:      %-3s   MultiP: %-3s\n",
				    BOOLYN(i->u.s3.reserved3), BOOLYN(i->u.s3.EncServ), 
				    BOOLYN(i->u.s3.VS1), BOOLYN(i->u.s3.MultiP));

		    fprintf(stream, "Mchngr:  %-3s  ACKREQQ: %-3s  Addr16: %-3s\n",
				    BOOLYN(i->u.s3.RelAdr),
				    BOOLYN(i->u.s3.WBus16), BOOLYN(i->u.s3.Sync));

		    fprintf(stream, "RelAddr: %-3s  WBus16:  %-3s  Sync:  %-3s\n",
				    BOOLYN(i->u.s3.RelAdr), 
				    BOOLYN(i->u.s3.WBus16), BOOLYN(i->u.s3.Sync));

		    fprintf(stream, "Linked:  %-3s  CmdQue:  %-3s  VS2: %-3s  \n",
				    BOOLYN(i->u.s3.Linked), 
				    BOOLYN(i->u.s3.CmdQue), BOOLYN(i->u.s3.VS2));
		} else {
		    fprintf(stream, "RelAddr: %-3s  WBus32: %-3s  WBus16: %-3s  Sync: %-3s\n",
				    BOOLYN(i->u.s2.RelAdr), BOOLYN(i->u.s2.WBus32), 
				    BOOLYN(i->u.s2.WBus16), BOOLYN(i->u.s2.Sync));

		    fprintf(stream, "Linked:  %-3s  CmdQue: %-3s  SftRe:  %-3s\n",
				    BOOLYN(i->u.s2.Linked), BOOLYN(i->u.s2.CmdQue), 
				    BOOLYN(i->u.s2.SftRe));
		}

		fprintf(stream, "\nVendor ID:   ");
		for(c = 0 ; c < 8; c++)
		    fputc(i->u.s2.vendor_id[c], stream);
		fputc(' ', stream);

		fprintf(stream, "\nProduct ID:  ");
		for(c = 0 ; c < 16; c++)
		    fputc(i->u.s2.product_id[c], stream);
		fputc(' ', stream);


		fprintf(stream, "\nProduct Rev: ");
		for(c = 0 ; c < 4; c++)
		    fputc(i->u.s2.product_rev[c], stream);
		fputc(' ', stream);


		fprintf(stream, "\nVendor Info: ");

		p = i->u.s2.vendor_specific;

		while(isprint(*p) && ((((u32) p) - ((u32) i->u.s2.vendor_specific)) < 20))
		    fputc(*p++, stream);

		fputc('\n', stream);
	    }

	    if(i->u.s2.additional_length > (sizeof(struct scsi2_inquiry_data) - 7)) {
		fprintf(stream, "\nVendor specific bytes:\n\n");

		fflush(stream);
		hexdump(fileno(stream), 0, i->u.s2.vendor_data, (i->u.s2.additional_length + 4 - sizeof(struct scsi2_inquiry_data)));
	    }

	    break;

	default:
	    fprintf(stream, "Unknown response data format %x.\n\nDumping %d inquiry data bytes:\n", 
			INQUIRY_RDF(i), sizeof(struct scsi_inquiry));

	    fflush(stream);
	    hexdump(fileno(stream), 0, i, sizeof(struct scsi_inquiry));

	    break;
    }


    return;
}



/*
 * Stolen from linux/include/scsi/scsi.h
 */
const char *scsi_peripheral_qualifier[] = {
    "Peripheral device is connected to this LUN.",
    "Target is capable of supporting this device type, device is not connected to this LUN.",
    "SCSI 3 Reserved",
    "Target cannot support this physical device type on this LUN.",
    "Vendor specific",
    "Vendor specific",
    "Vendor specific",
    "Vendor specific",
    NULL
};

const char *scsi_peripheral_device_type[] = {
    "Direct access",
    "Sequential access",
    "Printer",
    "Processor",
    "WORM",
    "CD-ROM",
    "Scanner",
    "Optical memory",
    "Medium changer",
    "Communications device",
    "ASC IT8 (0Ah)",
    "ASC IT8 (0Bh)",
    "Storage Array Controller",
    "Enclosure Services Device",
    "Reserved (0Eh)",
    "Reserved (0Fh)",
    "Reserved (10h)",
    "Reserved (11h)",
    "Reserved (12h)",
    "Reserved (13h)",
    "Reserved (14h)",
    "Reserved (15h)",
    "Reserved (16h)",
    "Reserved (17h)",
    "Reserved (18h)",
    "Reserved (19h)",
    "Reserved (1Ah)",
    "Reserved (1Bh)",
    "Reserved (1Ch)",
    "Reserved (1Dh)",
    "Reserved (1Eh)",
    "Unknown",
    NULL
};



