/*
    Copyright 2002, 2003, Steve Thompson <stevet010@softhome.net>

    This software is free for non-commercial, non-military use.

    Included with this package, you should have received a file called
    `Licensing' which contains detailed terms of use.

*/

#include <stdio.h>
#include <malloc.h>
#include <errno.h>
#include <string.h>
#include <ctype.h>
#include <assert.h>
#include <unistd.h>

/*
    Hexdump format:

    00000000 00000000 00000000 00000000 ................

    line length = 52 + 2

*/

#define LINE_LEN	54
#define LINE_NL_BYTE	53


/*
    hexdump_16()

*/
char *	hexdump_16(void *data, size_t l, char *b)
{
    char	    *buf = NULL;
    char	    *q;
    unsigned char   *p = data;
    size_t	    len;
    int		    c = 0;

    assert(data);
    
    len = l;

    if(len < 0 || len >16) {
	errno=EINVAL;
	return(NULL);
    }

    if(!len)
	len = 16;

    if(b)
	buf = b;
    else
	buf = malloc(LINE_LEN + 1);

    if(!buf)
	return(NULL);

    memset(buf, ' ', LINE_LEN);

    buf[LINE_LEN] = 0x00;
    buf[LINE_NL_BYTE] = 0x00;

    q = buf;

    while(len > 0) {
	q += sprintf(q, "%02x", *p);

	if(++c == 4) {
	    *q++ = ' ';
	    c = 0;
	}

	p++;

	len--;
    }

    *q++ = ' ';

    len = l;

    q = buf + 9 * 4;
    p = data;

    while(len) {
	char *r = p;

	*q++ = ((isalpha(*r) || isdigit(*r) || (*r == ' ') || ispunct(*r)) ? *r : '.');

	p++;
	len--;
    }

    return(buf);
}


char ** hexdump_data(void *data, size_t len)
{
    char ** dump = NULL;
    char *  p;
    int	    c;
    int	    i;
    int	    lines;


    assert(data);

    lines = len / 16 + 1;


    if(!(dump = malloc(sizeof(char *) * (lines + 1))))
	return(NULL);

    memset(dump, 0, sizeof(char *) * (lines + 1));

    c = len;
    p = data;
    i = 0;

    while(c > 16) {
	if(!(dump[i] = hexdump_16(p, 16, NULL)))
	    goto abt;

	i++;
	p += 16;
	c -= 16;
    }

    if(!(dump[i] = hexdump_16(p, c, NULL)))
	goto abt;
    
    return(dump);


abt:
    if(dump) {
	i = 0;

	while(dump[i])
	    free(dump[i++]);

	free(dump);
    }

    return(NULL);
}



void hexdump_addnl(char **dump)
{
    int i = 0;

    while(dump[i]) {
	dump[i][59] = '\n';

	i++;
    }
    
    return;
}



void hexdump_free(char **dump)
{
    int i = 0;

    while(dump[i])
	free(dump[i++]);

    free(dump);
    
    return;
}



void hexdump_print(int fd, size_t addr, char **dump)
{
    char    buf[12];
    int	    i = 0;
    char    c = '\n';


    assert(fd && dump);

    while(dump[i]) {
	sprintf(buf, "%08x:  ", addr);
	write(fd, buf, 11);

	write(fd, dump[i], LINE_LEN - 1);

	write(fd, &c, 1);

	addr += 16;
	i++;
    }

    return;
}




int hexdump(int fd, size_t addr, void *data, size_t len)
{
    char **dump;


    if(!(dump = hexdump_data(data, len)))
	return(0);

    hexdump_print(fd, addr, dump);

    hexdump_free(dump);

    return(1);
}
