/*
    Copyright 2002, 2003, Steve Thompson <stevet010@softhome.net>

    This software is free for non-commercial, non-military use.

    Included with this package, you should have received a file called
    `Licensing' which contains detailed terms of use.

*/

#include <scsilib.h>


/* 
 * scsi_cdb_alloc()
 *
 *  Note, this command is a holdover it should not be used.
 */
struct scsi_cdb *	scsi_cdb_alloc(u8 opcode, u32 lba, u32 tpa)
{
    struct scsi_cdb *cdb = NULL;

    switch(SCSI_OPCODE_GROUP(opcode)) {
        case(0):
	    if(!(cdb = malloc(sizeof(struct scsi_cdb6))))
		return(NULL);
    
	    SET_CDB6_OPCODE(cdb, opcode);
	    SET_CDB6_LUN(cdb, 0);
	    SET_CDB6_LBA(cdb, lba);
	    SET_CDB6_TPA(cdb, tpa);
	    break;
    
        case(1):
        case(2):
        case(6):
        case(7):
	    if(!(cdb = malloc(sizeof(struct scsi_cdb10))))
		return(NULL);
    
	    SET_CDB10_OPCODE(cdb, opcode);
	    SET_CDB10_LUN(cdb, 0);
	    SET_CDB10_LBA(cdb, lba);
	    SET_CDB10_TPA(cdb, tpa);
	    break;
    
        case(5):
	    if(!(cdb = malloc(sizeof(struct scsi_cdb12))))
		return(NULL);
    
	    SET_CDB12_OPCODE(cdb, opcode);
	    SET_CDB12_LUN(cdb, 0);
	    SET_CDB12_LBA(cdb, lba);
	    SET_CDB12_TPA(cdb, tpa);
	    break;
    
        case(4):
	    if(!(cdb = malloc(sizeof(struct scsi_cdb16))))
		return(NULL);
    
	    SET_CDB16_OPCODE(cdb, opcode);
	    SET_CDB16_LUN(cdb, 0);
	    SET_CDB16_LBA(cdb, lba);
	    SET_CDB16_TPA(cdb, tpa);
	    break;
    
    	default:
	    free(cdb);
	    errno=EINVAL;
	    return(NULL);
    }

    return(cdb);
}




/*
    scsi_cdb_dump()

*/
void		scsi_cdb_dump(FILE *fp, struct scsi_cdb *cdb)
{
    int c, i;

    assert(fp && cdb);


    fprintf(fp, "CDB: %s  ", scsi_opcode[CDB_OPCODE(cdb)]);

    switch(CDB_OPCODE_GROUP(cdb)) {
	case(0):
	    c = 6;
	    break;

	case(1):
	case(2):
	case(6):
	case(7):
	    c = 10;
	    break;

	case(4):
	    c = 12;
	    break;

	case(5):
	    c = 12;

	default:
	    c = 16;
    }

    for(i = 0; i < c ; i++)
	fprintf(fp, " %02x", cdb->u.b[i]);

    fputc('\n', fp);
}





/*
 * scsi_cdb_dup()
 *
 *
 * NOTE: This only copies the CDB
 * 
 */
struct scsi_cdb *	scsi_cdb_dup(struct scsi_cdb *cdb)
{
    struct scsi_cdb *p;
    int		    c;

    switch(CDB_OPCODE_GROUP(cdb)) {
	case(0):
	    c = 6;
	    break;

	case(1):
	case(2):
	case(6):
	case(7):
	    c = 10;
	    break;

	case(4):
	    c = 12;
	    break;

	case(5):
	    c = 12;

	default:
	    c = 16;
    }


    if(!(p = malloc(c)))
	return(NULL);

    memcpy(p, cdb, c);

    return(p);
}

