/*
    Copyright 2002, 2003, Steve Thompson <stevet010@softhome.net>

    This software is free for non-commercial, non-military use.

    Included with this package, you should have received a file called
    `Licensing' which contains detailed terms of use.

*/

#include <scsilib.h>

/*
    scsi_capacity_dump()

 */
void	    scsi_capacity_dump(FILE *fp, struct scsi_capacity *p)
{

    assert(fp && p);

    fprintf(fp, "-------------------------\n");
    fprintf(fp, "scsi_capacity: %p\n", p);
    fprintf(fp, "-------------------------\n");

    fprintf(fp, "capacity    : 0x%08x\n", p->capacity);
    fprintf(fp, "sector size : 0x%08x\n", p->sector_size);

    return;
}



void	    byteswap_struct_scsi_capacity(struct scsi_capacity *p)
{
    assert(p);

    p->capacity = U32TOS(p->capacity);
    p->sector_size = U32TOS(p->sector_size);

    return;
}
