/*
    Copyright 2002, 2003, Steve Thompson <stevet010@softhome.net>

    This software is free for non-commercial, non-military use.

    Included with this package, you should have received a file called
    `Licensing' which contains detailed terms of use.

*/

#ifndef VITAL_PRODUCT_DATA_H
#define VITAL_PRODUCT_DATA_H


/*
    VPD header
*/
struct scsi_vpd_header {
    u8      peripheral_device:5;
    u8      peripheral_qualifier:3;
    u8      page_code;
    u8      reserved;
    u8      page_len;
    u8      b[0];
};



/*
    Supported Vital Product Data Pages

 */
#define VPD_SUPPORTED_PAGES		    0x00

struct scsi_vpd_supported_pages {
    u8	    peripheral_device:5;
    u8	    peripheral_qualifier:3;
    u8	    page_code;
    u8	    reserved;
    u8	    page_len;
    u8	    page_list[0];
} __attribute__ ((packed));


/*
    Serial Number			    0x80
*/
struct scsi_vpd_serial_number {
    u8      peripheral_device:5;
    u8      peripheral_qualifier:3;
    u8      page_code;
    u8      reserved;
    u8      page_len;
    u8      text[0];
} __attribute__((packed));

#define VPD_SERIAL_NUMBER		    0x80


/*
    Implemented Operating Definition Page   0x81

*/
#define VPD_OPERATING_DEFINITION	    0x81

struct vpd_op_def {
    u8	    SavImp:1;
    u8	    def:7;
} __attribute__ ((packed));

struct scsi_vpd_op_def {
    u8			peripheral_device:5;
    u8			peripheral_qualifier:3;
    u8			page_code;
    u8			reserved;
    u8			page_len;
    struct vpd_op_def	definition[0];
} __attribute__ ((packed));


/*
    ASCII Implemented Operating Definition  0x82

*/

#define VPD_ASCII_OPERATING_DEFINITION	0x82

struct scsi_vpd_ascii_op_def {
    u8	    peripheral_device:5;
    u8	    peripheral_qualifier:3;
    u8	    page_code;
    u8	    reserved;
    u8	    page_len;
    u8	    ascii_def_len;
    u8	    ascii_def[0];
} __attribute__ ((packed));


/*
    ASCII Information page

*/
#define VPD_ASCII_INFORMATION(p)	(((p) > 0) && ((p) < 0x80))

struct scsi_vpd_ascii_info {
    u8	    peripheral_device:5;
    u8	    peripheral_qualifier:3;
    u8	    page_code;
    u8	    reserved;
    u8	    page_len;
    u8	    ascii_len;
    u8	    ascii_info[0];
} __attribute__ ((packed));


/*
    Device Identification Page		0x83

*/
#define VPD_DEVICE_IDENTIFICATION	0x83

/*
    SPC 8.4.4

    code set:
    
	0	reserved
	1	binary data
	2	ASCII data
	3	reserved


    identifier type:

	0	No assignement authority;
	1	first 8 bytes are a vendor ID
	2	EUI-64
	3	FC-PH, 64bits.  As seen in X3.230-1994
	4 - 15	reserved

*/

struct scsi_vpd_ident_desc {
    u8	    code_set:4;
    u8	    reserved1:4;
    u8	    identifier_type:4;
    u8	    association:2;
    u8	    reserved2:2;
    u8	    reserved3;
    u8	    identifier_len;
    u8	    identifier[0];
} __attribute__ ((packed));

#define SCSI_ID_CODE_SET_BINARY	    0x1
#define SCSI_ID_CODE_SET_ASCII	    0x2

#define SCSI_ASSOCIATION_PHYSICAL   0x0
#define SCSI_ASSOCIATION_PORT	    0x1


struct scsi_vpd_device_ident {
    u8	    peripheral_device:5;
    u8	    peripheral_qualifier:3;
    u8	    page_code;
    u8	    reserved;
    u8	    page_len;
    struct scsi_vpd_ident_desc desc[0];
} __attribute__ ((packed));







struct scsi_vpd_page {
    union {
	struct scsi_vpd_header		hdr;
	struct scsi_vpd_supported_pages	supported;
	struct scsi_vpd_serial_number	serial_no;
	struct scsi_vpd_op_def		op_def;
	struct scsi_vpd_ascii_op_def	ascii_op_def;
	struct scsi_vpd_ascii_info	ascii_page;
	struct scsi_vpd_device_ident	device_id;
	u8				b[0];
    } u;
} __attribute__ ((packed));



#define VPD_PAGECODE(p)	    ((p)->u.hdr.page_code)
#define VPD_PAGE_LEN(p)	    ((p)->u.hdr.page_len)
#define VPD_PAGE_SIZE(p)    (4 + (p)->u.hdr.page_len)







void    scsi_byteswap_vpd_page(struct scsi_vpd_page *);
void	scsi_vpd_page_text(FILE *, struct scsi_vpd_page *);


#endif

