/*
    Copyright 2002, 2003, Steve Thompson <stevet010@softhome.net>

    This software is free for non-commercial, non-military use.

    Included with this package, you should have received a file called
    `Licensing' which contains detailed terms of use.

*/

#ifndef SCSILIB_SENSE_H
#define SCSILIB_SENSE_H



/* 
    REQUEST SENSE data defs

*/
struct scsi_sense {
    u8	    error_code:7;
    u8	    valid:1;
    u8	    segment;
    u8	    sense_key:4;
    u8	    reserved:1;
    u8	    ILI:1;
    u8	    EOM:1;
    u8	    filemark:1;
    u32	    information;
    u8	    ASL;
    u32	    CSI;
    u8	    ASC;
    u8	    ASCQ;
    u32	    SKS:23;
    u32	    SKSV:1;
    u32	    fru_code:8;
    u8	    ASB[0];
} __attribute__ ((packed));



/*
    The pointer is cast for arbitrary access.
    
*/
#define SENSE_DATA_VALID(p)   ((((struct scsi_sense *)p)->error_code >> 4) == 7)

#define SENSE_ERROR(p)		(((struct scsi_sense *)p)->sense_key)
#define SENSE_VALID(p)		(((struct scsi_sense *)p)->valid)
#define SENSE_SEGMENT(p)	(((struct scsi_sense *)p)->segment)
#define SENSE_KEY(p)		(((struct scsi_sense *)p)->sense_key)
#define SENSE_ILI(p)		(((struct scsi_sense *)p)->ILI)
#define SENSE_EOM(p)		(((struct scsi_sense *)p)->EOM)
#define SENSE_FILEMARK(p)	(((struct scsi_sense *)p)->filemark)
#define SENSE_INFORMATION(p)	(((struct scsi_sense *)p)->information)
#define SENSE_ASL(p)		(((struct scsi_sense *)p)->ASL)
#define SENSE_CSI(p)		(((struct scsi_sense *)p)->CSI)
#define SENSE_ASC(p)		(((struct scsi_sense *)p)->ASC)
#define SENSE_ASCQ(p)		(((struct scsi_sense *)p)->ASCQ)
#define SENSE_FRU(p)		(((struct scsi_sense *)p)->fru_code)
#define SENSE_SKSV(p)		(((struct scsi_sense *)p)->SKSV)
#define SENSE_SKS(p)		((((struct scsi_sense *)p)->SKS << 8) \
				    | ((struct scsi_sense *)p)->SKS_LSB)
#define SENSE_VDATA(p)		(((struct scsi_sense *)p)->ASB)

/* FIXME: 
#define SENSE_SKS_CD(p)	    (SENSE_SKS(p) >> 23)
#define SENSE_SKS_BPV(p)    
#define SENSE_SKS_BITP(p)   
#define SENSE_SKS_FIELDP(p) 
*/


/*
 *  SENSE KEYS
 */
#define NO_SENSE            0x00
#define RECOVERED_ERROR     0x01
#define NOT_READY           0x02
#define MEDIUM_ERROR        0x03
#define HARDWARE_ERROR      0x04
#define ILLEGAL_REQUEST     0x05
#define UNIT_ATTENTION      0x06
#define DATA_PROTECT        0x07
#define BLANK_CHECK         0x08
#define VENDOR_SPECIFIC_9   0x09
#define COPY_ABORTED        0x0a
#define ABORTED_COMMAND     0x0b
#define SENSE_EQUAL	    0x0c
#define VOLUME_OVERFLOW     0x0d
#define MISCOMPARE          0x0e
#define SENSE_RESERVED	    0x0f


extern const char *scsi_sense_key[];




/*
    ASC and ASCQ defs

*/
struct scsi_asc_ascq {
    u16	    asc;
    u16	    ascq;
    u16	    mask;
    char *  text;
};


extern const struct scsi_asc_ascq *scsi_asc_ascq_table[];





void	scsi_sense_dump(FILE *, void *);
void	scsi_byteswap_sense_data(void *);
int	scsi_sense_valid(void *);
char *	scsi_sense_additional_text(u8, u8);

#endif
