/*
    Copyright 2002, 2003, Steve Thompson <stevet010@softhome.net>

    This software is free for non-commercial, non-military use.

    Included with this package, you should have received a file called
    `Licensing' which contains detailed terms of use.

*/

#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <ctype.h>
#include <errno.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/sysmacros.h>
#include <sys/mman.h>
#include <sys/time.h>
#include <netinet/in.h>

#include <scsi/sg.h>

#include <assert.h>

typedef unsigned char           u8;
typedef unsigned short int      u16;
typedef unsigned int		u24;
typedef unsigned int            u32;
typedef unsigned long long int  u64;

#ifdef LITTLE_ENDIAN

#define U16TOS(n)            htons(n)
#define U24TOS(n)	     ((((n) & 0x0000ff) << 16) | ((n) & 0x00ff00) | (((n) & 0xff0000) >> 16) )
#define U32TOS(n)            htonl(n)
#define STOU16(n)            ntohs(n)
#define STOU24(n)	     U24TOS(n)
#define STOU32(n)            ntohl(n)

#else

#define U16TOS(n)            (n)
#define U24TOS(n)	     (n)
#define U32TOS(n)            (n)
#define STOU16(n)            (n)
#define STOU24(n)            (n)
#define STOU32(n)            (n)

#endif



#define BOOLYN(b)	((b) ? "Yes" : "No")
#define BOOLTRUTH(b)	((b) ? "True" : "False")
#define BOOLSWITCH(b)	((b) ? "On" : "Off")

#define BIT(b)                  (1 << (b))
#define SET(word, bit)          { (word) = (word) | BIT(bit); }
#define CLR(word, bit)          { (word) = (word) & ~BIT(bit); }
#define TST(word, bit)          (((word) & BIT(bit)))

#define SETB(ptr, bit)          SET((*(((char *) ptr) + (bit >> 3))), 7-(bit & 0x07))
#define CLRB(ptr, bit)          CLR((*(((char *) ptr) + (bit >> 3))), 7-(bit & 0x07))
#define TSTB(ptr, bit)          TST((*(((char *) ptr) + (bit >> 3))), 7-(bit & 0x07))



/*
    SCSI Library include files

*/
#include <hex.h>

#include <io.h>

#include <buffer.h>
#include <capacity.h>
#include <cdb.h>
#include <format.h>
#include <copy.h>
#include <compare.h>
#include <definition.h>
#include <inquiry.h>
#include <logpage.h>
#include <modepage.h>
#include <opcode.h>
#include <sense.h>
#include <status.h>
#include <vpd.h>

#include <inquiry_lib.h>
#include <vpd_lib.h>




