/*
    Copyright 2002, 2003, Steve Thompson <stevet010@softhome.net>

    This software is free for non-commercial, non-military use.

    Included with this package, you should have received a file called
    `Licensing' which contains detailed terms of use.

*/

#ifndef SCSI_OPCODE_H
#define SCSI_OPCODE_H


/*
 * Opcode Support Data Format
 *
 * T10/955 R11a  7.5.4
 */
struct scsi_opcode_support_data {
    u8	    peripheral_device:5;
    u8	    peripheral_qualifier:3;
    u8	    supported:3;
    u8	    reserved1:5;
    u8	    reserved2[2];
    u8	    cdb_size;
    u8	    usage_data[0];
} __attribute__ ((packed));


#define OPCODE_SUPPORTED_NODATA	    0
#define OPCODE_SUPPORTED_NO	    1
#define OPCODE_SUPPORTED_YES	    3
#define OPCODE_SUPPORTED_VENDOR	    5

#define OPCODE_SUPPORTED_PAGE_LEN(p)	((p)->cdb_size + sizeof(struct scsi_opcode_support_data))




/*
 *      SCSI opcodes
 */
#define TEST_UNIT_READY			0x00
#define REWIND				0x01
#define REZERO_UNIT			0x01
#define REQUEST_SENSE			0x03
#define FORMAT_UNIT			0x04
#define FORMAT_MEDIUM			0x04
#define FORMAT				0x04
#define READ_BLOCK_LIMITS		0x05
#define REASSIGN_BLOCKS			0x07
#define	INITIALIZE_ELEMENT_STATUS	0x07
#define READ_6				0x08
#define RECEIVE				0x08
#define GET_MESSAGE			0x08
#define WRITE_6				0x0a
#define SEND				0x0a
#define SEND_MESSAGE			0x0a
#define PRINT				0x0a
#define SEEK_6				0x0b
#define SLEW_AND_PRINT			0x0b
#define READ_REVERSE			0x0f
#define WRITE_FILEMARKS			0x10
#define SYNCHRONIZE_BUFFER		0x10
#define SPACE				0x11
#define INQUIRY				0x12
#define RECOVER_BUFFERED_DATA		0x14
#define MODE_SELECT			0x15
#define RESERVE				0x16
#define RESERVE_ELEMENT_6		0x16
#define RELEASE				0x17
#define RELEASE_ELEMENT_6		0x17
#define COPY				0x18
#define ERASE				0x19
#define MODE_SENSE			0x1a
#define START_STOP_UNIT			0x1b
#define LOAD_UNLOAD			0x1b
#define SCAN_10				0x1b
#define RECEIVE_DIAGNOSTIC		0x1c
#define SEND_DIAGNOSTIC			0x1d
#define PREVENT_ALLOW_MEDIUM_REMOVAL	0x1e

#define SET_WINDOW			0x24
#define READ_CAPACITY			0x25
#define READ_CD_RECORDED_CAPACITY	0x25
#define GET_WINDOW			0x25
#define READ_10				0x28
#define RECIEVE_10			0x28
#define GET_MESSAGE_10			0x28
#define WRITE_10			0x2a
#define SEND_10				0x2a
#define SEND_MESSAGE_10			0x2a
#define SEEK_10				0x2b
#define LOCATE				0x2b
#define POSITION_TO_ELEMENT		0x2b
#define ERASE_10			0x2c
#define READ_UPDATED_BLOCK		0x2d	/* vendor specific for D */
#define WRITE_AND_VERIFY		0x2e
#define VERIFY_10			0x2f
#define SEARCH_DATA_HIGH		0x30
#define SEARCH_DATA_EQUAL		0x31
#define OBJECT_POSITION			0x31
#define SEARCH_DATA_LOW			0x32
#define SET_LIMITS			0x33
#define PRE_FETCH			0x34
#define READ_POSITION			0x34
#define GET_DATA_BUFFER_STATUS		0x34
#define SYNCHRONIZE_CACHE		0x35
#define LOCK_UNLOCK_CACHE		0x36
#define READ_DEFECT_DATA		0x37
#define MEDIUM_SCAN			0x38
#define COMPARE				0x39
#define COPY_AND_VERIFY			0x3a
#define WRITE_BUFFER			0x3b
#define READ_BUFFER			0x3c
#define UPDATE_BLOCK			0x3d
#define READ_LONG			0x3e
#define WRITE_LONG			0x3f
#define CHANGE_DEFINITION		0x40
#define WRITE_SAME			0x41
#define READ_SUB_CHANNEL		0x42
#define READ_TOC_PMA_ATIP		0x43
#define REPORT_DENSITY_SUPPORT		0x44
#define READ_HEADER			0x44
#define PLAY_AUDIO_10			0x45

#define PLAY_AUDIO_MSF			0x47
#define PLAY_AUDIO_TRACK_INDEX		0x48
#define PLAY_AUDIO_TRACK_RELATIVE_10	0x49

#define PAUSE_RESUME			0x4b
#define LOG_SELECT			0x4c
#define LOG_SENSE			0x4d
#define STOP_PLAY_SCAN			0x4e

#define XDWRITE				0x50
#define XPWRITE				0x51
#define READ_DISK_INFORMATION		0x51
#define XDREAD				0x52
#define READ_TRACK_INFORMATION		0x52
#define RESERVE_TRACK			0x53
#define SEND_OPC_INFORMATION		0x54
#define MODE_SELECT_10			0x55
#define RESERVE_10			0x56
#define RESERVE_ELEMENT_10		0x56
#define RELEASE_10			0x57
#define RELEASE_ELEMENT_10		0x57
#define REPAIR_TRACK			0x58
#define READ_MASTER_CUE			0x59
#define MODE_SENSE_10			0x5a
#define CLOSE_TRACK_SESSION		0x5b
#define READ_BUFFER_CAPACITY		0x5c
#define SEND_CUE_SHEET			0x5d
#define PERSISTENT_RESERVE_IN		0x5e
#define PERSISTENT_RESERVE_OUT		0x5f

#define XDWRITE_EXTENDED_16		0x80
#define REBUILD_16			0x81
#define REGENERATE_16			0x82

#define REPORT_LUNS			0xa0
#define BLANK				0xa1
#define WRITE_CD_MSF			0xa2
#define MAINTENANCE_IN			0xa3
#define MAINTENANCE_OUT			0xa4
#define MOVE_MEDIUM			0xa5
#define PLAY_AUDIO_12			0xa5
#define EXCHANGE_MEDIUM			0xa6
#define LOAD_UNLOAD_CD			0xa6
#define MOVE_MEDIUM_ATTACHED		0xa7
#define READ_12				0xa8
#define GET_MESSAGE_12			0xa8
#define PLAY_TRACK_RELATIVE_12		0xa9
#define WRITE_12			0xaa
#define WRITE_CD_12			0xaa
#define SEND_MESSAGE_12			0xaa
#define WRITE_AND_VERIFY_12		0xae
#define VERIFY_12			0xaf
#define SEARCH_DATA_HIGH_12		0xb0
#define SEARCH_DATA_EQUAL_12		0xb1
#define SEARCH_DATA_LOW_12		0xb2
#define SET_LIMITS_12			0xb3
#define READ_ELEMENT_STATUS_ATTACHED	0xb4
#define REQUEST_VOLUME_ELEMENT_ADDRESS	0xb5
#define SEND_VOLUME_TAG			0xb6
#define READ_DEFECT_DATA_12		0xb7
#define READ_ELEMENT_STATUS		0xb8
#define SET_CD_SPEED			0xb8
#define READ_CD_MSF			0xb9
#define SCAN_12				0xba
#define REDUNDANCY_GROUP_IN		0xba
#define SET_CD_ROM_SPEED		0xbb
#define REDUNDANCY_GROUP_OUT		0xbb
#define PLAY_CD				0xbc
#define SPARE_IN			0xbc
#define MECHANISM_STATUS		0xbd
#define SPARE_OUT			0xbd
#define READ_CD				0xbe
#define VOLUME_SET_IN			0xbe
#define VOLUME_SET_OUT			0xbf

#define WRITE_LONG_12			0xea



int				scsi_FORMAT_UNIT(struct scsi_fd *, int, u32, void *, u16, u8, u8, void *, u16, u8, u32);
void *				scsi_INQUIRY(struct scsi_fd *, void *, size_t, u32, u8);
void *				scsi_LOG_SENSE(struct scsi_fd *, void *, u8, u8, struct scsi_logpage_param *, u16, u32);
void *				scsi_LOG_SELECT(struct scsi_fd *, void *, u16, u8, u32);
struct scsi_mode_param *	scsi_MODE_SENSE(struct scsi_fd *, void *, u16, u8, u8, u32);
struct scsi_mode_param_10 *	scsi_MODE_SENSE_10(struct scsi_fd *, void *, u16, u8, u8, u32);
int				scsi_MODE_SELECT(struct scsi_fd *, struct scsi_mode_param *, u32);
int				scsi_MODE_SELECT_10(struct scsi_fd *, struct scsi_mode_param_10 *, u32);
void *				scsi_READ_BUFFER(struct scsi_fd *, u8, u8, u32, void *, u32);
void *				scsi_READ_6(struct scsi_fd *, void *, u32, u16);
void *				scsi_READ_10(struct scsi_fd *, void *, u32, u16, u32);
void *				scsi_READ_12(struct scsi_fd *, void *, u32, u32, u32);
struct scsi_defect_list_header *scsi_READ_DEFECT_DATA(struct scsi_fd *, void *, u16, u32, u8);
struct scsi_defect_list_header_12 *scsi_READ_DEFECT_DATA_12(struct scsi_fd *, void *, u32, u32, u8);
struct scsi_capacity *		scsi_READ_CAPACITY(struct scsi_fd *, u32, u32);
void *				scsi_READ_LONG(struct scsi_fd *, void *, u32, u16, u32);
int				scsi_REASSIGN_BLOCKS(struct scsi_fd *, struct scsi_reassign_blocks_header *);
void *				scsi_RECEIVE_DIAGNOSTIC(struct scsi_fd *, void *, u16);
int				scsi_REZERO_UNIT(struct scsi_fd *);
int				scsi_SEND_DIAGNOSTIC(struct scsi_fd *, void *, u16, u32);
int				scsi_START_STOP_UNIT(struct scsi_fd *, u32);
int				scsi_TEST_UNIT_READY(struct scsi_fd *, int);
int				scsi_WRITE_6(struct scsi_fd *, void *, u32, u16);
int				scsi_WRITE_10(struct scsi_fd *, void *, u32, u16, u32);
int				scsi_WRITE_12(struct scsi_fd *, void *, u32, u32, u32);
int				scsi_WRITE_AND_VERIFY(struct scsi_fd *, void *, u32, u16, u32);
int				scsi_WRITE_LONG(struct scsi_fd *, void *, u32, u16, u32);
int				scsi_WRITE_SAME(struct scsi_fd *, void *, u32, u16, u32);
int				scsi_VERIFY_10(struct scsi_fd *, void *, u32, u16, u32);

#endif

