/*
    Copyright 2002, 2003, Steve Thompson <stevet010@softhome.net>

    This software is free for non-commercial, non-military use.

    Included with this package, you should have received a file called
    `Licensing' which contains detailed terms of use.

*/

#ifndef SCSI_LOGPAGE_H
#define SCSI_LOGPAGE_H

extern const char *scsi_log_pages[];



/*
 * Log Page Codes
 */
#define LOGPAGE_SUPPORTED_PAGES		    0x00    /* 8.3.2.5 */
#define LOGPAGE_BUFFER_OVERRUN_UNDERRUN	    0x01    /* 8.3.2.1 */
#define LOGPAGE_CTR_READ_ERROR		    0x03    /* 8.3.2.2 */
#define LOGPAGE_CTR_READ_REVERSE_ERROR	    0x04    /* 8.3.2.2 */
#define LOGPAGE_CTR_VERIFY_ERROR	    0x05    /* 8.3.2.2 */
#define LOGPAGE_CTR_WRITE_ERROR		    0x02    /* 8.3.2.2 */
#define LOGPAGE_LAST_N_ERROR_EVENTS	    0x07    /* 8.3.2.3 */
#define LOGPAGE_NON_MEDIUM_ERROR	    0x05    /* 8.3.2.4 */



/*
    Buffer Overrun/Underrun Definitions
*/

struct scsi_buffer_ctr_param {
    u8	reserved;
    u8	type:1;
    u8	cause:4;
    u8	basis:3;
};

#define CNT_BUF_BASIS_UNDEF	0x0
#define CNT_BUF_BASIS_CMD	0x1
#define CNT_BUF_BASIS_RECONN    0x2
#define CNT_BUF_BASIS_TIME	0x3


#define CNT_BUF_CAUSE_UNDEF	0x0
#define CNT_BUF_CAUSE_BUSY	0x1
#define CNT_BUF_CAUSE_SLOW	0x2

#define CNT_BUF_TYPE_UNDERRUN   0x0
#define CNT_BUF_TYPE_OVERRUN    0x1


/*
    Error Counter Events Pages

    0x0007 - 0x7fff	Reserved
    0x6000 - 0xffff	Vendor Specific
*/
#define CNT_ERR_CORRECT_FAST	0x0000
#define CNT_ERR_CORRECT_SLOW	0x0001
#define CNT_ERR_TOTAL_RETRIES	0x0002
#define CNT_ERR_TOTAL_CORRECT	0x0003
#define CNT_ERR_TOTAL_ECC	0x0004
#define CNT_ERR_BYTES_CORRECT	0x0005
#define CNT_ERR_TOTAL_UNCORR	0x0006


/*
    Last n Error Events Page

    0x0000 - 0xffff	Vendor Specific
*/


/* 
    Non Medium error page

    0x0001 - 0x7fff	Reserved
    0x8000 - 0xffff	Vendor Specific
*/
#define CNT_NON_MEDIUM_ERR_CNT	0x0000



struct scsi_logpage_param {
    union {
	struct scsi_buffer_ctr_param	buf;
	u16				err;
	u16				event;
    } u;
};

#endif
