/*
    Copyright 2002, 2003, Steve Thompson <stevet010@softhome.net>

    This software is free for non-commercial, non-military use.

    Included with this package, you should have received a file called
    `Licensing' which contains detailed terms of use.

*/

struct scsi_fd {
    int                     fd;
    size_t                  len;
    struct sg_io_hdr        hdr;
    struct sg_scsi_id       id;
    u32			    sector_size;
    u32			    capacity;
};


int		    scsi_set_sg_reserve_size(struct scsi_fd *, size_t);
int		    scsi_get_sg_reserve_size(struct scsi_fd *);
void		    scsi_set_timeout(struct scsi_fd *, u32);
u32		    scsi_get_timeout(struct scsi_fd *);
struct scsi_fd *    scsi_open_dev(char *, int, size_t);
void		    scsi_close_dev(struct scsi_fd *);
