/*
    Copyright 2002, 2003, Steve Thompson <stevet010@softhome.net>

    This software is free for non-commercial, non-military use.

    Included with this package, you should have received a file called
    `Licensing' which contains detailed terms of use.

*/

#ifndef SCSI_FORMAT_H
#define SCSI_FORMAT_H


/*
    SCSI block address formats

*/

extern	int scsi_addr_desc_len[];

extern	char * scsi_addr_desc_type[];

#define ADDR_DESC_LOGICAL	0x00
#define ADDR_DESC_INDEX		0x04
#define ADDR_DESC_PHYSICAL	0x05



struct scsi_addr_desc_logical {
    u32     sector;
} __attribute__((packed));


struct scsi_addr_desc_index {
    u32     cyl:24;
    u32     head:8;
    u32     offset;
} __attribute__((packed));


struct scsi_addr_desc_physical {
    u32     cyl:24;
    u32     head:8;
    u32     sector;
} __attribute__((packed));



struct scsi_addr_desc {
    union {
	struct scsi_addr_desc_logical	logical;
	struct scsi_addr_desc_index	index;
	struct scsi_addr_desc_physical	physical;
    } u;
};



/*
    Defect list header for the FORMAT UNIT command.

*/
struct scsi_format_defect_list_header {
    u8	    reserved;
    u8	    VS:1;
    u8	    Immed:1;
    u8	    DSP:1;
    u8	    IP:1;
    u8	    STPF:1;
    u8	    DCRT:1;
    u8	    DPRY:1;
    u8	    FOV:1;
    u16	    list_len;
} __attribute__((packed));

struct scsi_format_long_defect_list_header {
    u8	    reserved;
    u8	    VS:1;
    u8	    Immed:1;
    u8	    DSP:1;
    u8	    IP:1;
    u8	    STPF:1;
    u8	    DCRT:1;
    u8	    DPRY:1;
    u8	    FOV:1;
    u32	    list_len;
} __attribute__((packed));


#define DLH_VS	    0x0001
#define DLH_IMMED   0x0002
#define DLH_DSP	    0x0004
#define DLH_IP	    0x0008
#define DLH_STPF    0x0010
#define DLH_DCRT    0x0020
#define DLH_DPRY    0x0040
#define DLH_FOV	    0x0080





/*
    Initialisation Pattern descriptor for the FORMAT UNIT command.

*/
struct scsi_initialisation_pattern {
    u8	    reserved:6;
    u8	    IP_modifier:2;
    u8	    pattern_type;
    u16	    pattern_length;
    u8	    pattern[0];
} __attribute__((packed));



/*
    Defect list header for the READ DEFECT DATA command.

*/
struct scsi_defect_list_header {
    u8                  reserved;
    u8                  format:3;
    u8                  Glist:1;
    u8                  Plist:1;
    u8                  reserved2:3;
    u16                 list_len;
    u8                  defect_list[0];
} __attribute__ ((packed));



/*
    Defect list header for the READ DEFECT DATA (12) command.

*/
struct scsi_defect_list_header_12 {
    u8                  reserved;
    u8                  format:3;
    u8                  Glist:1;
    u8                  Plist:1;
    u8                  reserved2:3;
    u32                 list_len;
    u8                  defect_list[0];
} __attribute__ ((packed));


/*
    Defect list header for the REASSIGN BLOCKS (6) command.

*/
struct scsi_reassign_blocks_header {
    u8	    reserved1;
    u8	    reserved2;
    u16	    list_len;
    u32	    descriptor[0];
};



void	scsi_byteswap_addr_desc(struct scsi_addr_desc *, u8);
void	scsi_byteswap_defect_list(void *, u32, u8);
void	scsi_byteswap_defect_list_header(struct scsi_defect_list_header *, u16, u8);
void	scsi_byteswap_defect_list_header_12(struct scsi_defect_list_header_12 *, u32, u8);

void	scsi_print_defect_list_header(FILE *, struct scsi_defect_list_header *, int);
void	scsi_print_defect_list_header_12(FILE *, struct scsi_defect_list_header_12 *, int);
void	scsi_print_format_defect_list_header(FILE *, struct scsi_format_defect_list_header *);
void	scsi_print_defect_list(FILE *, void *, u32, u8);

int     scsi_write_defect_list(FILE *, void *, u32, u8);
int     scsi_read_defect_list(FILE *, void *, u32 *);


int     scsi_get_long_sector_size(struct scsi_fd *, u32);

#endif

