/*
    Copyright 2002, 2003, Steve Thompson <stevet010@softhome.net>

    This software is free for non-commercial, non-military use.

    Included with this package, you should have received a file called
    `Licensing' which contains detailed terms of use.

*/


/*
    All device types	    (8.3.1.1)
*/
#define DIAG_PAGE_SUPPORTED_PAGES	0x00

struct scsi_diagnostic_supported {
    u8	    page_code;
    u8	    reserved;
    u16	    page_length;
    u8	    supported_page[0];
}



/*
    Direct Access devices   (9.3.1)
*/
#define DIAG_PAGE_TRANSLATE_ADDRESS	0x40

struct scsi_diagnostic_translate_address {
    u8			    page_code;
    u8			    reserved;
    u16			    page_length;
    u8			    supplied_format:3;
    u8			    reserved1:5;
    u8			    translate_format:3:
    u8			    reserved2:2;
    u8			    ALTRTRK:1;
    u8			    ALTSECL:1;
    u8			    RAREA:1;
    struct scsi_addr_desc   addr[0];
} __attribute__((packed));
	    









#define scsi_byteswap_diagnostic_page(struct scsi_diagnostic_page *);


