/*
    Copyright 2002, 2003, Steve Thompson <stevet010@softhome.net>

    This software is free for non-commercial, non-military use.

    Included with this package, you should have received a file called
    `Licensing' which contains detailed terms of use.

*/

#ifndef SCSI_COPY_H
#define SCSI_COPY_H

/*
 * COPY command parameter list definitions
 */


struct copy_segment_descriptor_00 {
    u8	    source_lun:3;
    u8	    Cat:1;
    u8	    reserved1:1;
    u8	    source_address:3;
    u8	    destination_lun:3;
    u8	    reserved2:2;
    u8	    destination_address:3;
    u16	    stream_device_block_length;
    u16	    block_device_number_of_blocks;
    u16	    block_device_logical_block_address;
} __attribute__ ((packed));

#define copy_segment_descriptor_01	copy_segment_descriptor_00


struct copy_segment_descriptor_02 {
    u8	    source_lun:3;
    u8	    Cat:1;
    u8	    DC:1;
    u8	    source_address:3;
    u8	    destination_lun:3;
    u8	    reserved2:2;
    u8	    destination_address:3;
    u32	    number_of_blocks;
    u32	    source_LBA;
    u32	    destination_LBA;
} __attribute__ ((packed));

struct copy_segment_descriptor_03 {
    u8	    source_lun:3;
    u8	    Cat:1;
    u8	    DC:1;
    u8	    source_address:3;
    u8	    destination_lun:3;
    u8	    reserved1:2;
    u8	    destination_address:3;
    u16	    reserved2;
    u16	    number_of_blocks;
    u32	    source_LBA;
    u32	    destination_LBA;
} __attribute__ ((packed));

struct copy_segment_descriptor_04 {
    u8	    source_lun:3;
    u8	    reserved1:2;
    u8	    source_address:3;
    u8	    destination_lun:3;
    u8	    reserved2:2;
    u8	    destination_address:3;
    u8	    count;
    u16	    reserved3;
    u32	    vendor_specific;
} __attribute__ ((packed));


/*
 * SCSI 3
 */
struct copy_segment_descriptor_0a {
    u8	    reserved1:3;
    u8	    Cat:1;
    u8	    reserved2:4;
    u8	    reserved3;
    u64	    source_target_identifier;
    u64	    source_logical_unit_number;
    u64	    destination_target_identifier;
    u64	    destination_logical_unit_number;
    u16	    stream_device_block_length;
    u32	    block_device_number_of_blocks;
    u32	    block_device_LBA;
} __attribute__ ((packed));

#define copy_segment_descriptor_0b copy_segment_descriptor_0a


struct copy_segment_descriptor_0c {
    u8	    reserved1:3;
    u8	    Cat:1;
    u8	    DC:1;
    u8	    reserved2:3;
    u8	    reserved3;
    u64	    source_target_identifier;
    u64	    source_logical_unit_number;
    u64	    destination_target_identifier;
    u64	    destination_logical_unit_number;
    u8	    reserved4[2];
    u32	    number_of_blocks;
    u32	    source_LBA;
    u32	    destination_LBA;
} __attribute__ ((packed));






struct scsi_copy_plist {
    u8	    priority:3;
    u8	    function_code:5;
    u16	    reserved1;
    union {
	    struct copy_segment_descriptor_00	sd0[0];
	    struct copy_segment_descriptor_01	sd1[0];
	    struct copy_segment_descriptor_02	sd2[0];
	    struct copy_segment_descriptor_03	sd3[0];
	    struct copy_segment_descriptor_04	sd4[0];
	    struct copy_segment_descriptor_0a	sda[0];
	    struct copy_segment_descriptor_0b	sdb[0];
	    struct copy_segment_descriptor_0c	sdc[0];
	    u8					b[0];
    } u;
} __attribute__ ((packed));



#endif

